/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.ir.visitors.IrTransformer;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0012\u0010\u000e\u001a\u00020\u000fX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010R\u0012\u0010\u0011\u001a\u00020\u000fX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0010\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/KlibAssertionRemoverLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "throwingErrorEnabled", "", "argumentEvaluationEnabled", "<init>", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;ZZ)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "getThrowingErrorEnabled", "()Z", "getArgumentEvaluationEnabled", "isAssertionThrowingErrorEnabled", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "()Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "isAssertionArgumentEvaluationEnabled", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "ir.backend.common"})
public abstract class KlibAssertionRemoverLowering
implements FileLoweringPass {
    @NotNull
    private final CommonBackendContext context;
    private final boolean throwingErrorEnabled;
    private final boolean argumentEvaluationEnabled;

    public KlibAssertionRemoverLowering(@NotNull CommonBackendContext context, boolean throwingErrorEnabled, boolean argumentEvaluationEnabled) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.throwingErrorEnabled = throwingErrorEnabled;
        this.argumentEvaluationEnabled = argumentEvaluationEnabled;
    }

    @NotNull
    public final CommonBackendContext getContext() {
        return this.context;
    }

    public final boolean getThrowingErrorEnabled() {
        return this.throwingErrorEnabled;
    }

    public final boolean getArgumentEvaluationEnabled() {
        return this.argumentEvaluationEnabled;
    }

    @NotNull
    protected abstract IrSimpleFunctionSymbol isAssertionThrowingErrorEnabled();

    @NotNull
    protected abstract IrSimpleFunctionSymbol isAssertionArgumentEvaluationEnabled();

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        IrElementTransformerVoidKt.transformChildrenVoid(irFile, new IrElementTransformerVoid(this){
            final /* synthetic */ KlibAssertionRemoverLowering this$0;
            {
                this.this$0 = $receiver;
            }

            public IrExpression visitWhen(IrWhen expression) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                if (expression.getBranches().size() != 1) {
                    return super.visitWhen(expression);
                }
                IrBranch branch = (IrBranch)CollectionsKt.first(expression.getBranches());
                IrExpression condition = branch.getCondition();
                if (!(condition instanceof IrCall)) {
                    return super.visitWhen(expression);
                }
                IrSimpleFunctionSymbol irSimpleFunctionSymbol = ((IrCall)condition).getSymbol();
                if (Intrinsics.areEqual((Object)irSimpleFunctionSymbol, (Object)this.this$0.isAssertionThrowingErrorEnabled())) {
                    bl = this.this$0.getThrowingErrorEnabled();
                } else if (Intrinsics.areEqual((Object)irSimpleFunctionSymbol, (Object)this.this$0.isAssertionArgumentEvaluationEnabled())) {
                    bl = this.this$0.getArgumentEvaluationEnabled();
                } else {
                    return super.visitWhen(expression);
                }
                boolean flag = bl;
                return flag ? branch.getResult().transform((IrTransformer)this, (Object)null) : (IrExpression)BuildersKt.IrCompositeImpl$default(expression.getStartOffset(), expression.getEndOffset(), expression.getType(), null, 8, null);
            }

            public IrExpression visitCall(IrCall expression) {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                if (Intrinsics.areEqual((Object)expression.getSymbol(), (Object)this.this$0.isAssertionThrowingErrorEnabled())) {
                    return IrConstImpl.Companion.boolean(expression.getStartOffset(), expression.getEndOffset(), expression.getType(), this.this$0.getThrowingErrorEnabled());
                }
                if (Intrinsics.areEqual((Object)expression.getSymbol(), (Object)this.this$0.isAssertionArgumentEvaluationEnabled())) {
                    return IrConstImpl.Companion.boolean(expression.getStartOffset(), expression.getEndOffset(), expression.getType(), this.this$0.getArgumentEvaluationEnabled());
                }
                return super.visitCall(expression);
            }
        });
    }
}

