/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.core.resolve;

import com.intellij.debugger.streams.core.resolve.ValuesOrderResolver;
import com.intellij.debugger.streams.core.trace.TraceElement;
import com.intellij.debugger.streams.core.trace.TraceInfo;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/debugger/streams/core/resolve/FilteredMapResolver;", "Lcom/intellij/debugger/streams/core/resolve/ValuesOrderResolver;", "<init>", "()V", "resolve", "Lcom/intellij/debugger/streams/core/resolve/ValuesOrderResolver$Result;", "info", "Lcom/intellij/debugger/streams/core/trace/TraceInfo;", "intellij.debugger.streams.core"})
public final class FilteredMapResolver
implements ValuesOrderResolver {
    @Override
    @NotNull
    public ValuesOrderResolver.Result resolve(@NotNull TraceInfo info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Map<Integer, TraceElement> map = info.getValuesOrderBefore();
        Intrinsics.checkNotNullExpressionValue(map, (String)"getValuesOrderBefore(...)");
        Map<Integer, TraceElement> before = map;
        Map<Integer, TraceElement> map2 = info.getValuesOrderAfter();
        Intrinsics.checkNotNullExpressionValue(map2, (String)"getValuesOrderAfter(...)");
        Map<Integer, TraceElement> after = map2;
        Map invertedOrder = new LinkedHashMap();
        int[] beforeTimes = CollectionsKt.toIntArray((Collection)CollectionsKt.sorted((Iterable)before.keySet()));
        int[] afterTimes = CollectionsKt.toIntArray((Collection)CollectionsKt.sorted((Iterable)after.keySet()));
        int beforeIndex = 0;
        for (int afterTime : afterTimes) {
            while (beforeIndex < beforeTimes.length && afterTime > beforeTimes[beforeIndex]) {
                ++beforeIndex;
            }
            int beforeTime = beforeTimes[beforeIndex - 1];
            if (beforeTime >= afterTime) continue;
            invertedOrder.put(afterTime, beforeTime);
        }
        Map direct = new LinkedHashMap();
        Map reverse = new LinkedHashMap();
        for (Map.Entry entry : invertedOrder.entrySet()) {
            int afterTime = ((Number)entry.getKey()).intValue();
            int beforeTime = ((Number)entry.getValue()).intValue();
            TraceElement beforeElement = (TraceElement)MapsKt.getValue(before, (Object)beforeTime);
            TraceElement afterElement = (TraceElement)MapsKt.getValue(after, (Object)afterTime);
            direct.put(beforeElement, CollectionsKt.listOf((Object)afterElement));
            reverse.put(afterElement, CollectionsKt.listOf((Object)beforeElement));
        }
        ValuesOrderResolver.Result result = ValuesOrderResolver.Result.of(direct, reverse);
        Intrinsics.checkNotNullExpressionValue((Object)result, (String)"of(...)");
        return result;
    }
}

