/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation;

import com.intellij.rt.coverage.data.JumpData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.SwitchData;
import com.intellij.rt.coverage.instrumentation.CoverageEnumerator;
import com.intellij.rt.coverage.instrumentation.data.InstrumentationData;
import com.intellij.rt.coverage.instrumentation.data.Jump;
import com.intellij.rt.coverage.instrumentation.data.Switch;
import com.intellij.rt.coverage.instrumentation.data.SwitchLabels;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.coverage.org.objectweb.asm.Handle;
import org.jetbrains.coverage.org.objectweb.asm.Label;

public class CoverageEnumeratorWithInstructions
extends CoverageEnumerator {
    private final Map<Label, Jump> myOriginalLabelToJump = new HashMap<Label, Jump>();
    private final Map<Label, Switch> myOriginalLabelToSwitch = new HashMap<Label, Switch>();
    private Jump myLastJump;
    private Label myLastLabel;
    private int myInstructionCounter;
    private boolean myHasInstructions = false;

    /*
     * WARNING - void declaration
     */
    public CoverageEnumeratorWithInstructions(InstrumentationData data, boolean branchCoverage) {
        super((InstrumentationData)var1_1, (boolean)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void saveInstructionsToOwner() {
        LineData lineData = this.myData.getLineData(this.myCurrentLine);
        if (this.myInstructionCounter > 0 && lineData != null) {
            boolean applied;
            block10: {
                void index2;
                Jump jump = this.myLastJump != null ? this.myLastJump : (this.myLastLabel == null ? null : this.myOriginalLabelToJump.get(this.myLastLabel));
                Switch aSwitch = this.myLastLabel == null ? null : this.myOriginalLabelToSwitch.get(this.myLastLabel);
                applied = false;
                if (jump != null) {
                    int jumpId = jump.getId();
                    for (int index2 = 0; index2 < lineData.jumpsCount(); ++index2) {
                        JumpData jumpData = lineData.getJumpData(index2);
                        if (jumpData.getId(true) == jumpId) {
                            this.myData.addInstructions(jumpId, this.myInstructionCounter);
                            applied = true;
                        } else {
                            if (jumpData.getId(false) != jumpId) continue;
                            this.myData.addInstructions(jumpId, this.myInstructionCounter);
                            applied = true;
                        }
                        break;
                    }
                } else if (index2 != null) {
                    int switchId = index2.getId();
                    for (int index3 = 0; index3 < lineData.switchesCount(); ++index3) {
                        SwitchData switchData = lineData.getSwitchData(index3);
                        for (int i = -1; i < switchData.getKeys().length; ++i) {
                            if (switchData.getId(i) != switchId) continue;
                            this.myData.addInstructions(switchId, this.myInstructionCounter);
                            applied = true;
                            break block10;
                        }
                    }
                }
            }
            if (!applied) {
                void var1_1;
                this.myData.addInstructions(var1_1.getId(), this.myInstructionCounter);
            }
        }
        this.myLastLabel = null;
        this.myLastJump = null;
        this.myInstructionCounter = 0;
    }

    /*
     * WARNING - void declaration
     */
    protected void onNewJump(Label originalLabel, Label trueLabel, Label falseLabel) {
        void var2_2;
        void var1_1;
        void var3_3;
        this.myLastJump = this.myData.getJump((Label)var3_3);
        this.myOriginalLabelToJump.put((Label)var1_1, this.myData.getJump((Label)var2_2));
    }

    protected void onNewSwitch(SwitchLabels original, SwitchLabels replacement) {
        this.myOriginalLabelToSwitch.put(original.getDefault(), this.myData.getSwitch(replacement.getDefault()));
        for (int i = 0; i < original.getLabels().length; ++i) {
            this.myOriginalLabelToSwitch.put(original.getLabels()[i], this.myData.getSwitch(replacement.getLabels()[i]));
        }
    }

    public void visitEnd() {
        this.saveInstructionsToOwner();
        super.visitEnd();
    }

    /*
     * WARNING - void declaration
     */
    public void visitLabel(Label label) {
        super.visitLabel(label);
        this.saveInstructionsToOwner();
        if (this.myOriginalLabelToJump.containsKey(label) || this.myOriginalLabelToSwitch.containsKey(label)) {
            void var1_1;
            this.myLastLabel = var1_1;
            return;
        }
        this.myLastLabel = null;
    }

    /*
     * WARNING - void declaration
     */
    public void visitJumpInsn(int opcode, Label label) {
        void var2_2;
        void var1_1;
        this.touch();
        this.saveInstructionsToOwner();
        super.visitJumpInsn((int)var1_1, (Label)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.touch();
        this.saveInstructionsToOwner();
        super.visitLookupSwitchInsn((Label)var1_1, (int[])var2_2, (Label[])var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.touch();
        this.saveInstructionsToOwner();
        super.visitTableSwitchInsn((int)var1_1, (int)var2_2, (Label)var3_3, labels);
    }

    /*
     * WARNING - void declaration
     */
    public void visitTypeInsn(int opcode, String type) {
        void var2_2;
        void var1_1;
        super.visitTypeInsn((int)var1_1, (String)var2_2);
        this.touch();
    }

    /*
     * WARNING - void declaration
     */
    public void visitMultiANewArrayInsn(String descriptor, int numDimensions) {
        void var2_2;
        void var1_1;
        super.visitMultiANewArrayInsn((String)var1_1, (int)var2_2);
        this.touch();
    }

    /*
     * WARNING - void declaration
     */
    public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
        void var3_3;
        void var2_2;
        void var1_1;
        super.visitMethodInsn((int)var1_1, (String)var2_2, (String)var3_3, descriptor, isInterface);
        this.touch();
    }

    /*
     * WARNING - void declaration
     */
    public void visitLdcInsn(Object value) {
        void var1_1;
        super.visitLdcInsn(var1_1);
        this.touch();
    }

    /*
     * WARNING - void declaration
     */
    public void visitInvokeDynamicInsn(String name, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
        void var3_3;
        void var2_2;
        void var1_1;
        super.visitInvokeDynamicInsn((String)var1_1, (String)var2_2, (Handle)var3_3, bootstrapMethodArguments);
        this.touch();
    }

    /*
     * WARNING - void declaration
     */
    public void visitIntInsn(int opcode, int operand) {
        void var2_2;
        void var1_1;
        super.visitIntInsn((int)var1_1, (int)var2_2);
        this.touch();
    }

    /*
     * WARNING - void declaration
     */
    public void visitIincInsn(int var, int increment) {
        void var2_2;
        void var1_1;
        super.visitIincInsn((int)var1_1, (int)var2_2);
        this.touch();
    }

    /*
     * WARNING - void declaration
     */
    public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
        void var3_3;
        void var2_2;
        void var1_1;
        super.visitFieldInsn((int)var1_1, (String)var2_2, (String)var3_3, descriptor);
        this.touch();
    }

    /*
     * WARNING - void declaration
     */
    public void visitInsn(int opcode) {
        void var1_1;
        super.visitInsn(opcode);
        if (this.myHasInstructions && 172 <= opcode && var1_1 <= 177) {
            return;
        }
        this.touch();
    }

    /*
     * WARNING - void declaration
     */
    public void visitVarInsn(int opcode, int var) {
        void var2_2;
        void var1_1;
        super.visitVarInsn((int)var1_1, (int)var2_2);
        this.touch();
    }

    private void touch() {
        ++this.myInstructionCounter;
        this.myHasInstructions = true;
    }
}

