/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.builtins.functions.FunctionTypeKind;
import org.jetbrains.kotlin.builtins.functions.FunctionTypeKindKt;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.EffectiveVisibility;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirVisibilityCheckerKt;
import org.jetbrains.kotlin.fir.SessionHolder;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirInlineCheckerPlatformSpecificComponent;
import org.jetbrains.kotlin.fir.analysis.checkers.FirInlineCheckerPlatformSpecificComponentKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirInlineDeclarationCheckerKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirResolvedDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirAnonymousFunctionExpression;
import org.jetbrains.kotlin.fir.expressions.FirArgumentList;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirCallableReferenceAccess;
import org.jetbrains.kotlin.fir.expressions.FirDelegatedConstructorCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirLiteralExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirSuperReceiverExpression;
import org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.expressions.impl.FirResolvedArgumentList;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.transformers.PublishedApiEffectiveVisibilityKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirAnonymousFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirAnonymousObjectSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertyAccessorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.ArrayUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FunctionalTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.types.model.TypeSystemContextHelpersKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003:\u0001/B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJA\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u0012H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0015J-\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0002H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ-\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0018J5\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u001dJ\u0010\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 H\u0002J+\u0010!\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0014R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\"J!\u0010#\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\u0002H\u0002R\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010%J/\u0010&\u001a\u0010\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020)\u0018\u00010'2\u0006\u0010*\u001a\u00020+H\u0002R\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010,J\u0010\u0010-\u001a\u00020\u001a*\u0006\u0012\u0002\b\u00030.H\u0002\u00a8\u00060"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInlineDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFunctionChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirFunction;)V", "checkParameters", "function", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "overriddenSymbols", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;Ljava/util/List;)V", "checkParametersInNotInline", "checkNothingToInline", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;)V", "checkCanBeInlined", "", "effectiveVisibility", "Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;)Z", "isInlinableDefaultValue", "expression", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "checkCallableDeclaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;)V", "isNonLocalReturnAllowed", "inlineFunction", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/declarations/FirFunction;)Z", "extractCallAndParameter", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "anonymousFunction", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirAnonymousFunctionSymbol;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/symbols/impl/FirAnonymousFunctionSymbol;)Lkotlin/Pair;", "isArrayLambdaConstructor", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;", "InlineFunctionBodyContext", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirInlineDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirInlineDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInlineDeclarationChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 5 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n*L\n1#1,594:1\n42#2:595\n55#2:596\n55#2:597\n36#2:598\n55#2:599\n30#2:606\n1761#3,3:600\n1761#3,3:603\n28#4:607\n60#5,4:608\n*S KotlinDebug\n*F\n+ 1 FirInlineDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInlineDeclarationChecker\n*L\n47#1:595\n418#1:596\n422#1:597\n469#1:598\n469#1:599\n512#1:606\n470#1:600,3\n472#1:603,3\n537#1:607\n548#1:608,4\n*E\n"})
public final class FirInlineDeclarationChecker
extends FirDeclarationChecker<FirFunction> {
    @NotNull
    public static final FirInlineDeclarationChecker INSTANCE = new FirInlineDeclarationChecker();

    private FirInlineDeclarationChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirFunction declaration) {
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        FirMemberDeclaration $this$isInline$iv = declaration;
        boolean $i$f$isInline = false;
        if (!$this$isInline$iv.getStatus().isInline()) {
            this.checkParametersInNotInline(context2, reporter, declaration);
            return;
        }
        FirInlineCheckerPlatformSpecificComponent firInlineCheckerPlatformSpecificComponent = FirInlineCheckerPlatformSpecificComponentKt.getInlineCheckerExtension(context2.getSession());
        boolean bl = firInlineCheckerPlatformSpecificComponent != null ? !firInlineCheckerPlatformSpecificComponent.isGenerallyOk(context2, reporter, declaration) : false;
        if (bl) {
            return;
        }
        if (!(declaration instanceof FirPropertyAccessor) && !(declaration instanceof FirSimpleFunction)) {
            return;
        }
        this.checkCallableDeclaration(context2, reporter, declaration);
    }

    private final void checkParameters(CheckerContext context2, DiagnosticReporter reporter, FirSimpleFunction function2, List<? extends FirCallableSymbol<? extends FirCallableDeclaration>> overriddenSymbols) {
        block9: {
            for (FirValueParameter firValueParameter : function2.getValueParameters()) {
                ConeKotlinType coneType = TypeExpansionUtilsKt.fullyExpandedType((SessionHolder)context2, FirTypeUtilsKt.getConeType(firValueParameter.getReturnTypeRef()));
                FunctionTypeKind functionKind = FunctionalTypeUtilsKt.functionTypeKind$default(coneType, context2.getSession(), false, 2, null);
                boolean isFunctionalType = functionKind != null;
                FunctionTypeKind functionTypeKind = functionKind;
                boolean isSuspendFunctionType = functionTypeKind != null ? FunctionTypeKindKt.isSuspendOrKSuspendFunction(functionTypeKind) : false;
                FirExpression defaultValue = firValueParameter.getDefaultValue();
                if (!isFunctionalType && (firValueParameter.isNoinline() || firValueParameter.isCrossinline())) {
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)firValueParameter.getSource(), FirErrors.INSTANCE.getILLEGAL_INLINE_PARAMETER_MODIFIER(), null, 8, null);
                }
                if (firValueParameter.isNoinline()) continue;
                FirMemberDeclaration $this$isSuspend$iv = function2;
                boolean $i$f$isSuspend = false;
                if ($this$isSuspend$iv.getStatus().isSuspend() && defaultValue != null && isSuspendFunctionType) {
                    FirInlineCheckerPlatformSpecificComponent firInlineCheckerPlatformSpecificComponent = FirInlineCheckerPlatformSpecificComponentKt.getInlineCheckerExtension(context2.getSession());
                    if (firInlineCheckerPlatformSpecificComponent != null) {
                        firInlineCheckerPlatformSpecificComponent.checkSuspendFunctionalParameterWithDefaultValue(context2, reporter, firValueParameter);
                    }
                }
                if (isSuspendFunctionType && !firValueParameter.isCrossinline()) {
                    $this$isSuspend$iv = function2;
                    $i$f$isSuspend = false;
                    if (!$this$isSuspend$iv.getStatus().isSuspend()) {
                        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)firValueParameter.getSource(), FirErrors.INSTANCE.getINLINE_SUSPEND_FUNCTION_TYPE_UNSUPPORTED(), null, 8, null);
                    }
                }
                if (ConeTypeUtilsKt.isMarkedNullable(coneType) && isFunctionalType) {
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)firValueParameter.getSource(), FirErrors.INSTANCE.getNULLABLE_INLINE_PARAMETER(), (Object)firValueParameter.getSymbol(), (Object)function2.getSymbol(), null, 32, null);
                }
                if (!isFunctionalType || defaultValue == null || this.isInlinableDefaultValue(defaultValue)) continue;
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)defaultValue.getSource(), FirErrors.INSTANCE.getINVALID_DEFAULT_FUNCTIONAL_PARAMETER_FOR_INLINE(), (Object)firValueParameter.getSymbol(), null, 16, null);
            }
            if (!((Collection)overriddenSymbols).isEmpty()) {
                for (FirTypeParameter firTypeParameter : function2.getTypeParameters()) {
                    if (!firTypeParameter.isReified()) continue;
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)firTypeParameter.getSource(), FirErrors.INSTANCE.getREIFIED_TYPE_PARAMETER_IN_OVERRIDE(), null, 8, null);
                }
            }
            FirInlineCheckerPlatformSpecificComponent firInlineCheckerPlatformSpecificComponent = FirInlineCheckerPlatformSpecificComponentKt.getInlineCheckerExtension(context2.getSession());
            if (firInlineCheckerPlatformSpecificComponent == null) break block9;
            firInlineCheckerPlatformSpecificComponent.checkFunctionalParametersWithInheritedDefaultValues(context2, reporter, function2, overriddenSymbols);
        }
    }

    private final void checkParametersInNotInline(CheckerContext context2, DiagnosticReporter reporter, FirFunction function2) {
        for (FirValueParameter param : function2.getValueParameters()) {
            if (!param.isNoinline() && !param.isCrossinline()) continue;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)param.getSource(), FirErrors.INSTANCE.getILLEGAL_INLINE_PARAMETER_MODIFIER(), null, 8, null);
        }
    }

    private final void checkNothingToInline(CheckerContext context2, DiagnosticReporter reporter, FirSimpleFunction function2) {
        boolean hasInlinableParameters;
        FirSession session;
        block15: {
            boolean bl;
            boolean bl2;
            block14: {
                block17: {
                    block16: {
                        FirMemberDeclaration $this$isExpect$iv = function2;
                        boolean $i$f$isExpect = false;
                        if ($this$isExpect$iv.getStatus().isExpect()) break block16;
                        FirMemberDeclaration $this$isSuspend$iv = function2;
                        boolean $i$f$isSuspend = false;
                        if (!$this$isSuspend$iv.getStatus().isSuspend()) break block17;
                    }
                    return;
                }
                Iterable $this$any$iv = function2.getTypeParameters();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FirTypeParameter it = (FirTypeParameter)element$iv;
                        boolean bl3 = false;
                        if (!it.getSymbol().isReified()) continue;
                        bl2 = true;
                        break block14;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                return;
            }
            session = context2.getSession();
            Iterable $this$any$iv = function2.getValueParameters();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FirValueParameter it = (FirValueParameter)element$iv;
                    boolean bl4 = false;
                    if (!FirInlineDeclarationCheckerKt.access$isInlinable(it, context2.getSession())) continue;
                    bl = true;
                    break block15;
                }
                bl = hasInlinableParameters = false;
            }
        }
        if (hasInlinableParameters) {
            return;
        }
        if (FirHelpersKt.isInlineOnly(function2, session)) {
            return;
        }
        if (DeclarationUtilsKt.needsMultiFieldValueClassFlattening(function2.getReturnTypeRef(), session)) {
            return;
        }
        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)function2.getSource(), FirErrors.INSTANCE.getNOTHING_TO_INLINE(), null, 8, null);
    }

    private final boolean checkCanBeInlined(CheckerContext context2, DiagnosticReporter reporter, FirCallableDeclaration declaration, EffectiveVisibility effectiveVisibility) {
        if (ClassMembersKt.containingClassLookupTag(declaration) == null) {
            return true;
        }
        if (Intrinsics.areEqual(effectiveVisibility, EffectiveVisibility.PrivateInClass.INSTANCE)) {
            return true;
        }
        if (!DeclarationUtilsKt.isEffectivelyFinal(declaration)) {
            KtSourceElement ktSourceElement = declaration.getSource();
            if (!Intrinsics.areEqual(ktSourceElement != null ? ktSourceElement.getKind() : null, KtFakeSourceElementKind.PropertyFromParameter.INSTANCE)) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getDECLARATION_CANT_BE_INLINED(), null, 8, null);
            }
            return false;
        }
        return true;
    }

    private final boolean isInlinableDefaultValue(FirExpression expression2) {
        return expression2 instanceof FirCallableReferenceAccess || expression2 instanceof FirFunctionCall || expression2 instanceof FirAnonymousFunctionExpression || expression2 instanceof FirLiteralExpression && ((FirLiteralExpression)expression2).getValue() == null;
    }

    public final void checkCallableDeclaration(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirCallableDeclaration declaration) {
        boolean canBeInlined;
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        if (declaration instanceof FirPropertyAccessor) {
            return;
        }
        List<FirCallableSymbol<?>> directOverriddenSymbols = FirHelpersKt.directOverriddenSymbolsSafe(context2, declaration.getSymbol());
        if (declaration instanceof FirSimpleFunction) {
            this.checkParameters(context2, reporter, (FirSimpleFunction)declaration, directOverriddenSymbols);
            this.checkNothingToInline(context2, reporter, (FirSimpleFunction)declaration);
        }
        FirMemberDeclaration $this$effectiveVisibility$iv = declaration;
        boolean $i$f$getEffectiveVisibility = false;
        FirDeclarationStatus firDeclarationStatus = $this$effectiveVisibility$iv.getStatus();
        Object object = firDeclarationStatus instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus : null;
        if (object == null || (object = object.getEffectiveVisibility()) == null) {
            object = EffectiveVisibility.Local.INSTANCE;
        }
        if ((canBeInlined = this.checkCanBeInlined(context2, reporter, declaration, (EffectiveVisibility)object)) && !((Collection)directOverriddenSymbols).isEmpty()) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getOVERRIDE_BY_INLINE(), null, 8, null);
        }
    }

    private final boolean isNonLocalReturnAllowed(CheckerContext context2, FirFunction inlineFunction) {
        List<FirBasedSymbol<?>> declarations2 = context2.getContainingDeclarations();
        int inlineFunctionIndex = declarations2.indexOf(inlineFunction.getSymbol());
        if (inlineFunctionIndex == -1) {
            return true;
        }
        int n2 = declarations2.size();
        for (int i2 = inlineFunctionIndex + 1; i2 < n2; ++i2) {
            FirFunctionSymbol callable;
            Pair<FirFunctionCall, FirValueParameter> pair;
            FirBasedSymbol<?> declaration = declarations2.get(i2);
            if (!(declaration instanceof FirFunctionSymbol) && !(declaration instanceof FirClassSymbol)) continue;
            FirAnonymousFunctionSymbol firAnonymousFunctionSymbol = declaration instanceof FirAnonymousFunctionSymbol ? (FirAnonymousFunctionSymbol)declaration : null;
            if (firAnonymousFunctionSymbol == null) {
                return false;
            }
            FirAnonymousFunctionSymbol anonymousFunction = firAnonymousFunctionSymbol;
            if (this.extractCallAndParameter(context2, anonymousFunction) == null) {
                return false;
            }
            FirFunctionCall call2 = pair.component1();
            FirValueParameter parameter = pair.component2();
            FirCallableSymbol<?> firCallableSymbol = ReferenceUtilsKt.toResolvedCallableSymbol(call2);
            if ((firCallableSymbol instanceof FirFunctionSymbol ? (FirFunctionSymbol)firCallableSymbol : null) == null) {
                return false;
            }
            callable = callable;
            FirCallableSymbol $this$isInline$iv = callable;
            boolean $i$f$isInline = false;
            if (!$this$isInline$iv.getRawStatus().isInline() && !this.isArrayLambdaConstructor(callable)) {
                return false;
            }
            if (!parameter.isNoinline() && !parameter.isCrossinline()) continue;
            return false;
        }
        return true;
    }

    private final Pair<FirFunctionCall, FirValueParameter> extractCallAndParameter(CheckerContext context2, FirAnonymousFunctionSymbol anonymousFunction) {
        for (FirStatement call2 : context2.getCallsOrAssignments()) {
            LinkedHashMap<FirExpression, FirValueParameter> mapping;
            if (!(call2 instanceof FirFunctionCall)) continue;
            FirCall $this$resolvedArgumentMapping$iv = (FirCall)call2;
            boolean $i$f$getResolvedArgumentMapping = false;
            FirArgumentList argumentList$iv = $this$resolvedArgumentMapping$iv.getArgumentList();
            if ((argumentList$iv instanceof FirResolvedArgumentList ? ((FirResolvedArgumentList)argumentList$iv).getMapping() : null) == null) continue;
            mapping = mapping;
            for (Map.Entry entry : ((Map)mapping).entrySet()) {
                FirExpression argument = (FirExpression)entry.getKey();
                FirValueParameter parameter = (FirValueParameter)entry.getValue();
                FirExpression firExpression = FirExpressionUtilKt.unwrapArgument(argument);
                FirPureAbstractElement firPureAbstractElement = firExpression instanceof FirAnonymousFunctionExpression ? (FirAnonymousFunctionExpression)firExpression : null;
                if ((firPureAbstractElement != null && (firPureAbstractElement = ((FirAnonymousFunctionExpression)firPureAbstractElement).getAnonymousFunction()) != null ? ((FirAnonymousFunction)firPureAbstractElement).getSymbol() : null) != anonymousFunction) continue;
                return TuplesKt.to(call2, parameter);
            }
        }
        return null;
    }

    private final boolean isArrayLambdaConstructor(FirFunctionSymbol<?> $this$isArrayLambdaConstructor) {
        return $this$isArrayLambdaConstructor instanceof FirConstructorSymbol && ((FirConstructorSymbol)$this$isArrayLambdaConstructor).getValueParameterSymbols().size() == 2 && ArrayUtilsKt.isArrayOrPrimitiveArray(((FirConstructorSymbol)$this$isArrayLambdaConstructor).getResolvedReturnType());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001QB-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001c\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00172\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0005H\u0002JC\u0010\u001b\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0016\u001a\u00020\u00172\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0019H\u0000R\u00020\u001dR\u00020\u001fj\u0006\u0010\u001e\u001a\u00020\u001dj\u0006\u0010 \u001a\u00020\u001f\u00a2\u0006\u0004\b#\u0010$JI\u0010%\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0019\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00190&2\u0006\u0010\u0016\u001a\u00020\u00172\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u00192\u0006\u0010!\u001a\u00020\"H\u0002R\u00020\u001dj\u0006\u0010\u001e\u001a\u00020\u001d\u00a2\u0006\u0002\u0010'J\u0014\u0010(\u001a\u00020\u0014*\u00020\u00052\u0006\u0010)\u001a\u00020\u0017H\u0002J\u000e\u0010*\u001a\u0004\u0018\u00010+*\u00020\u0017H\u0002J=\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\f\u00100\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0019H\u0000R\u00020\u001dR\u00020\u001fj\u0006\u0010\u001e\u001a\u00020\u001dj\u0006\u0010 \u001a\u00020\u001f\u00a2\u0006\u0004\b1\u00102J=\u00103\u001a\u00020-2\u0006\u00104\u001a\u0002052\f\u00100\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0019H\u0000R\u00020\u001dR\u00020\u001fj\u0006\u0010\u001e\u001a\u00020\u001dj\u0006\u0010 \u001a\u00020\u001f\u00a2\u0006\u0004\b6\u00107JE\u00108\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\b\u00109\u001a\u0004\u0018\u00010:2\f\u00100\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0019H\u0002R\u00020\u001dR\u00020\u001fj\u0006\u0010\u001e\u001a\u00020\u001dj\u0006\u0010 \u001a\u00020\u001f\u00a2\u0006\u0002\u0010;J\u0010\u0010<\u001a\u00020\u0014*\u0006\u0012\u0002\b\u00030\u0019H\u0002J=\u0010=\u001a\u00020-2\u0006\u0010>\u001a\u00020\u00172\f\u00100\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0019H\u0000R\u00020\u001dR\u00020\u001fj\u0006\u0010\u001e\u001a\u00020\u001dj\u0006\u0010 \u001a\u00020\u001f\u00a2\u0006\u0004\b?\u0010@J\u001d\u0010A\u001a\u00020\u0014*\u00020\u0017H\u0002R\u00020\u001dj\u0006\u0010\u001e\u001a\u00020\u001d\u00a2\u0006\u0002\u0010BJA\u0010C\u001a\u00020-2\u0006\u0010\u0016\u001a\u00020\u00172\n\u0010D\u001a\u0006\u0012\u0002\b\u00030E2\u0006\u0010!\u001a\u00020\"H\u0002R\u00020\u001dR\u00020\u001fj\u0006\u0010\u001e\u001a\u00020\u001dj\u0006\u0010 \u001a\u00020\u001f\u00a2\u0006\u0002\u0010FJ9\u0010G\u001a\u00020-2\n\u0010D\u001a\u0006\u0012\u0002\b\u00030E2\u0006\u0010H\u001a\u00020\u0017H\u0002R\u00020\u001dR\u00020\u001fj\u0006\u0010\u001e\u001a\u00020\u001dj\u0006\u0010 \u001a\u00020\u001f\u00a2\u0006\u0002\u0010IJ\u0010\u0010J\u001a\u00020\u0014*\u0006\u0012\u0002\b\u00030KH\u0002J9\u0010L\u001a\u00020-2\n\u00100\u001a\u0006\u0012\u0002\b\u00030\u00192\u0006\u0010!\u001a\u00020\"H\u0002R\u00020\u001dR\u00020\u001fj\u0006\u0010\u001e\u001a\u00020\u001dj\u0006\u0010 \u001a\u00020\u001f\u00a2\u0006\u0002\u0010MJ\u0010\u0010N\u001a\u00020\u0014*\u0006\u0012\u0002\b\u00030\u0019H\u0002J\u000e\u0010O\u001a\u00020\u00142\u0006\u0010P\u001a\u00020\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006R"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInlineDeclarationChecker$InlineFunctionBodyContext;", "", "inlineFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "inlineFunEffectiveVisibility", "Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;", "inlinableParameters", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirValueParameterSymbol;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "<init>", "(Lorg/jetbrains/kotlin/fir/declarations/FirFunction;Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;Ljava/util/List;Lorg/jetbrains/kotlin/fir/FirSession;)V", "getInlineFunction", "()Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "getInlineFunEffectiveVisibility", "()Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "isEffectivelyPrivateApiFunction", "", "accessedDeclarationEffectiveVisibility", "accessExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "accessedSymbol", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "shouldReportNonPublicCallFromPublicInline", "checkAccessedDeclaration", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInlineDeclarationChecker$InlineFunctionBodyContext$AccessedDeclarationVisibilityData;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "checkAccessedDeclaration$checkers", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/KtSourceElement;Lorg/jetbrains/kotlin/fir/expressions/FirStatement;Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;)Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInlineDeclarationChecker$InlineFunctionBodyContext$AccessedDeclarationVisibilityData;", "getNonPublicCallFromPublicInlineFactory", "Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticFactory2;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/expressions/FirStatement;Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;Lorg/jetbrains/kotlin/KtSourceElement;)Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticFactory2;", "isReachableDueToLocalDispatchReceiver", "access", "localDispatchReceiver", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "checkReceiversOfQualifiedAccessExpression", "", "qualifiedAccessExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "targetSymbol", "checkReceiversOfQualifiedAccessExpression$checkers", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;)V", "checkArgumentsOfCall", "functionCall", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "checkArgumentsOfCall$checkers", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;)V", "checkReceiver", "receiverExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;Lorg/jetbrains/kotlin/fir/expressions/FirExpression;Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;)V", "isInvokeOfSomeFunctionType", "checkQualifiedAccess", "qualifiedAccess", "checkQualifiedAccess$checkers", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirStatement;Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;)V", "partOfCall", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/expressions/FirStatement;)Z", "checkVisibilityAndAccess", "calledDeclaration", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirStatement;Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;Lorg/jetbrains/kotlin/KtSourceElement;)V", "checkSuperCalls", "callExpression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;Lorg/jetbrains/kotlin/fir/expressions/FirStatement;)V", "isDefinedInInlineFunction", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassifierSymbol;", "checkRecursion", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;Lorg/jetbrains/kotlin/KtSourceElement;)V", "isInsidePrivateClass", "isLessVisibleThanInlineFunction", "visibility", "AccessedDeclarationVisibilityData", "checkers"})
    @SourceDebugExtension(value={"SMAP\nFirInlineDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirInlineDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInlineDeclarationChecker$InlineFunctionBodyContext\n+ 2 publishedApiEffectiveVisibility.kt\norg/jetbrains/kotlin/fir/resolve/transformers/PublishedApiEffectiveVisibilityKt\n+ 3 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,594:1\n42#2,2:595\n42#2,2:598\n19#3:597\n45#3:600\n19#3:601\n28#3:602\n28#3:604\n28#3:605\n45#3:606\n28#3:613\n44#3:624\n44#3:625\n65#3:626\n1#4:603\n60#5,4:607\n46#5:617\n295#6,2:611\n1761#6,3:614\n1761#6,3:618\n1761#6,3:621\n*S KotlinDebug\n*F\n+ 1 FirInlineDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInlineDeclarationChecker$InlineFunctionBodyContext\n*L\n70#1:595,2\n71#1:598,2\n70#1:597\n71#1:600\n95#1:601\n155#1:602\n162#1:604\n165#1:605\n182#1:606\n215#1:613\n380#1:624\n381#1:625\n387#1:626\n207#1:607,4\n292#1:617\n212#1:611,2\n276#1:614,3\n292#1:618,3\n304#1:621,3\n*E\n"})
    public static final class InlineFunctionBodyContext {
        @NotNull
        private final FirFunction inlineFunction;
        @NotNull
        private final EffectiveVisibility inlineFunEffectiveVisibility;
        @NotNull
        private final List<FirValueParameterSymbol> inlinableParameters;
        @NotNull
        private final FirSession session;
        private final boolean isEffectivelyPrivateApiFunction;

        public InlineFunctionBodyContext(@NotNull FirFunction inlineFunction, @NotNull EffectiveVisibility inlineFunEffectiveVisibility, @NotNull List<FirValueParameterSymbol> inlinableParameters, @NotNull FirSession session) {
            Intrinsics.checkNotNullParameter(inlineFunction, "inlineFunction");
            Intrinsics.checkNotNullParameter(inlineFunEffectiveVisibility, "inlineFunEffectiveVisibility");
            Intrinsics.checkNotNullParameter(inlinableParameters, "inlinableParameters");
            Intrinsics.checkNotNullParameter(session, "session");
            this.inlineFunction = inlineFunction;
            this.inlineFunEffectiveVisibility = inlineFunEffectiveVisibility;
            this.inlinableParameters = inlinableParameters;
            this.session = session;
            this.isEffectivelyPrivateApiFunction = this.inlineFunEffectiveVisibility.getPrivateApi();
        }

        @NotNull
        public final FirFunction getInlineFunction() {
            return this.inlineFunction;
        }

        @NotNull
        public final EffectiveVisibility getInlineFunEffectiveVisibility() {
            return this.inlineFunEffectiveVisibility;
        }

        @NotNull
        public final FirSession getSession() {
            return this.session;
        }

        private final EffectiveVisibility accessedDeclarationEffectiveVisibility(FirStatement accessExpression, FirBasedSymbol<?> accessedSymbol) {
            boolean $i$f$getEffectiveVisibility;
            FirBasedSymbol $this$effectiveVisibility$iv;
            EffectiveVisibility effectiveVisibility;
            boolean $i$f$getPublishedApiEffectiveVisibility;
            FirBasedSymbol<?> $this$publishedApiEffectiveVisibility$iv;
            FirBasedSymbol<?> firBasedSymbol = accessedSymbol;
            if (firBasedSymbol instanceof FirCallableSymbol) {
                $this$publishedApiEffectiveVisibility$iv = accessedSymbol;
                $i$f$getPublishedApiEffectiveVisibility = false;
                FirLazyDeclarationResolverKt.lazyResolveToPhase($this$publishedApiEffectiveVisibility$iv, FirResolvePhase.STATUS);
                effectiveVisibility = PublishedApiEffectiveVisibilityKt.getPublishedApiEffectiveVisibility($this$publishedApiEffectiveVisibility$iv.getFir());
                if (effectiveVisibility == null) {
                    $this$effectiveVisibility$iv = (FirCallableSymbol)accessedSymbol;
                    $i$f$getEffectiveVisibility = false;
                    effectiveVisibility = ((FirCallableSymbol)$this$effectiveVisibility$iv).getResolvedStatus().getEffectiveVisibility();
                }
            } else if (firBasedSymbol instanceof FirClassLikeSymbol) {
                $this$publishedApiEffectiveVisibility$iv = accessedSymbol;
                $i$f$getPublishedApiEffectiveVisibility = false;
                FirLazyDeclarationResolverKt.lazyResolveToPhase($this$publishedApiEffectiveVisibility$iv, FirResolvePhase.STATUS);
                effectiveVisibility = PublishedApiEffectiveVisibilityKt.getPublishedApiEffectiveVisibility($this$publishedApiEffectiveVisibility$iv.getFir());
                if (effectiveVisibility == null) {
                    $this$effectiveVisibility$iv = (FirClassLikeSymbol)accessedSymbol;
                    $i$f$getEffectiveVisibility = false;
                    effectiveVisibility = ((FirClassLikeSymbol)$this$effectiveVisibility$iv).getResolvedStatus().getEffectiveVisibility();
                }
            } else {
                AddToStdlibKt.shouldNotBeCalled$default(null, 1, null);
                throw new KotlinNothingValueException();
            }
            EffectiveVisibility recordedEffectiveVisibility = effectiveVisibility;
            return this.isReachableDueToLocalDispatchReceiver(recordedEffectiveVisibility, accessExpression) ? (EffectiveVisibility)EffectiveVisibility.Public.INSTANCE : (Intrinsics.areEqual(recordedEffectiveVisibility, EffectiveVisibility.Local.INSTANCE) ? (EffectiveVisibility)EffectiveVisibility.Public.INSTANCE : recordedEffectiveVisibility);
        }

        private final boolean shouldReportNonPublicCallFromPublicInline(EffectiveVisibility accessedDeclarationEffectiveVisibility) {
            return this.inlineFunEffectiveVisibility.getPublicApi() && !accessedDeclarationEffectiveVisibility.getPublicApi() && accessedDeclarationEffectiveVisibility != EffectiveVisibility.Local.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final AccessedDeclarationVisibilityData checkAccessedDeclaration$checkers(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull KtSourceElement source, @NotNull FirStatement accessExpression, @NotNull FirBasedSymbol<?> accessedSymbol) {
            EffectiveVisibility effectiveVisibility;
            Intrinsics.checkNotNullParameter(context2, "context");
            Intrinsics.checkNotNullParameter(reporter, "reporter");
            Intrinsics.checkNotNullParameter(source, "source");
            Intrinsics.checkNotNullParameter(accessExpression, "accessExpression");
            Intrinsics.checkNotNullParameter(accessedSymbol, "accessedSymbol");
            EffectiveVisibility accessedVisibility = this.accessedDeclarationEffectiveVisibility(accessExpression, accessedSymbol);
            FirCallableSymbol<?> firCallableSymbol = FirInlineDeclarationCheckerKt.unwrapDataClassCopyWithPrimaryConstructorOrNull(accessedSymbol, this.session);
            if (firCallableSymbol != null) {
                void $this$effectiveVisibility$iv;
                FirCallableSymbol<?> firCallableSymbol2 = firCallableSymbol;
                boolean $i$f$getEffectiveVisibility = false;
                effectiveVisibility = $this$effectiveVisibility$iv.getResolvedStatus().getEffectiveVisibility();
            } else {
                effectiveVisibility = null;
            }
            EffectiveVisibility accessedDataCopyVisibility = effectiveVisibility;
            if (this.shouldReportNonPublicCallFromPublicInline(accessedVisibility)) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, this.getNonPublicCallFromPublicInlineFactory(context2, accessExpression, accessedSymbol, source), accessedSymbol, this.inlineFunction.getSymbol(), null, 32, null);
            } else if (accessedDataCopyVisibility != null && this.shouldReportNonPublicCallFromPublicInline(accessedDataCopyVisibility)) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getNON_PUBLIC_DATA_COPY_CALL_FROM_PUBLIC_INLINE(), this.inlineFunction.getSymbol(), null, 16, null);
            } else if (!this.isEffectivelyPrivateApiFunction && this.isInsidePrivateClass(accessedSymbol)) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getPRIVATE_CLASS_MEMBER_FROM_INLINE(), accessedSymbol, this.inlineFunction.getSymbol(), null, 32, null);
            } else if (!Intrinsics.areEqual(this.inlineFunEffectiveVisibility, EffectiveVisibility.Public.INSTANCE) && accessExpression instanceof FirCallableReferenceAccess && this.isLessVisibleThanInlineFunction(accessedVisibility)) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getCALLABLE_REFERENCE_TO_LESS_VISIBLE_DECLARATION_IN_INLINE(), accessedSymbol, (Object)accessedVisibility, (Object)this.inlineFunEffectiveVisibility, null, 64, null);
            }
            return new AccessedDeclarationVisibilityData(this.inlineFunEffectiveVisibility.getPublicApi(), accessedVisibility.getPublicApi(), accessedVisibility);
        }

        private final KtDiagnosticFactory2<FirBasedSymbol<?>, FirBasedSymbol<?>> getNonPublicCallFromPublicInlineFactory(CheckerContext context2, FirStatement accessExpression, FirBasedSymbol<?> accessedSymbol, KtSourceElement source) {
            if (!context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.ProhibitPrivateOperatorCallInInline)) {
                boolean isForLoopButNotIteratorCall;
                Object object;
                boolean isDelegatedPropertyAccessor = Intrinsics.areEqual(source.getKind(), KtFakeSourceElementKind.DelegatedPropertyAccessor.INSTANCE);
                boolean bl = Intrinsics.areEqual(source.getKind(), KtFakeSourceElementKind.DesugaredForLoop.INSTANCE) && !Intrinsics.areEqual((object = ReferenceUtilsKt.toReference(accessExpression, this.session)) != null && (object = FirReferenceUtilsKt.getSymbol((FirReference)object)) != null ? FirDeclarationUtilKt.getMemberDeclarationNameOrNull(object) : null, OperatorNameConventions.ITERATOR) ? true : (isForLoopButNotIteratorCall = false);
                if (isDelegatedPropertyAccessor || isForLoopButNotIteratorCall) {
                    return FirErrors.INSTANCE.getNON_PUBLIC_CALL_FROM_PUBLIC_INLINE_DEPRECATION();
                }
            }
            if (accessedSymbol instanceof FirCallableSymbol) {
                FirCallableSymbol $this$isInline$iv = (FirCallableSymbol)accessedSymbol;
                boolean $i$f$isInline = false;
                if ($this$isInline$iv.getRawStatus().isInline()) {
                    return FirErrors.INSTANCE.getNON_PUBLIC_INLINE_CALL_FROM_PUBLIC_INLINE();
                }
            }
            if (accessedSymbol instanceof FirPropertySymbol) {
                boolean bl;
                boolean $i$f$isInline;
                FirCallableSymbol $this$isInline$iv;
                FirStatement it = CollectionsKt.getOrNull(context2.getCallsOrAssignments(), CollectionsKt.getLastIndex(context2.getCallsOrAssignments()) - 1);
                boolean bl2 = false;
                boolean bl3 = it instanceof FirVariableAssignment && Intrinsics.areEqual(((FirVariableAssignment)it).getLValue(), accessExpression);
                if (bl3) {
                    boolean bl4;
                    FirPropertyAccessorSymbol firPropertyAccessorSymbol = ((FirPropertySymbol)accessedSymbol).getSetterSymbol();
                    if (firPropertyAccessorSymbol != null) {
                        $this$isInline$iv = firPropertyAccessorSymbol;
                        $i$f$isInline = false;
                        bl4 = $this$isInline$iv.getRawStatus().isInline();
                    } else {
                        bl4 = false;
                    }
                    if (bl4) {
                        return FirErrors.INSTANCE.getNON_PUBLIC_INLINE_CALL_FROM_PUBLIC_INLINE();
                    }
                }
                FirPropertyAccessorSymbol firPropertyAccessorSymbol = ((FirPropertySymbol)accessedSymbol).getGetterSymbol();
                if (firPropertyAccessorSymbol != null) {
                    $this$isInline$iv = firPropertyAccessorSymbol;
                    $i$f$isInline = false;
                    bl = $this$isInline$iv.getRawStatus().isInline();
                } else {
                    bl = false;
                }
                if (bl) {
                    return FirErrors.INSTANCE.getNON_PUBLIC_INLINE_CALL_FROM_PUBLIC_INLINE();
                }
            }
            return FirErrors.INSTANCE.getNON_PUBLIC_CALL_FROM_PUBLIC_INLINE();
        }

        private final boolean isReachableDueToLocalDispatchReceiver(EffectiveVisibility $this$isReachableDueToLocalDispatchReceiver, FirStatement access) {
            ConeKotlinType coneKotlinType = this.localDispatchReceiver(access);
            if (coneKotlinType == null) {
                return false;
            }
            ConeKotlinType receiverType = coneKotlinType;
            EffectiveVisibility.Protected receiverProtected = new EffectiveVisibility.Protected(TypeSystemContextHelpersKt.typeConstructor(receiverType, TypeComponentsKt.getTypeContext(this.session)));
            EffectiveVisibility.Permissiveness relation = receiverProtected.relation($this$isReachableDueToLocalDispatchReceiver, TypeComponentsKt.getTypeContext(this.session));
            return relation == EffectiveVisibility.Permissiveness.SAME || relation == EffectiveVisibility.Permissiveness.LESS;
        }

        private final ConeKotlinType localDispatchReceiver(FirStatement $this$localDispatchReceiver) {
            Object object;
            Object object2 = $this$localDispatchReceiver instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)$this$localDispatchReceiver : null;
            if (object2 != null && (object2 = ((FirQualifiedAccessExpression)object2).getDispatchReceiver()) != null && (object2 = FirTypeUtilsKt.getResolvedType((FirExpression)object2)) != null) {
                EffectiveVisibility effectiveVisibility;
                Object object3;
                Object it = object3 = object2;
                boolean bl = false;
                FirClassLikeSymbol<?> firClassLikeSymbol = ToSymbolUtilsKt.toClassLikeSymbol((ConeKotlinType)it, this.session);
                if (firClassLikeSymbol != null) {
                    FirClassLikeSymbol<?> $this$effectiveVisibility$iv = firClassLikeSymbol;
                    boolean $i$f$getEffectiveVisibility = false;
                    effectiveVisibility = $this$effectiveVisibility$iv.getResolvedStatus().getEffectiveVisibility();
                } else {
                    effectiveVisibility = null;
                }
                object = Intrinsics.areEqual(effectiveVisibility, EffectiveVisibility.Local.INSTANCE) ? object3 : null;
            } else {
                object = null;
            }
            return object;
        }

        public final void checkReceiversOfQualifiedAccessExpression$checkers(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirQualifiedAccessExpression qualifiedAccessExpression, @Nullable FirBasedSymbol<?> targetSymbol) {
            Intrinsics.checkNotNullParameter(context2, "context");
            Intrinsics.checkNotNullParameter(reporter, "reporter");
            Intrinsics.checkNotNullParameter(qualifiedAccessExpression, "qualifiedAccessExpression");
            this.checkReceiver(context2, reporter, qualifiedAccessExpression, qualifiedAccessExpression.getDispatchReceiver(), targetSymbol);
            this.checkReceiver(context2, reporter, qualifiedAccessExpression, qualifiedAccessExpression.getExtensionReceiver(), targetSymbol);
        }

        public final void checkArgumentsOfCall$checkers(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirFunctionCall functionCall, @Nullable FirBasedSymbol<?> targetSymbol) {
            Intrinsics.checkNotNullParameter(context2, "context");
            Intrinsics.checkNotNullParameter(reporter, "reporter");
            Intrinsics.checkNotNullParameter(functionCall, "functionCall");
            if (context2.isContractBody()) {
                return;
            }
            FirFunctionSymbol firFunctionSymbol = targetSymbol instanceof FirFunctionSymbol ? (FirFunctionSymbol)targetSymbol : null;
            if (firFunctionSymbol == null) {
                return;
            }
            FirFunctionSymbol calledFunctionSymbol = firFunctionSymbol;
            FirCall $this$resolvedArgumentMapping$iv = functionCall;
            boolean $i$f$getResolvedArgumentMapping = false;
            FirArgumentList argumentList$iv = $this$resolvedArgumentMapping$iv.getArgumentList();
            LinkedHashMap<FirExpression, FirValueParameter> linkedHashMap = argumentList$iv instanceof FirResolvedArgumentList ? ((FirResolvedArgumentList)argumentList$iv).getMapping() : null;
            if (linkedHashMap == null) {
                return;
            }
            LinkedHashMap<FirExpression, FirValueParameter> argumentMapping2 = linkedHashMap;
            for (Map.Entry entry : ((Map)argumentMapping2).entrySet()) {
                KtDiagnosticFactory1<FirBasedSymbol<?>> ktDiagnosticFactory1;
                FirValueParameterSymbol valueParameterOfOriginalInlineFunction;
                Object v2;
                FirExpression argument;
                FirValueParameter valueParameter2;
                block9: {
                    FirVariableSymbol resolvedArgumentSymbol;
                    FirExpression wrappedArgument = (FirExpression)entry.getKey();
                    valueParameter2 = (FirValueParameter)entry.getValue();
                    argument = FirExpressionUtilKt.unwrapArgument(FirExpressionUtilKt.unwrapErrorExpression(wrappedArgument));
                    FirCallableSymbol<?> firCallableSymbol = ReferenceUtilsKt.toResolvedCallableSymbol(argument, this.session);
                    if ((firCallableSymbol instanceof FirVariableSymbol ? (FirVariableSymbol)firCallableSymbol : null) == null) continue;
                    resolvedArgumentSymbol = resolvedArgumentSymbol;
                    Iterable $this$firstOrNull$iv = this.inlinableParameters;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        FirValueParameterSymbol it = (FirValueParameterSymbol)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual(it, resolvedArgumentSymbol)) continue;
                        v2 = element$iv;
                        break block9;
                    }
                    v2 = null;
                }
                if ((valueParameterOfOriginalInlineFunction = (FirValueParameterSymbol)v2) == null) continue;
                FirCallableSymbol $this$isInline$iv = calledFunctionSymbol;
                boolean $i$f$isInline = false;
                if ($this$isInline$iv.getRawStatus().isInline()) {
                    if (!FirInlineDeclarationCheckerKt.access$isInlinable(valueParameter2, this.session)) {
                        ktDiagnosticFactory1 = FirErrors.INSTANCE.getUSAGE_IS_NOT_INLINABLE();
                    } else {
                        if (valueParameterOfOriginalInlineFunction.isCrossinline() || !valueParameter2.isCrossinline() && INSTANCE.isNonLocalReturnAllowed(context2, this.inlineFunction)) continue;
                        ktDiagnosticFactory1 = FirErrors.INSTANCE.getNON_LOCAL_RETURN_NOT_ALLOWED();
                    }
                } else {
                    ktDiagnosticFactory1 = FirErrors.INSTANCE.getUSAGE_IS_NOT_INLINABLE();
                }
                KtDiagnosticFactory1<FirBasedSymbol<?>> factory = ktDiagnosticFactory1;
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)argument.getSource(), factory, (Object)valueParameterOfOriginalInlineFunction, null, 16, null);
            }
        }

        private final void checkReceiver(CheckerContext context2, DiagnosticReporter reporter, FirQualifiedAccessExpression qualifiedAccessExpression, FirExpression receiverExpression, FirBasedSymbol<?> targetSymbol) {
            if (receiverExpression == null) {
                return;
            }
            FirCallableSymbol<?> firCallableSymbol = ReferenceUtilsKt.toResolvedCallableSymbol(FirExpressionUtilKt.unwrapErrorExpression(receiverExpression), this.session);
            FirValueParameterSymbol firValueParameterSymbol = firCallableSymbol instanceof FirValueParameterSymbol ? (FirValueParameterSymbol)firCallableSymbol : null;
            if (firValueParameterSymbol == null) {
                return;
            }
            FirValueParameterSymbol receiverSymbol = firValueParameterSymbol;
            if (this.inlinableParameters.contains(receiverSymbol)) {
                FirBasedSymbol<?> firBasedSymbol = targetSymbol;
                if (!(firBasedSymbol != null ? this.isInvokeOfSomeFunctionType(firBasedSymbol) : false) || qualifiedAccessExpression instanceof FirCallableReferenceAccess) {
                    DiagnosticContext diagnosticContext2 = context2;
                    KtSourceElement ktSourceElement = receiverExpression.getSource();
                    if (ktSourceElement == null) {
                        ktSourceElement = qualifiedAccessExpression.getSource();
                    }
                    KtDiagnosticReportHelpersKt.reportOn$default(diagnosticContext2, reporter, (AbstractKtSourceElement)ktSourceElement, FirErrors.INSTANCE.getUSAGE_IS_NOT_INLINABLE(), (Object)receiverSymbol, null, 16, null);
                } else if (!receiverSymbol.isCrossinline() && !INSTANCE.isNonLocalReturnAllowed(context2, this.inlineFunction)) {
                    DiagnosticContext diagnosticContext3 = context2;
                    KtSourceElement ktSourceElement = receiverExpression.getSource();
                    if (ktSourceElement == null) {
                        ktSourceElement = qualifiedAccessExpression.getSource();
                    }
                    KtDiagnosticReportHelpersKt.reportOn$default(diagnosticContext3, reporter, (AbstractKtSourceElement)ktSourceElement, FirErrors.INSTANCE.getNON_LOCAL_RETURN_NOT_ALLOWED(), (Object)receiverSymbol, null, 16, null);
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isInvokeOfSomeFunctionType(FirBasedSymbol<?> $this$isInvokeOfSomeFunctionType) {
            if (!($this$isInvokeOfSomeFunctionType instanceof FirNamedFunctionSymbol)) {
                return false;
            }
            if (!Intrinsics.areEqual(((FirNamedFunctionSymbol)$this$isInvokeOfSomeFunctionType).getName(), OperatorNameConventions.INVOKE)) return false;
            ConeSimpleKotlinType coneSimpleKotlinType = ((FirNamedFunctionSymbol)$this$isInvokeOfSomeFunctionType).getDispatchReceiverType();
            if (coneSimpleKotlinType == null) return false;
            if (!FunctionalTypeUtilsKt.isSomeFunctionType(coneSimpleKotlinType, this.session)) return false;
            return true;
        }

        public final void checkQualifiedAccess$checkers(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirStatement qualifiedAccess, @Nullable FirBasedSymbol<?> targetSymbol) {
            Intrinsics.checkNotNullParameter(context2, "context");
            Intrinsics.checkNotNullParameter(reporter, "reporter");
            Intrinsics.checkNotNullParameter(qualifiedAccess, "qualifiedAccess");
            KtSourceElement ktSourceElement = qualifiedAccess.getSource();
            if (ktSourceElement == null) {
                return;
            }
            KtSourceElement source = ktSourceElement;
            if (!(targetSymbol instanceof FirCallableSymbol)) {
                return;
            }
            if (CollectionsKt.contains((Iterable)this.inlinableParameters, targetSymbol)) {
                boolean bl;
                block8: {
                    if (!this.partOfCall(context2, qualifiedAccess)) {
                        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getUSAGE_IS_NOT_INLINABLE(), targetSymbol, null, 16, null);
                    }
                    Iterable $this$any$iv = context2.getContainingDeclarations();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            FirBasedSymbol it = (FirBasedSymbol)element$iv;
                            boolean bl2 = false;
                            if (!CollectionsKt.contains((Iterable)this.inlinableParameters, it)) continue;
                            bl = true;
                            break block8;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getNOT_SUPPORTED_INLINE_PARAMETER_IN_INLINE_PARAMETER_DEFAULT_VALUE(), (Object)((FirValueParameterSymbol)targetSymbol), null, 16, null);
                }
            }
            this.checkVisibilityAndAccess(context2, reporter, qualifiedAccess, (FirCallableSymbol)targetSymbol, source);
            this.checkRecursion(context2, reporter, targetSymbol, source);
        }

        /*
         * WARNING - void declaration
         */
        private final boolean partOfCall(CheckerContext context2, FirStatement $this$partOfCall) {
            boolean bl;
            block7: {
                void $this$any$iv;
                if (!($this$partOfCall instanceof FirExpression)) {
                    return false;
                }
                FirStatement firStatement = CollectionsKt.getOrNull(context2.getCallsOrAssignments(), context2.getCallsOrAssignments().size() - 2);
                if (firStatement == null) {
                    return false;
                }
                FirStatement containingQualifiedAccess = firStatement;
                FirExpression firExpression = containingQualifiedAccess instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)containingQualifiedAccess : null;
                if (Intrinsics.areEqual($this$partOfCall, firExpression != null && (firExpression = firExpression.getExplicitReceiver()) != null ? FirExpressionUtilKt.unwrapErrorExpression(firExpression) : null)) {
                    return true;
                }
                FirCall firCall = containingQualifiedAccess instanceof FirCall ? (FirCall)containingQualifiedAccess : null;
                if (firCall == null) {
                    return false;
                }
                FirCall call2 = firCall;
                Object $this$arguments$iv = call2;
                boolean $i$f$getArguments = false;
                $this$arguments$iv = $this$arguments$iv.getArgumentList().getArguments();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FirExpression it = (FirExpression)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual(FirExpressionUtilKt.unwrapArgument(FirExpressionUtilKt.unwrapErrorExpression(it)), $this$partOfCall)) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        private final void checkVisibilityAndAccess(CheckerContext context2, DiagnosticReporter reporter, FirStatement accessExpression, FirCallableSymbol<?> calledDeclaration, KtSourceElement source) {
            block11: {
                block10: {
                    boolean bl;
                    block9: {
                        if (Intrinsics.areEqual(calledDeclaration.getCallableId().getCallableName(), StandardNames.BACKING_FIELD)) break block10;
                        Iterable $this$any$iv = context2.getCallsOrAssignments();
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                FirStatement it = (FirStatement)element$iv;
                                boolean bl2 = false;
                                if (!(it instanceof FirAnnotationCall)) continue;
                                bl = true;
                                break block9;
                            }
                            bl = false;
                        }
                    }
                    if (!bl) break block11;
                }
                return;
            }
            AccessedDeclarationVisibilityData accessedDeclarationVisibilityData = this.checkAccessedDeclaration$checkers(context2, reporter, source, accessExpression, (FirBasedSymbol)calledDeclaration);
            boolean isInlineFunPublicOrPublishedApi = accessedDeclarationVisibilityData.component1();
            boolean isCalledFunPublicOrPublishedApi = accessedDeclarationVisibilityData.component2();
            EffectiveVisibility calledFunEffectiveVisibility = accessedDeclarationVisibilityData.component3();
            if (isInlineFunPublicOrPublishedApi && isCalledFunPublicOrPublishedApi) {
                this.checkSuperCalls(context2, reporter, calledDeclaration, accessExpression);
            }
            boolean isConstructorCall = calledDeclaration instanceof FirConstructorSymbol;
            if (isInlineFunPublicOrPublishedApi && this.inlineFunEffectiveVisibility.toVisibility() != Visibilities.Protected.INSTANCE && calledFunEffectiveVisibility.toVisibility() == Visibilities.Protected.INSTANCE && !(accessExpression instanceof FirDelegatedConstructorCall)) {
                KtDiagnosticFactory2<FirBasedSymbol<?>, FirBasedSymbol<?>> factory = isConstructorCall ? FirErrors.INSTANCE.getPROTECTED_CONSTRUCTOR_CALL_FROM_PUBLIC_INLINE() : FirErrors.INSTANCE.getPROTECTED_CALL_FROM_PUBLIC_INLINE_ERROR();
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, factory, this.inlineFunction.getSymbol(), calledDeclaration, null, 32, null);
            }
        }

        private final void checkSuperCalls(CheckerContext context2, DiagnosticReporter reporter, FirCallableSymbol<?> calledDeclaration, FirStatement callExpression) {
            FirStatement firStatement = callExpression;
            FirExpression firExpression = firStatement instanceof FirQualifiedAccessExpression ? ((FirQualifiedAccessExpression)callExpression).getDispatchReceiver() : (firStatement instanceof FirVariableAssignment ? FirExpressionUtilKt.getDispatchReceiver((FirVariableAssignment)callExpression) : null);
            FirQualifiedAccessExpression firQualifiedAccessExpression = firExpression instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)firExpression : null;
            if (firQualifiedAccessExpression == null) {
                return;
            }
            FirQualifiedAccessExpression receiver = firQualifiedAccessExpression;
            if (receiver instanceof FirSuperReceiverExpression) {
                FirExpression firExpression2 = ((FirSuperReceiverExpression)receiver).getDispatchReceiver();
                ConeKotlinType dispatchReceiverType = firExpression2 != null ? FirTypeUtilsKt.getResolvedType(firExpression2) : null;
                Object object = dispatchReceiverType;
                if (object == null || (object = ToSymbolUtilsKt.toSymbol((ConeKotlinType)object, this.session)) == null) {
                    return;
                }
                Object classSymbol = object;
                if (!this.isDefinedInInlineFunction((FirClassifierSymbol<?>)classSymbol)) {
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)((FirSuperReceiverExpression)receiver).getSource(), FirErrors.INSTANCE.getSUPER_CALL_FROM_PUBLIC_INLINE(), calledDeclaration, null, 16, null);
                }
            }
        }

        private final boolean isDefinedInInlineFunction(FirClassifierSymbol<?> $this$isDefinedInInlineFunction) {
            boolean bl;
            FirClassifierSymbol<?> symbol = $this$isDefinedInInlineFunction;
            if (symbol instanceof FirAnonymousObjectSymbol) {
                bl = true;
            } else if (symbol instanceof FirRegularClassSymbol) {
                bl = ((FirRegularClassSymbol)symbol).getClassId().isLocal();
            } else {
                if (symbol instanceof FirTypeAliasSymbol || symbol instanceof FirTypeParameterSymbol) {
                    throw new IllegalStateException(("Unexpected classifier declaration type: " + symbol).toString());
                }
                throw new NoWhenBranchMatchedException();
            }
            return bl;
        }

        private final void checkRecursion(CheckerContext context2, DiagnosticReporter reporter, FirBasedSymbol<?> targetSymbol, KtSourceElement source) {
            if (Intrinsics.areEqual(targetSymbol, this.inlineFunction.getSymbol())) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getRECURSION_IN_INLINE(), targetSymbol, null, 16, null);
            }
        }

        private final boolean isInsidePrivateClass(FirBasedSymbol<?> $this$isInsidePrivateClass) {
            Visibility visibility;
            boolean $i$f$getVisibility;
            Object $this$visibility$iv;
            Object object = FirVisibilityCheckerKt.getOwnerLookupTag($this$isInsidePrivateClass);
            if (object == null || (object = ToSymbolUtilsKt.toSymbol((ConeClassLikeLookupTag)object, this.session)) == null) {
                return false;
            }
            Object containingClassSymbol = object;
            Object object2 = containingClassSymbol;
            if (object2 instanceof FirAnonymousObjectSymbol) {
                return false;
            }
            if (object2 instanceof FirRegularClassSymbol) {
                $this$visibility$iv = containingClassSymbol;
                $i$f$getVisibility = false;
                visibility = ((FirClassLikeSymbol)$this$visibility$iv).getResolvedStatus().getVisibility();
            } else if (object2 instanceof FirTypeAliasSymbol) {
                $this$visibility$iv = containingClassSymbol;
                $i$f$getVisibility = false;
                visibility = ((FirClassLikeSymbol)$this$visibility$iv).getResolvedStatus().getVisibility();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            Visibility containingClassVisibility = visibility;
            if (Intrinsics.areEqual(containingClassVisibility, Visibilities.Private.INSTANCE) || Intrinsics.areEqual(containingClassVisibility, Visibilities.PrivateToThis.INSTANCE)) {
                return true;
            }
            if ($this$isInsidePrivateClass instanceof FirCallableSymbol && containingClassSymbol instanceof FirRegularClassSymbol) {
                Object $this$isCompanion$iv = containingClassSymbol;
                boolean $i$f$isCompanion = false;
                if (((FirClassLikeSymbol)$this$isCompanion$iv).getRawStatus().isCompanion()) {
                    return this.isInsidePrivateClass((FirBasedSymbol)containingClassSymbol);
                }
            }
            return false;
        }

        public final boolean isLessVisibleThanInlineFunction(@NotNull EffectiveVisibility visibility) {
            Intrinsics.checkNotNullParameter(visibility, "visibility");
            if (Intrinsics.areEqual(visibility, EffectiveVisibility.Local.INSTANCE) && this.inlineFunEffectiveVisibility.getPrivateApi()) {
                return false;
            }
            EffectiveVisibility.Permissiveness relation = visibility.relation(this.inlineFunEffectiveVisibility, TypeComponentsKt.getTypeContext(this.session));
            return relation == EffectiveVisibility.Permissiveness.LESS || relation == EffectiveVisibility.Permissiveness.UNKNOWN;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00032\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInlineDeclarationChecker$InlineFunctionBodyContext$AccessedDeclarationVisibilityData;", "", "isInlineFunPublicOrPublishedApi", "", "isCalledFunPublicOrPublishedApi", "calledFunEffectiveVisibility", "Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;", "<init>", "(ZZLorg/jetbrains/kotlin/descriptors/EffectiveVisibility;)V", "()Z", "getCalledFunEffectiveVisibility", "()Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "checkers"})
        public static final class AccessedDeclarationVisibilityData {
            private final boolean isInlineFunPublicOrPublishedApi;
            private final boolean isCalledFunPublicOrPublishedApi;
            @NotNull
            private final EffectiveVisibility calledFunEffectiveVisibility;

            public AccessedDeclarationVisibilityData(boolean isInlineFunPublicOrPublishedApi, boolean isCalledFunPublicOrPublishedApi, @NotNull EffectiveVisibility calledFunEffectiveVisibility) {
                Intrinsics.checkNotNullParameter(calledFunEffectiveVisibility, "calledFunEffectiveVisibility");
                this.isInlineFunPublicOrPublishedApi = isInlineFunPublicOrPublishedApi;
                this.isCalledFunPublicOrPublishedApi = isCalledFunPublicOrPublishedApi;
                this.calledFunEffectiveVisibility = calledFunEffectiveVisibility;
            }

            public final boolean isInlineFunPublicOrPublishedApi() {
                return this.isInlineFunPublicOrPublishedApi;
            }

            public final boolean isCalledFunPublicOrPublishedApi() {
                return this.isCalledFunPublicOrPublishedApi;
            }

            @NotNull
            public final EffectiveVisibility getCalledFunEffectiveVisibility() {
                return this.calledFunEffectiveVisibility;
            }

            public final boolean component1() {
                return this.isInlineFunPublicOrPublishedApi;
            }

            public final boolean component2() {
                return this.isCalledFunPublicOrPublishedApi;
            }

            @NotNull
            public final EffectiveVisibility component3() {
                return this.calledFunEffectiveVisibility;
            }

            @NotNull
            public final AccessedDeclarationVisibilityData copy(boolean isInlineFunPublicOrPublishedApi, boolean isCalledFunPublicOrPublishedApi, @NotNull EffectiveVisibility calledFunEffectiveVisibility) {
                Intrinsics.checkNotNullParameter(calledFunEffectiveVisibility, "calledFunEffectiveVisibility");
                return new AccessedDeclarationVisibilityData(isInlineFunPublicOrPublishedApi, isCalledFunPublicOrPublishedApi, calledFunEffectiveVisibility);
            }

            public static /* synthetic */ AccessedDeclarationVisibilityData copy$default(AccessedDeclarationVisibilityData accessedDeclarationVisibilityData, boolean bl, boolean bl2, EffectiveVisibility effectiveVisibility, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    bl = accessedDeclarationVisibilityData.isInlineFunPublicOrPublishedApi;
                }
                if ((n2 & 2) != 0) {
                    bl2 = accessedDeclarationVisibilityData.isCalledFunPublicOrPublishedApi;
                }
                if ((n2 & 4) != 0) {
                    effectiveVisibility = accessedDeclarationVisibilityData.calledFunEffectiveVisibility;
                }
                return accessedDeclarationVisibilityData.copy(bl, bl2, effectiveVisibility);
            }

            @NotNull
            public String toString() {
                return "AccessedDeclarationVisibilityData(isInlineFunPublicOrPublishedApi=" + this.isInlineFunPublicOrPublishedApi + ", isCalledFunPublicOrPublishedApi=" + this.isCalledFunPublicOrPublishedApi + ", calledFunEffectiveVisibility=" + this.calledFunEffectiveVisibility + ')';
            }

            public int hashCode() {
                int result2 = Boolean.hashCode(this.isInlineFunPublicOrPublishedApi);
                result2 = result2 * 31 + Boolean.hashCode(this.isCalledFunPublicOrPublishedApi);
                result2 = result2 * 31 + this.calledFunEffectiveVisibility.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof AccessedDeclarationVisibilityData)) {
                    return false;
                }
                AccessedDeclarationVisibilityData accessedDeclarationVisibilityData = (AccessedDeclarationVisibilityData)other;
                if (this.isInlineFunPublicOrPublishedApi != accessedDeclarationVisibilityData.isInlineFunPublicOrPublishedApi) {
                    return false;
                }
                if (this.isCalledFunPublicOrPublishedApi != accessedDeclarationVisibilityData.isCalledFunPublicOrPublishedApi) {
                    return false;
                }
                return Intrinsics.areEqual(this.calledFunEffectiveVisibility, accessedDeclarationVisibilityData.calledFunEffectiveVisibility);
            }
        }
    }
}

