/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit.codeInspection;

import com.intellij.codeInspection.AnalysisUastUtilKt;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHolderUtilKt;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.execution.JUnitBundle;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0010H\u0016J\u001d\u0010\u0011\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00122\u000b\u0010\u0013\u001a\u00070\u0014\u00a2\u0006\u0002\b\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/execution/junit/codeInspection/JUnitIgnoredTestVisitor;", "Lorg/jetbrains/uast/visitor/AbstractUastNonRecursiveVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "onlyReportWithoutReason", "", "<init>", "(Lcom/intellij/codeInspection/ProblemsHolder;Z)V", "withoutReasonChoice", "", "getWithoutReasonChoice", "()I", "visitClass", "node", "Lorg/jetbrains/uast/UClass;", "visitMethod", "Lorg/jetbrains/uast/UMethod;", "checkIgnoreOrDisabled", "Lorg/jetbrains/uast/UDeclaration;", "message", "", "Lcom/intellij/codeInspection/util/InspectionMessage;", "intellij.junit"})
@SourceDebugExtension(value={"SMAP\nJUnitIgnoredTestInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JUnitIgnoredTestInspection.kt\ncom/intellij/execution/junit/codeInspection/JUnitIgnoredTestVisitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,64:1\n1761#2,3:65\n*S KotlinDebug\n*F\n+ 1 JUnitIgnoredTestInspection.kt\ncom/intellij/execution/junit/codeInspection/JUnitIgnoredTestVisitor\n*L\n58#1:65,3\n*E\n"})
final class JUnitIgnoredTestVisitor
extends AbstractUastNonRecursiveVisitor {
    @NotNull
    private final ProblemsHolder holder;
    private final boolean onlyReportWithoutReason;
    private final int withoutReasonChoice;

    public JUnitIgnoredTestVisitor(@NotNull ProblemsHolder holder, boolean onlyReportWithoutReason) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        this.holder = holder;
        this.onlyReportWithoutReason = onlyReportWithoutReason;
        this.withoutReasonChoice = this.onlyReportWithoutReason ? 2 : 1;
    }

    public final int getWithoutReasonChoice() {
        return this.withoutReasonChoice;
    }

    public boolean visitClass(@NotNull UClass node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        UDeclaration uDeclaration = (UDeclaration)node;
        Object[] objectArray = new Object[]{node.getJavaPsi().getName(), this.withoutReasonChoice};
        String string = JUnitBundle.message("jvm.inspections.junit.ignored.test.class.problem.descriptor", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return this.checkIgnoreOrDisabled(uDeclaration, string);
    }

    public boolean visitMethod(@NotNull UMethod node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        UDeclaration uDeclaration = (UDeclaration)node;
        Object[] objectArray = new Object[]{node.getName(), this.withoutReasonChoice};
        String string = JUnitBundle.message("jvm.inspections.junit.ignored.test.method.problem.descriptor", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return this.checkIgnoreOrDisabled(uDeclaration, string);
    }

    private final boolean checkIgnoreOrDisabled(UDeclaration node, String message) {
        String[] stringArray = new String[]{"org.junit.Ignore", "org.junit.jupiter.api.Disabled"};
        List annotations = AnalysisUastUtilKt.findAnnotations((UAnnotated)((UAnnotated)node), (String[])stringArray);
        if (annotations.isEmpty()) {
            return true;
        }
        if (this.onlyReportWithoutReason) {
            boolean bl;
            block6: {
                Iterable $this$any$iv = annotations;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        UAnnotation it = (UAnnotation)element$iv;
                        boolean bl2 = false;
                        if (!(it.findDeclaredAttributeValue("value") != null)) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return true;
            }
        }
        ProblemHolderUtilKt.registerUProblem$default((ProblemsHolder)this.holder, (UDeclaration)node, (String)message, (LocalQuickFix[])new LocalQuickFix[0], null, (int)8, null);
        return true;
    }
}

