/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.util.Alarm;
import com.jetbrains.performancePlugin.profilers.Profiler;
import com.jetbrains.performancePlugin.profilers.ProfilersController;
import com.jetbrains.performancePlugin.ui.FinishScriptDialog;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import java.util.ArrayList;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

public final class ProjectIndexingComponent
implements DumbService.DumbModeListener {
    public static final String PROFILE_INDEXING_COMPONENT = "performancePlugin.isProfileIndexing";
    public static final String PROFILE_WITH_ASYNC = "performancePlugin.isProfileIndexingWithAsync";
    @NotNull
    private final Project project;
    private static final int TIMEOUT = 500;
    private final Alarm alarm;

    ProjectIndexingComponent(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        if (project == null) {
            ProjectIndexingComponent.$$$reportNull$$$0(0);
        }
        if (coroutineScope == null) {
            ProjectIndexingComponent.$$$reportNull$$$0(1);
        }
        this.project = project;
        this.alarm = new Alarm(coroutineScope, Alarm.ThreadToUse.SWING_THREAD);
    }

    public void enteredDumbMode() {
        try {
            if (this.isProfilingEnabled()) {
                PropertiesComponent.getInstance((Project)this.project).setValue(PROFILE_INDEXING_COMPONENT, false);
                PropertiesComponent.getInstance((Project)this.project).setValue(PROFILE_WITH_ASYNC, false);
                Profiler.getCurrentProfilerHandler(this.project).startProfiling(this.project.getName(), new ArrayList<String>());
                DumbService.getInstance((Project)this.project).runReadActionInSmartMode(() -> this.runScriptAfterDumb(this.project));
            }
        }
        catch (Exception e) {
            new ActionCallbackProfilerStopper().reject(e.getMessage());
        }
    }

    private void runScriptAfterDumb(@NotNull Project project) {
        if (project == null) {
            ProjectIndexingComponent.$$$reportNull$$$0(2);
        }
        DumbService.getInstance((Project)project).smartInvokeLater(() -> this.alarm.addRequest(() -> {
            if (DumbService.isDumb((Project)project)) {
                this.runScriptAfterDumb(project);
            } else {
                ProfilersController.getInstance();
                if (Profiler.isAnyProfilingStarted()) {
                    try {
                        ProfilersController.getInstance().getCurrentProfilerHandler().stopProfiling(new ArrayList<String>());
                        ProfilersController.getInstance().setStoppedByScript(true);
                    }
                    catch (Exception e) {
                        new ActionCallbackProfilerStopper().setRejected();
                    }
                    ApplicationManager.getApplication().invokeLater(() -> new FinishScriptDialog(project).show());
                }
            }
        }, 500));
    }

    private boolean isProfilingEnabled() {
        return PropertiesComponent.getInstance((Project)this.project).getBoolean(PROFILE_INDEXING_COMPONENT);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coroutineScope";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/performancePlugin/ProjectIndexingComponent";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "runScriptAfterDumb";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

