/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.lazy.grid;

import androidx.compose.foundation.gestures.Orientation;
import androidx.compose.foundation.gestures.ScrollScope;
import androidx.compose.foundation.lazy.grid.LazyGridItemInfo;
import androidx.compose.foundation.lazy.grid.LazyGridLayoutInfo;
import androidx.compose.foundation.lazy.grid.LazyGridLayoutInfoKt;
import androidx.compose.foundation.lazy.grid.LazyGridState;
import androidx.compose.foundation.lazy.layout.LazyLayoutScrollScope;
import androidx.compose.ui.unit.IntOffset;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"LazyLayoutScrollScope", "Landroidx/compose/foundation/lazy/layout/LazyLayoutScrollScope;", "state", "Landroidx/compose/foundation/lazy/grid/LazyGridState;", "scrollScope", "Landroidx/compose/foundation/gestures/ScrollScope;", "foundation"})
public final class LazyGridScrollScopeKt {
    @NotNull
    public static final LazyLayoutScrollScope LazyLayoutScrollScope(@NotNull LazyGridState state, @NotNull ScrollScope scrollScope2) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)scrollScope2, (String)"scrollScope");
        return new LazyLayoutScrollScope(scrollScope2, state){
            private final /* synthetic */ ScrollScope $$delegate_0;
            final /* synthetic */ LazyGridState $state;
            {
                this.$state = $state;
                this.$$delegate_0 = $scrollScope;
            }

            public int getFirstVisibleItemIndex() {
                return this.$state.getFirstVisibleItemIndex();
            }

            public int getFirstVisibleItemScrollOffset() {
                return this.$state.getFirstVisibleItemScrollOffset();
            }

            public int getLastVisibleItemIndex() {
                LazyGridItemInfo lazyGridItemInfo = (LazyGridItemInfo)CollectionsKt.lastOrNull(this.$state.getLayoutInfo().getVisibleItemsInfo());
                return lazyGridItemInfo != null ? lazyGridItemInfo.getIndex() : 0;
            }

            public int getItemCount() {
                return this.$state.getLayoutInfo().getTotalItemsCount();
            }

            public void snapToItem(int index2, int offset) {
                this.$state.snapToItemIndexInternal$foundation(index2, offset, true);
            }

            public int calculateDistanceTo(int targetIndex, int targetOffset) {
                int n;
                LazyGridLayoutInfo layoutInfo = this.$state.getLayoutInfo();
                if (layoutInfo.getVisibleItemsInfo().isEmpty()) {
                    return 0;
                }
                int n2 = this.getFirstVisibleItemIndex();
                if (!(targetIndex <= this.getLastVisibleItemIndex() ? n2 <= targetIndex : false)) {
                    int slotsPerLine = this.$state.getSlotsPerLine$foundation();
                    int averageLineMainAxisSize = LazyGridLayoutInfoKt.visibleLinesAverageMainAxisSize(layoutInfo);
                    boolean before = targetIndex < this.getFirstVisibleItemIndex();
                    int linesDiff = (targetIndex - this.getFirstVisibleItemIndex() + (slotsPerLine - 1) * (before ? -1 : 1)) / slotsPerLine;
                    n = averageLineMainAxisSize * linesDiff - this.getFirstVisibleItemScrollOffset();
                } else {
                    Integer n3;
                    LazyGridItemInfo lazyGridItemInfo;
                    block6: {
                        List<LazyGridItemInfo> $this$fastFirstOrNull$iv = layoutInfo.getVisibleItemsInfo();
                        boolean $i$f$fastFirstOrNull = false;
                        List<LazyGridItemInfo> $this$fastForEach$iv$iv = $this$fastFirstOrNull$iv;
                        boolean $i$f$fastForEach = false;
                        int n4 = ((Collection)$this$fastForEach$iv$iv).size();
                        for (int index$iv$iv = 0; index$iv$iv < n4; ++index$iv$iv) {
                            LazyGridItemInfo item$iv$iv;
                            LazyGridItemInfo it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                            boolean bl = false;
                            LazyGridItemInfo it = it$iv;
                            boolean bl2 = false;
                            if (!(it.getIndex() == targetIndex)) continue;
                            lazyGridItemInfo = it$iv;
                            break block6;
                        }
                        lazyGridItemInfo = null;
                    }
                    LazyGridItemInfo visibleItem = lazyGridItemInfo;
                    if (layoutInfo.getOrientation() == Orientation.Vertical) {
                        LazyGridItemInfo lazyGridItemInfo2 = visibleItem;
                        n3 = lazyGridItemInfo2 != null ? Integer.valueOf(IntOffset.getY-impl(lazyGridItemInfo2.getOffset-nOcc-ac())) : null;
                    } else {
                        LazyGridItemInfo lazyGridItemInfo3 = visibleItem;
                        n3 = lazyGridItemInfo3 != null ? Integer.valueOf(IntOffset.getX-impl(lazyGridItemInfo3.getOffset-nOcc-ac())) : null;
                    }
                    n = n3 != null ? n3 : 0;
                }
                return n + targetOffset;
            }

            public float scrollBy(float pixels) {
                return this.$$delegate_0.scrollBy(pixels);
            }
        };
    }
}

