/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.groovy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.groovy.compiler.rt.OutputItem;
import org.jetbrains.jps.incremental.groovy.JpsGroovycRunner;
import org.jetbrains.jps.incremental.messages.CompilerMessage;

public final class GroovyCompilerResult {
    private final List<OutputItem> myCompiledItems;
    private final List<? extends CompilerMessage> myCompilerMessages;

    public GroovyCompilerResult(@NotNull @NotNull Collection<@NotNull OutputItem> items, @NotNull @NotNull Collection<? extends @NotNull CompilerMessage> messages) {
        if (items == null) {
            GroovyCompilerResult.$$$reportNull$$$0(0);
        }
        if (messages == null) {
            GroovyCompilerResult.$$$reportNull$$$0(1);
        }
        this.myCompiledItems = new ArrayList<OutputItem>(items);
        this.myCompilerMessages = new ArrayList<CompilerMessage>(messages);
    }

    @NotNull
    public @NotNull List<@NotNull OutputItem> getSuccessfullyCompiled() {
        List<OutputItem> list = this.myCompiledItems;
        if (list == null) {
            GroovyCompilerResult.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public @NotNull List<? extends @NotNull CompilerMessage> getCompilerMessages() {
        List<? extends CompilerMessage> list = this.myCompilerMessages;
        if (list == null) {
            GroovyCompilerResult.$$$reportNull$$$0(3);
        }
        return list;
    }

    public boolean shouldRetry() {
        for (CompilerMessage compilerMessage : this.myCompilerMessages) {
            String text = compilerMessage.getMessageText();
            if (!text.contains("java.lang.NoClassDefFoundError") && !text.contains("java.lang.TypeNotPresentException") && !text.contains("unable to resolve class")) continue;
            JpsGroovycRunner.LOG.debug("Resolve issue: " + String.valueOf(compilerMessage));
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messages";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/incremental/groovy/GroovyCompilerResult";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/incremental/groovy/GroovyCompilerResult";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuccessfullyCompiled";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompilerMessages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

