/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.inference;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.renderer.DescriptorRendererOptions;
import org.jetbrains.kotlin.resolve.calls.inference.BuilderInferenceData;
import org.jetbrains.kotlin.resolve.calls.inference.TypeVariable;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.FlexibleType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeAttributes;
import org.jetbrains.kotlin.types.TypeRefinement;
import org.jetbrains.kotlin.types.checker.KotlinTypeRefiner;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0007H\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u001fH\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/resolve/calls/inference/TypeTemplate;", "Lorg/jetbrains/kotlin/types/FlexibleType;", "typeVariable", "Lorg/jetbrains/kotlin/resolve/calls/inference/TypeVariable;", "builderInferenceData", "Lorg/jetbrains/kotlin/resolve/calls/inference/BuilderInferenceData;", "nullable", "", "<init>", "(Lorg/jetbrains/kotlin/resolve/calls/inference/TypeVariable;Lorg/jetbrains/kotlin/resolve/calls/inference/BuilderInferenceData;Z)V", "getTypeVariable", "()Lorg/jetbrains/kotlin/resolve/calls/inference/TypeVariable;", "getBuilderInferenceData", "()Lorg/jetbrains/kotlin/resolve/calls/inference/BuilderInferenceData;", "replaceAttributes", "newAttributes", "Lorg/jetbrains/kotlin/types/TypeAttributes;", "makeNullableAsSpecified", "newNullability", "delegate", "Lorg/jetbrains/kotlin/types/SimpleType;", "getDelegate", "()Lorg/jetbrains/kotlin/types/SimpleType;", "render", "", "renderer", "Lorg/jetbrains/kotlin/renderer/DescriptorRenderer;", "options", "Lorg/jetbrains/kotlin/renderer/DescriptorRendererOptions;", "refine", "kotlinTypeRefiner", "Lorg/jetbrains/kotlin/types/checker/KotlinTypeRefiner;", "frontend"})
public final class TypeTemplate
extends FlexibleType {
    @NotNull
    private final TypeVariable typeVariable;
    @NotNull
    private final BuilderInferenceData builderInferenceData;

    public TypeTemplate(@NotNull TypeVariable typeVariable, @NotNull BuilderInferenceData builderInferenceData, boolean nullable) {
        Intrinsics.checkNotNullParameter((Object)typeVariable, (String)"typeVariable");
        Intrinsics.checkNotNullParameter((Object)builderInferenceData, (String)"builderInferenceData");
        SimpleType simpleType = DescriptorUtilsKt.getBuiltIns(typeVariable.getOriginalTypeParameter()).getNothingType();
        Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"getNothingType(...)");
        super(simpleType, DescriptorUtilsKt.getBuiltIns(typeVariable.getOriginalTypeParameter()).getAnyType().makeNullableAsSpecified(nullable));
        this.typeVariable = typeVariable;
        this.builderInferenceData = builderInferenceData;
    }

    public /* synthetic */ TypeTemplate(TypeVariable typeVariable, BuilderInferenceData builderInferenceData, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = true;
        }
        this(typeVariable, builderInferenceData, bl);
    }

    @NotNull
    public final TypeVariable getTypeVariable() {
        return this.typeVariable;
    }

    @NotNull
    public final BuilderInferenceData getBuilderInferenceData() {
        return this.builderInferenceData;
    }

    @Override
    @NotNull
    public TypeTemplate replaceAttributes(@NotNull TypeAttributes newAttributes) {
        Intrinsics.checkNotNullParameter((Object)newAttributes, (String)"newAttributes");
        return this;
    }

    @Override
    @NotNull
    public TypeTemplate makeNullableAsSpecified(boolean newNullability) {
        return new TypeTemplate(this.typeVariable, this.builderInferenceData, newNullability);
    }

    @Override
    @NotNull
    public SimpleType getDelegate() {
        return this.getUpperBound();
    }

    @Override
    @NotNull
    public String render(@NotNull DescriptorRenderer renderer, @NotNull DescriptorRendererOptions options) {
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        return '~' + renderer.renderType(this.typeVariable.getType());
    }

    @Override
    @TypeRefinement
    @NotNull
    public TypeTemplate refine(@NotNull KotlinTypeRefiner kotlinTypeRefiner) {
        Intrinsics.checkNotNullParameter((Object)((Object)kotlinTypeRefiner), (String)"kotlinTypeRefiner");
        return this;
    }
}

