/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.SimpleFunctionDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DataClassResolver;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005J.\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ$\u0010\u001c\u001a\u00020\u00122\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00170\u001e2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/resolve/DataClassDescriptorResolver;", "", "<init>", "()V", "COPY_METHOD_NAME", "Lorg/jetbrains/kotlin/name/Name;", "getCOPY_METHOD_NAME", "()Lorg/jetbrains/kotlin/name/Name;", "createComponentName", "index", "", "getComponentIndex", "componentName", "", "isComponentLike", "", "name", "createComponentFunctionDescriptor", "Lorg/jetbrains/kotlin/descriptors/SimpleFunctionDescriptor;", "parameterIndex", "property", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "parameter", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "createCopyFunctionDescriptor", "constructorParameters", "", "frontend"})
public final class DataClassDescriptorResolver {
    @NotNull
    public static final DataClassDescriptorResolver INSTANCE = new DataClassDescriptorResolver();
    @NotNull
    private static final Name COPY_METHOD_NAME;

    private DataClassDescriptorResolver() {
    }

    @NotNull
    public final Name getCOPY_METHOD_NAME() {
        return COPY_METHOD_NAME;
    }

    @NotNull
    public final Name createComponentName(int index) {
        return DataClassResolver.INSTANCE.createComponentName(index);
    }

    public final int getComponentIndex(@NotNull String componentName) {
        Intrinsics.checkNotNullParameter((Object)componentName, (String)"componentName");
        return DataClassResolver.INSTANCE.getComponentIndex(componentName);
    }

    public final boolean isComponentLike(@NotNull Name name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return DataClassResolver.INSTANCE.isComponentLike(name);
    }

    @NotNull
    public final SimpleFunctionDescriptor createComponentFunctionDescriptor(int parameterIndex, @NotNull PropertyDescriptor property2, @NotNull ValueParameterDescriptor parameter, @NotNull ClassDescriptor classDescriptor, @NotNull BindingTrace trace) {
        Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        Intrinsics.checkNotNullParameter((Object)classDescriptor, (String)"classDescriptor");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        SimpleFunctionDescriptorImpl simpleFunctionDescriptorImpl = SimpleFunctionDescriptorImpl.create(classDescriptor, Annotations.Companion.getEMPTY(), this.createComponentName(parameterIndex), CallableMemberDescriptor.Kind.SYNTHESIZED, parameter.getSource());
        Intrinsics.checkNotNullExpressionValue((Object)simpleFunctionDescriptorImpl, (String)"create(...)");
        SimpleFunctionDescriptorImpl functionDescriptor = simpleFunctionDescriptorImpl;
        functionDescriptor.initialize((ReceiverParameterDescriptor)null, classDescriptor.getThisAsReceiverParameter(), CollectionsKt.emptyList(), CollectionsKt.emptyList(), CollectionsKt.emptyList(), property2.getType(), Modality.FINAL, property2.getVisibility());
        functionDescriptor.setOperator(true);
        trace.record(BindingContext.DATA_CLASS_COMPONENT_FUNCTION, parameter, functionDescriptor);
        return functionDescriptor;
    }

    @NotNull
    public final SimpleFunctionDescriptor createCopyFunctionDescriptor(@NotNull Collection<? extends ValueParameterDescriptor> constructorParameters, @NotNull ClassDescriptor classDescriptor, @NotNull BindingTrace trace) {
        Intrinsics.checkNotNullParameter(constructorParameters, (String)"constructorParameters");
        Intrinsics.checkNotNullParameter((Object)classDescriptor, (String)"classDescriptor");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        SimpleFunctionDescriptorImpl simpleFunctionDescriptorImpl = SimpleFunctionDescriptorImpl.create(classDescriptor, Annotations.Companion.getEMPTY(), COPY_METHOD_NAME, CallableMemberDescriptor.Kind.SYNTHESIZED, classDescriptor.getSource());
        Intrinsics.checkNotNullExpressionValue((Object)simpleFunctionDescriptorImpl, (String)"create(...)");
        SimpleFunctionDescriptorImpl functionDescriptor = simpleFunctionDescriptorImpl;
        ArrayList<ValueParameterDescriptorImpl> parameterDescriptors = new ArrayList<ValueParameterDescriptorImpl>();
        for (ValueParameterDescriptor valueParameterDescriptor : constructorParameters) {
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)trace.getBindingContext().get(BindingContext.VALUE_PARAMETER_AS_PROPERTY, valueParameterDescriptor);
            boolean declaresDefaultValue = propertyDescriptor != null;
            CallableDescriptor callableDescriptor = functionDescriptor;
            int n = valueParameterDescriptor.getIndex();
            Annotations annotations = valueParameterDescriptor.getAnnotations();
            Name name = valueParameterDescriptor.getName();
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"getName(...)");
            KotlinType kotlinType = valueParameterDescriptor.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
            boolean bl = valueParameterDescriptor.isCrossinline();
            boolean bl2 = valueParameterDescriptor.isNoinline();
            KotlinType kotlinType2 = valueParameterDescriptor.getVarargElementType();
            SourceElement sourceElement = valueParameterDescriptor.getSource();
            Intrinsics.checkNotNullExpressionValue((Object)sourceElement, (String)"getSource(...)");
            ValueParameterDescriptorImpl parameterDescriptor = new ValueParameterDescriptorImpl(callableDescriptor, null, n, annotations, name, kotlinType, declaresDefaultValue, bl, bl2, kotlinType2, sourceElement);
            parameterDescriptors.add(parameterDescriptor);
            if (!declaresDefaultValue) continue;
            trace.record(BindingContext.VALUE_PARAMETER_AS_PROPERTY, parameterDescriptor, propertyDescriptor);
        }
        functionDescriptor.initialize((ReceiverParameterDescriptor)null, classDescriptor.getThisAsReceiverParameter(), CollectionsKt.emptyList(), CollectionsKt.emptyList(), parameterDescriptors, (KotlinType)classDescriptor.getDefaultType(), Modality.FINAL, DescriptorVisibilities.PUBLIC);
        trace.record(BindingContext.DATA_CLASS_COPY_FUNCTION, classDescriptor, functionDescriptor);
        return functionDescriptor;
    }

    static {
        Name name = Name.identifier((String)"copy");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(...)");
        COPY_METHOD_NAME = name;
    }
}

