/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.BodyLoweringPass;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.backend.js.JsIrAttributesKt;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.JsStatementOrigins;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.backend.js.lower.ES6AddBoxParameterLoweringKt;
import org.jetbrains.kotlin.ir.backend.js.lower.ES6ConstructorLoweringKt;
import org.jetbrains.kotlin.ir.backend.js.utils.IrJsUtilsKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.util.IrExceptionBuilder;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/ES6ConstructorCallLowering;", "Lorg/jetbrains/kotlin/backend/common/BodyLoweringPass;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "lower", "", "irBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "backend.js"})
public final class ES6ConstructorCallLowering
implements BodyLoweringPass {
    @NotNull
    private final JsIrBackendContext context;

    public ES6ConstructorCallLowering(@NotNull JsIrBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @NotNull
    public final JsIrBackendContext getContext() {
        return this.context;
    }

    public void lower(@NotNull IrBody irBody, @NotNull IrDeclaration container) {
        Intrinsics.checkNotNullParameter((Object)irBody, (String)"irBody");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        if (!this.context.getEs6mode()) {
            return;
        }
        IrFunction containerFunction = container instanceof IrFunction ? (IrFunction)container : null;
        IrElementTransformerVoidKt.transformChildrenVoid((IrElement)((IrElement)irBody), (IrElementTransformerVoid)((IrElementTransformerVoid)new IrElementTransformerVoidWithContext(containerFunction, this){
            final /* synthetic */ IrFunction $containerFunction;
            final /* synthetic */ ES6ConstructorCallLowering this$0;
            {
                this.$containerFunction = $containerFunction;
                this.this$0 = $receiver;
            }

            public IrExpression visitConstructorCall(IrConstructorCall expression2) {
                IrFunction currentFunction;
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                IrConstructor currentConstructor = (IrConstructor)expression2.getSymbol().getOwner();
                IrClass irClass = IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)currentConstructor));
                ScopeWithIr scopeWithIr = this.getCurrentFunction();
                IrElement irElement = scopeWithIr != null ? scopeWithIr.getIrElement() : null;
                IrFunction irFunction = irElement instanceof IrFunction ? (IrFunction)irElement : null;
                if (irFunction == null) {
                    irFunction = currentFunction = this.$containerFunction;
                }
                if (Intrinsics.areEqual((Object)irClass.getSymbol(), (Object)this.this$0.getContext().getIrBuiltIns().getAnyClass()) || IrJsUtilsKt.hasStrictSignature(currentConstructor, this.this$0.getContext())) {
                    return super.visitConstructorCall(expression2);
                }
                IrSimpleFunction irSimpleFunction = JsIrAttributesKt.getConstructorFactory(currentConstructor);
                if (irSimpleFunction == null) {
                    IrExceptionBuilder irExceptionBuilder;
                    String message$iv = "Replacement for the constructor is not found";
                    boolean $i$f$irError = false;
                    IrExceptionBuilder $this$irError_u24lambda_u240$iv = irExceptionBuilder = new IrExceptionBuilder(message$iv);
                    boolean bl = false;
                    IrExceptionBuilder $this$visitConstructorCall_u24lambda_u240 = $this$irError_u24lambda_u240$iv;
                    boolean bl2 = false;
                    $this$visitConstructorCall_u24lambda_u240.withIrEntry("currentConstructor", (IrElement)currentConstructor);
                    $this$visitConstructorCall_u24lambda_u240.withIrEntry("expression", (IrElement)expression2);
                    IrExceptionBuilder builder$iv = irExceptionBuilder;
                    throw new IllegalStateException(builder$iv.buildString().toString());
                }
                IrSimpleFunction factoryFunction = irSimpleFunction;
                boolean isDelegatingCall = ES6ConstructorLoweringKt.isSyntheticDelegatingReplacement((IrFunctionAccessExpression)expression2) && currentFunction != null;
                IrCall irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, factoryFunction.getSymbol(), null, null, (IrStatementOrigin)(isDelegatingCall ? ES6ConstructorLoweringKt.getES6_DELEGATING_CONSTRUCTOR_REPLACEMENT() : JsStatementOrigins.INSTANCE.getSYNTHESIZED_STATEMENT()), null, 0, 0, 118, null);
                ES6ConstructorCallLowering eS6ConstructorCallLowering = this.this$0;
                IrCall $this$visitConstructorCall_u24lambda_u242 = irCall;
                boolean bl = false;
                int i = 0;
                if (ES6ConstructorLoweringKt.isSyntheticDelegatingReplacement((IrFunctionAccessExpression)expression2)) {
                    if ($this$visitConstructorCall_u24lambda_u242.getSuperQualifierSymbol() == null) {
                        IrMemberAccessExpression.ValueArgumentsList valueArgumentsList = $this$visitConstructorCall_u24lambda_u242.getArguments();
                        int n = i++;
                        IrValueParameter irValueParameter = factoryFunction.getDispatchReceiverParameter();
                        Intrinsics.checkNotNull((Object)irValueParameter);
                        valueArgumentsList.set(n, (Object)JsIrBuilder.buildGetValue$default(JsIrBuilder.INSTANCE, (IrValueSymbol)irValueParameter.getSymbol(), null, 2, null));
                    }
                } else {
                    $this$visitConstructorCall_u24lambda_u242.getArguments().set(i++, (Object)IrJsUtilsKt.jsConstructorReference(irClass, eS6ConstructorCallLowering.getContext()));
                }
                Iterator iterator2 = expression2.getArguments().iterator();
                Intrinsics.checkNotNullExpressionValue((Object)iterator2, (String)"iterator(...)");
                Iterator iterator3 = iterator2;
                while (iterator3.hasNext()) {
                    IrExpression orgArg = (IrExpression)iterator3.next();
                    $this$visitConstructorCall_u24lambda_u242.getArguments().set(i++, (Object)orgArg);
                }
                if (ES6ConstructorLoweringKt.isSyntheticDelegatingReplacement((IrFunctionAccessExpression)expression2)) {
                    IrFunction irFunction2 = currentFunction;
                    if (irFunction2 != null && (irFunction2 = ES6AddBoxParameterLoweringKt.getBoxParameter(irFunction2)) != null) {
                        IrFunction it = irFunction2;
                        boolean bl3 = false;
                        $this$visitConstructorCall_u24lambda_u242.getArguments().set(CollectionsKt.getLastIndex((List)((List)$this$visitConstructorCall_u24lambda_u242.getArguments())), (Object)JsIrBuilder.buildGetValue$default(JsIrBuilder.INSTANCE, (IrValueSymbol)it.getSymbol(), null, 2, null));
                    }
                }
                IrCall factoryFunctionCall = irCall;
                return super.visitCall(factoryFunctionCall);
            }
        }));
    }
}

