/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.DeclarationTransformer;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.backend.js.JsIrAttributesKt;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.lower.ES6ConstructorLoweringKt;
import org.jetbrains.kotlin.ir.backend.js.lower.ES6PrimaryConstructorOptimizationLoweringKt;
import org.jetbrains.kotlin.ir.backend.js.utils.MutableReference;
import org.jetbrains.kotlin.ir.backend.js.utils.ReferenceKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.utils.SmartList;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\bH\u0016J\f\u0010\n\u001a\u00020\u000b*\u00020\fH\u0002J\f\u0010\r\u001a\u00020\u000e*\u00020\fH\u0002J\f\u0010\u000f\u001a\u00020\u000e*\u00020\fH\u0002J\f\u0010\u0010\u001a\u00020\u000e*\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/ES6CollectPrimaryConstructorsWhichCouldBeOptimizedLowering;", "Lorg/jetbrains/kotlin/backend/common/DeclarationTransformer;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "transformFlat", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "declaration", "checkIfCanBeOptimized", "", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "canBeOptimized", "", "hasPrimaryDelegatedToSecondaryOrSecondaryToPrimary", "isSubclassOfExternalClassWithRequiredBoxParameter", "backend.js"})
@SourceDebugExtension(value={"SMAP\nES6PrimaryConstructorOptimizationLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ES6PrimaryConstructorOptimizationLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/ES6CollectPrimaryConstructorsWhichCouldBeOptimizedLowering\n+ 2 CollectionUtil.kt\norg/jetbrains/kotlin/utils/CollectionUtilKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,292:1\n32#2,2:293\n9#2,6:295\n1869#3,2:301\n*S KotlinDebug\n*F\n+ 1 ES6PrimaryConstructorOptimizationLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/ES6CollectPrimaryConstructorsWhichCouldBeOptimizedLowering\n*L\n268#1:293,2\n268#1:295,6\n269#1:301,2\n*E\n"})
public final class ES6CollectPrimaryConstructorsWhichCouldBeOptimizedLowering
implements DeclarationTransformer {
    @NotNull
    private final JsIrBackendContext context;

    public ES6CollectPrimaryConstructorsWhichCouldBeOptimizedLowering(@NotNull JsIrBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @Nullable
    public List<IrDeclaration> transformFlat(@NotNull IrDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (this.context.getEs6mode() && declaration instanceof IrClass && !((IrClass)declaration).isExternal() && !this.context.getInlineClassesUtils().isClassInlineLike((IrClass)declaration) && ES6PrimaryConstructorOptimizationLoweringKt.access$getPossibilityToOptimizeForEsClass((IrClass)declaration) == null) {
            this.checkIfCanBeOptimized((IrClass)declaration);
        }
        return null;
    }

    private final void checkIfCanBeOptimized(IrClass $this$checkIfCanBeOptimized) {
        IrClass currentClass = $this$checkIfCanBeOptimized;
        MutableReference nearestOptimizationDecision = null;
        while (currentClass != null && !currentClass.isExternal()) {
            MutableReference currentClassOptimizationDecision = ES6PrimaryConstructorOptimizationLoweringKt.access$getPossibilityToOptimizeForEsClass(currentClass);
            if (currentClassOptimizationDecision != null) {
                nearestOptimizationDecision = currentClassOptimizationDecision;
                break;
            }
            currentClass = IrUtilsKt.getSuperClass((IrClass)currentClass);
        }
        if (nearestOptimizationDecision == null) {
            nearestOptimizationDecision = ReferenceKt.mutableReferenceOf(true);
        }
        currentClass = $this$checkIfCanBeOptimized;
        while (currentClass != null && !currentClass.isExternal() && ES6PrimaryConstructorOptimizationLoweringKt.access$getPossibilityToOptimizeForEsClass(currentClass) == null) {
            ES6PrimaryConstructorOptimizationLoweringKt.access$setPossibilityToOptimizeForEsClass(currentClass, nearestOptimizationDecision);
            if (((Boolean)nearestOptimizationDecision.getValue()).booleanValue() && !this.canBeOptimized(currentClass)) {
                nearestOptimizationDecision.setValue(false);
            }
            currentClass = IrUtilsKt.getSuperClass((IrClass)currentClass);
        }
    }

    private final boolean canBeOptimized(IrClass $this$canBeOptimized) {
        return !this.isSubclassOfExternalClassWithRequiredBoxParameter($this$canBeOptimized) && !this.hasPrimaryDelegatedToSecondaryOrSecondaryToPrimary($this$canBeOptimized);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean hasPrimaryDelegatedToSecondaryOrSecondaryToPrimary(IrClass $this$hasPrimaryDelegatedToSecondaryOrSecondaryToPrimary) {
        List list;
        Collection $this$filterIsInstanceAnd$iv = $this$hasPrimaryDelegatedToSecondaryOrSecondaryToPrimary.getDeclarations();
        boolean $i$f$filterIsInstanceAnd = false;
        if ($this$filterIsInstanceAnd$iv.isEmpty()) {
            list = CollectionsKt.emptyList();
        } else {
            void $this$filterIsInstanceAndTo$iv$iv;
            Iterable iterable = $this$filterIsInstanceAnd$iv;
            Collection destination$iv$iv = (Collection)new SmartList();
            boolean $i$f$filterIsInstanceAndTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceAndTo$iv$iv) {
                if (!(element$iv$iv instanceof IrFunction)) continue;
                IrFunction it = (IrFunction)element$iv$iv;
                boolean bl = false;
                if (!ES6ConstructorLoweringKt.isEs6ConstructorReplacement((IrDeclaration)it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrFunction it = (IrFunction)element$iv;
            boolean bl = false;
            Ref.BooleanRef meetUnoptimizedDelegation = new Ref.BooleanRef();
            IrBody irBody = it.getBody();
            if (irBody != null) {
                IrElementTransformerVoidKt.transformChildrenVoid((IrElement)((IrElement)irBody), (IrElementTransformerVoid)new IrElementTransformerVoid(it, meetUnoptimizedDelegation){
                    final /* synthetic */ IrFunction $it;
                    final /* synthetic */ Ref.BooleanRef $meetUnoptimizedDelegation;
                    {
                        this.$it = $it;
                        this.$meetUnoptimizedDelegation = $meetUnoptimizedDelegation;
                    }

                    public IrExpression visitCall(IrCall expression2) {
                        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                        if (ES6ConstructorLoweringKt.isSyntheticDelegatingReplacement((IrFunctionAccessExpression)expression2) && !Intrinsics.areEqual((Object)((IrSimpleFunction)expression2.getSymbol().getOwner()).getOrigin(), (Object)this.$it.getOrigin())) {
                            this.$meetUnoptimizedDelegation.element = true;
                        }
                        return super.visitCall(expression2);
                    }
                });
            }
            if (!meetUnoptimizedDelegation.element) continue;
            return true;
        }
        return false;
    }

    private final boolean isSubclassOfExternalClassWithRequiredBoxParameter(IrClass $this$isSubclassOfExternalClassWithRequiredBoxParameter) {
        IrClass irClass = IrUtilsKt.getSuperClass((IrClass)$this$isSubclassOfExternalClassWithRequiredBoxParameter);
        return (irClass != null ? irClass.isExternal() : false) && JsIrAttributesKt.getNeedsBoxParameter($this$isSubclassOfExternalClassWithRequiredBoxParameter);
    }
}

