/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticLossRisk;
import org.jetbrains.kotlin.diagnostics.DiagnosticMarker;
import org.jetbrains.kotlin.diagnostics.PositioningStrategyKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0016\u0018\u0000*\n\b\u0000\u0010\u0001 \u0000*\u00020\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\u001b\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\rJ\u0015\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00028\u0000H\u0017\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/diagnostics/PositioningStrategy;", "E", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "", "<init>", "()V", "markDiagnostic", "", "Lorg/jetbrains/kotlin/com/intellij/openapi/util/TextRange;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticMarker;", "mark", "element", "(Lcom/intellij/psi/PsiElement;)Ljava/util/List;", "isValid", "", "(Lcom/intellij/psi/PsiElement;)Z", "frontend.common-psi"})
public class PositioningStrategy<E extends PsiElement> {
    @NotNull
    public List<TextRange> markDiagnostic(@NotNull DiagnosticMarker diagnostic) {
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        PsiElement psiElement = diagnostic.getPsiElement();
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type E of org.jetbrains.kotlin.diagnostics.PositioningStrategy");
        return this.mark(psiElement);
    }

    @NotNull
    public List<TextRange> mark(@NotNull E element) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        return PositioningStrategyKt.markElement(element);
    }

    @DiagnosticLossRisk
    public boolean isValid(@NotNull E element) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        return !PositioningStrategyKt.hasSyntaxErrors(element);
    }
}

