/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.typeconversion;

import org.gradle.internal.exceptions.DiagnosticsVisitor;
import org.gradle.internal.typeconversion.NotationConvertResult;
import org.gradle.internal.typeconversion.NotationConverter;
import org.gradle.internal.typeconversion.TypeConversionException;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class LongFromCharSequenceNotationConverter
implements NotationConverter<CharSequence, Long> {
    public void convert(CharSequence notation, NotationConvertResult<? super Long> result) throws TypeConversionException {
        try {
            result.converted((Object)Long.valueOf(notation.toString()));
        }
        catch (NumberFormatException ex) {
            throw new TypeConversionException(String.format("Cannot convert string value '%s' to a long.", notation), (Throwable)ex);
        }
    }

    public void describe(DiagnosticsVisitor visitor) {
        visitor.candidate("A long.");
    }
}

