/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.eclipse.model;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import groovy.util.Node;
import java.util.LinkedHashMap;
import org.gradle.api.Incubating;
import org.gradle.plugins.ide.eclipse.model.WbModuleEntry;
import org.gradle.plugins.ide.eclipse.model.internal.PathUtil;

public class WbDependentModule
implements WbModuleEntry {
    private String archiveName;
    private String deployPath;
    private String handle;

    public WbDependentModule(Node node) {
        this((String)node.attribute((Object)"archiveName"), (String)node.attribute((Object)"deploy-path"), (String)node.attribute((Object)"handle"));
    }

    public WbDependentModule(String deployPath, String handle) {
        this("", deployPath, handle);
    }

    @Incubating
    public WbDependentModule(String archiveName, String deployPath, String handle) {
        Preconditions.checkNotNull((Object)archiveName);
        Preconditions.checkNotNull((Object)deployPath);
        this.archiveName = archiveName;
        this.deployPath = PathUtil.normalizePath(deployPath);
        this.handle = (String)Preconditions.checkNotNull((Object)handle);
    }

    @Incubating
    public String getArchiveName() {
        return this.archiveName;
    }

    @Incubating
    public void setArchiveName(String archiveName) {
        this.archiveName = archiveName;
    }

    public String getDeployPath() {
        return this.deployPath;
    }

    public void setDeployPath(String deployPath) {
        this.deployPath = deployPath;
    }

    public String getHandle() {
        return this.handle;
    }

    public void setHandle(String handle) {
        this.handle = handle;
    }

    @Override
    public void appendNode(Node parentNode) {
        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
        attributes.put("archiveName", this.archiveName);
        attributes.put("deploy-path", this.deployPath);
        attributes.put("handle", this.handle);
        Node node = parentNode.appendNode((Object)"dependent-module", attributes);
        node.appendNode((Object)"dependency-type").setValue((Object)"uses");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!this.getClass().equals(o.getClass())) {
            return false;
        }
        WbDependentModule that = (WbDependentModule)o;
        return Objects.equal((Object)this.archiveName, (Object)that.archiveName) && Objects.equal((Object)this.deployPath, (Object)that.deployPath) && Objects.equal((Object)this.handle, (Object)that.handle);
    }

    public int hashCode() {
        int result = this.archiveName.hashCode();
        result = 31 * result + this.deployPath.hashCode();
        result = 31 * result + this.handle.hashCode();
        return result;
    }

    public String toString() {
        return "WbDependentModule{archiveName='" + this.archiveName + "'deployPath='" + this.deployPath + "', handle='" + this.handle + "'}";
    }
}

