/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.compress;

import java.util.HashMap;
import tim.prune.config.ParamSet;
import tim.prune.function.compress.CompressionMethodType;
import tim.prune.function.compress.MethodList;
import tim.prune.function.compress.methods.CompressionMethod;

public class ParameterValues
extends HashMap<CompressionMethodType, String> {
    public ParameterValues() {
        this.put(CompressionMethodType.NEARBY_WITH_FACTOR, "200");
        this.put(CompressionMethodType.WACKY_POINTS, "2");
        this.put(CompressionMethodType.SINGLETONS, "2");
        this.put(CompressionMethodType.DOUGLAS_PEUCKER, "2000");
        this.put(CompressionMethodType.NEARBY_WITH_DISTANCE, "10");
        this.put(CompressionMethodType.TOO_SLOW, "2");
        this.put(CompressionMethodType.TOO_FAST, "40");
        this.put(CompressionMethodType.TIME_DIFFERENCE, "20");
    }

    public void applyNewStyleConfig(String string) {
        for (CompressionMethod compressionMethod : MethodList.fromConfigString(string)) {
            if (compressionMethod == null || compressionMethod.getType() == CompressionMethodType.DUPLICATES) continue;
            this.applyParameter(compressionMethod.getType(), compressionMethod.getParam());
        }
    }

    public void applyOldStyleConfig(String string) {
        ParamSet paramSet = new ParamSet(string);
        CompressionMethodType[] compressionMethodTypeArray = new CompressionMethodType[]{CompressionMethodType.DUPLICATES, CompressionMethodType.NEARBY_WITH_FACTOR, CompressionMethodType.WACKY_POINTS, CompressionMethodType.SINGLETONS, CompressionMethodType.DOUGLAS_PEUCKER};
        int n = 1;
        while (n < compressionMethodTypeArray.length) {
            this.applyParameter(compressionMethodTypeArray[n], paramSet.getParam(n));
            ++n;
        }
    }

    private void applyParameter(CompressionMethodType compressionMethodType, String string) {
        if (string != null && !string.isEmpty()) {
            this.put(compressionMethodType, string);
        }
    }

    public String getValue(CompressionMethodType compressionMethodType) {
        return this.getOrDefault((Object)compressionMethodType, "");
    }
}

