/*
 * Decompiled with CFR 0.152.
 */
package sarif.managers;

import com.google.gson.JsonArray;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFormatException;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Bookmark;
import ghidra.program.model.listing.BookmarkManager;
import ghidra.program.model.listing.BookmarkType;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import sarif.SarifProgramOptions;
import sarif.export.SarifWriterTask;
import sarif.export.bkmk.SarifBookmarkWriter;
import sarif.managers.SarifMgr;

public class BookmarksSarifMgr
extends SarifMgr {
    public static String KEY = "BOOKMARKS";
    public static String SUBKEY = "Bookmark";
    private BookmarkManager bookmarkMgr;

    public BookmarksSarifMgr(Program program, MessageLog log) {
        super(KEY, program, log);
        this.bookmarkMgr = program.getBookmarkManager();
    }

    @Override
    public boolean read(Map<String, Object> result, SarifProgramOptions options, TaskMonitor monitor) throws AddressFormatException, CancelledException {
        this.processBookmark(result, options == null || options.isOverwriteBookmarkConflicts());
        return true;
    }

    private void processBookmark(Map<String, Object> result, boolean overwrite) {
        Address addr = null;
        try {
            addr = this.getLocation(result);
        }
        catch (AddressOverflowException e1) {
            this.log.appendException((Throwable)e1);
        }
        String type = (String)result.getOrDefault("kind", "Note");
        String category = (String)result.getOrDefault("name", "");
        String comment = (String)result.getOrDefault("comment", "");
        try {
            boolean hasExistingBookmark;
            boolean bl = hasExistingBookmark = this.bookmarkMgr.getBookmark(addr, type, category) != null;
            if (overwrite || !hasExistingBookmark) {
                this.bookmarkMgr.setBookmark(addr, type, category, comment);
            }
            if (!overwrite && hasExistingBookmark) {
                this.log.appendMsg("Conflicting '" + type + "' BOOKMARK ignored at: " + String.valueOf(addr));
            }
        }
        catch (Exception e) {
            this.log.appendException((Throwable)e);
            return;
        }
    }

    void write(JsonArray results, AddressSetView set, TaskMonitor monitor) throws IOException, CancelledException {
        monitor.setMessage("Writing BOOKMARKS ...");
        ArrayList<Bookmark> request = new ArrayList<Bookmark>();
        BookmarkType[] types = this.bookmarkMgr.getBookmarkTypes();
        for (int i = 0; i < types.length; ++i) {
            if (monitor.isCancelled()) {
                throw new CancelledException();
            }
            String typeStr = types[i].getTypeString();
            AddressSetView bmSet = this.bookmarkMgr.getBookmarkAddresses(typeStr);
            if (set != null) {
                bmSet = set.intersect(bmSet);
            }
            AddressIterator iter = bmSet.getAddresses(true);
            while (iter.hasNext()) {
                Address addr = iter.next();
                Bookmark[] bookmarks = this.bookmarkMgr.getBookmarks(addr, typeStr);
                for (int n = 0; n < bookmarks.length; ++n) {
                    request.add(bookmarks[n]);
                }
            }
        }
        BookmarksSarifMgr.writeAsSARIF(request, results);
    }

    public static void writeAsSARIF(List<Bookmark> request, JsonArray results) throws IOException {
        SarifBookmarkWriter writer = new SarifBookmarkWriter(request, null);
        new TaskLauncher((Task)new SarifWriterTask(SUBKEY, writer, results), null);
    }
}

