/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.cli.blobs;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig;
import ghidra.app.util.bin.format.pe.cli.blobs.CliBlob;
import ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.InvalidInputException;
import java.io.IOException;

public class CliSigStandAloneMethod
extends CliAbstractSig {
    private CliAbstractSig.CliRetType retType;
    private CliAbstractSig.CliParam[] params;
    private byte flags;
    private int sizeOfCount;
    private int sentinelIndex = -1;
    private final int STANDALONEMETHODSIG_FLAGS_DEFAULT = 0;
    private final int STANDALONEMETHODSIG_FLAGS_HASTHIS = 32;
    private final int STANDALONEMETHODSIG_FLAGS_EXPLICITTHIS = 64;
    private final int STANDALONEMETHODSIG_FLAGS_VARARG = 5;
    private final int STANDALONEMETHODSIG_FLAGS_C = 1;
    private final int STANDALONEMETHODSIG_FLAGS_STDCALL = 2;
    private final int STANDALONEMETHODSIG_FLAGS_THISCALL = 3;
    private final int STANDALONEMETHODSIG_FLAGS_FASTCALL = 4;

    public CliSigStandAloneMethod(CliBlob blob) throws IOException {
        super(blob);
        BinaryReader reader = this.getContentsReader();
        this.flags = reader.readNextByte();
        long origIndex = reader.getPointerIndex();
        int paramCount = CliSigStandAloneMethod.decodeCompressedUnsignedInt(reader);
        this.sizeOfCount = (int)(reader.getPointerIndex() - origIndex);
        try {
            this.retType = new CliAbstractSig.CliRetType(this, reader);
        }
        catch (InvalidInputException e) {
            this.retType = null;
        }
        this.params = new CliAbstractSig.CliParam[paramCount];
        for (int i = 0; i < paramCount; ++i) {
            if (reader.peekNextByte() == CliAbstractSig.CliElementType.ELEMENT_TYPE_SENTINEL.id()) {
                reader.readNextByte();
                this.sentinelIndex = i;
            }
            try {
                this.params[i] = new CliAbstractSig.CliParam(this, reader);
                continue;
            }
            catch (InvalidInputException e) {
                this.params[i] = null;
            }
        }
    }

    @Override
    public String getContentsName() {
        return "StandAloneMethodSig";
    }

    @Override
    public String getContentsComment() {
        return "Typically for calli instruction; Type info for method return and params";
    }

    @Override
    public DataType getContentsDataType() {
        StructureDataType struct = new StructureDataType(new CategoryPath("/PE/CLI/Blobs/Signatures"), this.getName(), 0);
        struct.add(BYTE, "flags", "ORed VARARG/DEFAULT/C/STDCALL/THISCALL/FASTCALL and HASTHIS/EXPLICITTHIS");
        struct.add(CliSigStandAloneMethod.getDataTypeForBytes(this.sizeOfCount), "Count", "Number of param types to follow RetType");
        struct.add(this.retType.getDefinitionDataType(), "RetType", null);
        for (CliAbstractSig.CliParam param : this.params) {
            struct.add(param.getDefinitionDataType(), null, null);
        }
        return struct;
    }

    public CliAbstractSig.CliRetType getReturnType() {
        return this.retType;
    }

    public CliAbstractSig.CliParam[] getParams() {
        return (CliAbstractSig.CliParam[])this.params.clone();
    }

    public boolean hasThis() {
        return (this.flags & 0x20) == 32;
    }

    public boolean hasExplicitThis() {
        return (this.flags & 0x40) == 64;
    }

    public boolean hasVarArgs() {
        return (this.flags & 5) == 5;
    }

    public CallingConvention getCallingConvention() {
        if ((this.flags & 1) == 1) {
            return CallingConvention.C;
        }
        if ((this.flags & 2) == 2) {
            return CallingConvention.STDCALL;
        }
        if ((this.flags & 3) == 3) {
            return CallingConvention.THISCALL;
        }
        if ((this.flags & 4) == 4) {
            return CallingConvention.FASTCALL;
        }
        return CallingConvention.MANAGED;
    }

    @Override
    public String getRepresentationCommon(CliStreamMetadata stream, boolean isShort) {
        Object rep = this.getRepresentationOf(this.retType, stream, isShort) + " fn(";
        for (CliAbstractSig.CliParam param : this.params) {
            rep = param == null ? (String)rep + "unidentified_param_type, " : (String)rep + this.getRepresentationOf(param, stream, isShort) + ", ";
        }
        if (this.params.length > 0) {
            rep = ((String)rep).substring(0, ((String)rep).length() - 2);
        }
        rep = (String)rep + ")";
        return rep;
    }

    public static enum CallingConvention {
        MANAGED,
        C,
        STDCALL,
        THISCALL,
        FASTCALL;

    }
}

