/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function;

import docking.action.MenuData;
import docking.widgets.dialogs.NumberInputDialog;
import ghidra.app.cmd.function.SetFunctionPurgeCommand;
import ghidra.app.context.ListingActionContext;
import ghidra.app.context.ListingContextAction;
import ghidra.app.plugin.core.function.FunctionPlugin;
import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.util.FunctionLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HelpLocation;

public class EditFunctionPurgeAction
extends ListingContextAction {
    private FunctionPlugin functionPlugin;

    public EditFunctionPurgeAction(FunctionPlugin plugin) {
        super("Edit Function Purge", plugin.getName());
        this.functionPlugin = plugin;
        this.setPopupMenuData(new MenuData(new String[]{"Function", "Edit Function Purge..."}, null, "Stack"));
        this.setHelpLocation(new HelpLocation("FunctionPlugin", "Function_Purge"));
    }

    @Override
    public void actionPerformed(ListingActionContext context) {
        Function function = this.functionPlugin.getFunction(context);
        if (function != null) {
            this.showDialog(function);
        }
    }

    @Override
    protected boolean isEnabledForContext(ListingActionContext context) {
        if (context.hasSelection() || context.getAddress() == null) {
            return false;
        }
        ProgramLocation location = context.getLocation();
        return location instanceof FunctionLocation;
    }

    private void showDialog(Function function) {
        int currentFunctionPurgeSize = function.getStackPurgeSize();
        if (currentFunctionPurgeSize == 0x7FFFFFFE || currentFunctionPurgeSize == Integer.MAX_VALUE) {
            currentFunctionPurgeSize = 0;
        }
        NumberInputDialog numberInputDialog = new NumberInputDialog("Please Enter Function Purge", "Enter Function Purge", Integer.valueOf(currentFunctionPurgeSize), -1048576, 0x100000, false);
        numberInputDialog.setHelpLocation(new HelpLocation("FunctionPlugin", "Function_Purge"));
        if (!numberInputDialog.show()) {
            this.functionPlugin.getTool().setStatusInfo("User cancelled function purge");
            return;
        }
        int newFunctionPurgeSize = numberInputDialog.getValue();
        if (newFunctionPurgeSize != currentFunctionPurgeSize) {
            Program program;
            SetFunctionPurgeCommand command = new SetFunctionPurgeCommand(function, newFunctionPurgeSize);
            PluginTool tool = this.functionPlugin.getTool();
            if (!tool.execute((Command)command, (DomainObject)(program = function.getProgram()))) {
                tool.setStatusInfo("Unable to set function purge on function: " + function.getName());
            }
        }
    }
}

