/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.widgets.dialogs.NumberRangeInputDialog;
import docking.widgets.tree.GTreeFilterProvider;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.support.GTreeFilter;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.DataTypesProvider;
import ghidra.app.plugin.core.datamgr.actions.SecondaryTreeFilterProvider;
import ghidra.app.plugin.core.datamgr.tree.DataTypeArchiveGTree;
import ghidra.app.plugin.core.datamgr.tree.DataTypeNode;
import ghidra.program.model.data.DataType;
import ghidra.util.HelpLocation;
import ghidra.util.datastruct.Range;
import ghidra.util.datastruct.SortedRangeList;

public class FindDataTypesBySizeAction
extends DockingAction {
    public static final String NAME = "Find Data Types by Size";
    private DataTypeManagerPlugin plugin;

    public FindDataTypesBySizeAction(DataTypeManagerPlugin plugin, String menuSubGroup) {
        this(plugin, NAME, menuSubGroup);
    }

    FindDataTypesBySizeAction(DataTypeManagerPlugin plugin, String name, String menuSubGroup) {
        super(name, plugin.getName());
        this.plugin = plugin;
        this.setMenuBarData(new MenuData(new String[]{name + "..."}, null, "VeryLast", -1, menuSubGroup));
        this.setHelpLocation(new HelpLocation("DataTypeManagerPlugin", "Find_Data_Types_By_Size"));
    }

    public void actionPerformed(ActionContext context) {
        NumberRangeInputDialog inputDialog = new NumberRangeInputDialog(this.getName(), "Size(s)");
        inputDialog.setHelpLocation(this.getHelpLocation());
        if (!inputDialog.show()) {
            return;
        }
        SortedRangeList values = inputDialog.getValue();
        DataTypesProvider newProvider = this.plugin.createProvider();
        newProvider.setTitle(this.getName());
        DataTypeArchiveGTree tree = newProvider.getGTree();
        GTreeFilter filter = this.createFilter(values);
        tree.setFilterProvider((GTreeFilterProvider)new SecondaryTreeFilterProvider(tree, filter));
        newProvider.setVisible(true);
    }

    protected GTreeFilter createFilter(SortedRangeList values) {
        return new SizeGTreeFilter(this, values);
    }

    private class SizeGTreeFilter
    implements GTreeFilter {
        private final SortedRangeList sizes;

        SizeGTreeFilter(FindDataTypesBySizeAction findDataTypesBySizeAction, SortedRangeList sizes) {
            this.sizes = sizes;
        }

        public boolean showFilterMatches() {
            return true;
        }

        public boolean acceptsNode(GTreeNode node) {
            if (!(node instanceof DataTypeNode)) {
                return false;
            }
            DataTypeNode dataTypeNode = (DataTypeNode)node;
            DataType dt = dataTypeNode.getDataType();
            int length = dt.getLength();
            if (dt.isZeroLength()) {
                length = 0;
            }
            for (Range range : this.sizes) {
                if (!range.contains(length)) continue;
                return true;
            }
            return false;
        }
    }
}

