/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.store.local;

import ghidra.framework.store.DataFileItem;
import ghidra.framework.store.FolderItem;
import ghidra.framework.store.local.ItemPropertyFile;
import ghidra.framework.store.local.LocalFileSystem;
import ghidra.framework.store.local.LocalFolderItem;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateFileException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.lang3.StringUtils;

public class LocalDataFileItem
extends LocalFolderItem
implements DataFileItem {
    private static final int IO_BUFFER_SIZE = 32768;
    private static final String DATA_FILE = "data.1.gdf";

    public LocalDataFileItem(LocalFileSystem fileSystem, ItemPropertyFile propertyFile) throws IOException {
        super(fileSystem, propertyFile, true, false);
        if (fileSystem.isVersioned()) {
            throw new IOException("Item may be corrupt: " + this.getName());
        }
        if (!this.getDataFile().exists()) {
            throw new FileNotFoundException(this.getName() + " not found");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalDataFileItem(LocalFileSystem fileSystem, ItemPropertyFile propertyFile, InputStream istream, String contentType, TaskMonitor monitor) throws IOException, CancelledException {
        super(fileSystem, propertyFile, true, true);
        if (fileSystem.isVersioned()) {
            this.abortCreate();
            throw new UnsupportedOperationException("Versioning not yet supported for DataFiles");
        }
        if (StringUtils.isBlank((CharSequence)contentType)) {
            this.abortCreate();
            throw new IllegalArgumentException("Missing content-type");
        }
        File dataFile = this.getDataFile();
        if (dataFile.exists()) {
            throw new DuplicateFileException(this.getName() + " already exists.");
        }
        propertyFile.putInt("FILE_TYPE", 1);
        propertyFile.putBoolean("READ_ONLY", false);
        propertyFile.putString("CONTENT_TYPE", contentType);
        propertyFile.writeState();
        if (istream != null) {
            boolean success = false;
            byte[] buffer = new byte[32768];
            FileOutputStream out = new FileOutputStream(dataFile);
            try {
                int cnt = 0;
                while ((cnt = istream.read(buffer)) >= 0) {
                    out.write(buffer, 0, cnt);
                }
                success = true;
            }
            finally {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
                if (!success) {
                    this.abortCreate();
                }
            }
        }
        if (!dataFile.createNewFile()) {
            this.abortCreate();
        }
    }

    @Override
    public long length() throws IOException {
        return this.getDataFile().length();
    }

    private File getDataFile() {
        return new File(this.getDataDir(), DATA_FILE);
    }

    @Override
    public InputStream getInputStream() throws FileNotFoundException {
        return new FileInputStream(this.getDataFile());
    }

    @Override
    public InputStream getInputStream(int version) throws FileNotFoundException {
        return new FileInputStream(this.getDataFile());
    }

    @Override
    public OutputStream getOutputStream() throws FileNotFoundException {
        return new FileOutputStream(this.getDataFile());
    }

    @Override
    public void updateCheckout(FolderItem versionedFolderItem, boolean updateItem, TaskMonitor monitor) throws IOException {
        throw new UnsupportedOperationException("Versioning not yet supported for DataFiles");
    }

    @Override
    public void updateCheckout(FolderItem item, int checkoutVersion) throws IOException {
        throw new UnsupportedOperationException("Versioning not yet supported for DataFiles");
    }

    @Override
    void deleteMinimumVersion(String user) throws IOException {
        throw new UnsupportedOperationException("Versioning not yet supported for DataFiles");
    }

    @Override
    void deleteCurrentVersion(String user) throws IOException {
        throw new UnsupportedOperationException("Versioning not yet supported for DataFiles");
    }

    @Override
    public void output(File outputFile, int version, TaskMonitor monitor) throws IOException {
        throw new UnsupportedOperationException("Output not yet supported for DataFiles");
    }

    @Override
    int getMinimumVersion() throws IOException {
        return -1;
    }

    @Override
    public int getCurrentVersion() {
        return -1;
    }

    @Override
    public boolean canRecover() {
        return false;
    }
}

