/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.visualization.mouse;

import ghidra.graph.visualization.DefaultGraphDisplay;
import ghidra.graph.visualization.mouse.JgtCursorRestoringPlugin;
import ghidra.graph.visualization.mouse.JgtEdgeNavigationPlugin;
import ghidra.graph.visualization.mouse.JgtVertexFocusingPlugin;
import ghidra.service.graph.AttributedEdge;
import ghidra.service.graph.AttributedVertex;
import org.jungrapht.visualization.control.DefaultGraphMouse;
import org.jungrapht.visualization.control.GraphMousePlugin;
import org.jungrapht.visualization.control.RegionSelectingGraphMousePlugin;
import org.jungrapht.visualization.control.ScalingGraphMousePlugin;
import org.jungrapht.visualization.control.SelectingGraphMousePlugin;
import org.jungrapht.visualization.control.TranslatingGraphMousePlugin;
import org.jungrapht.visualization.control.VertexSelectingGraphMousePlugin;

public class JgtGraphMouse
extends DefaultGraphMouse<AttributedVertex, AttributedEdge> {
    private DefaultGraphDisplay graphDisplay;
    private boolean allowEdgeSelection;

    public JgtGraphMouse(DefaultGraphDisplay graphDisplay, boolean allowEdgeSelection) {
        super(DefaultGraphMouse.builder());
        this.graphDisplay = graphDisplay;
        this.allowEdgeSelection = allowEdgeSelection;
    }

    public void loadPlugins() {
        this.add((GraphMousePlugin)new JgtEdgeNavigationPlugin(1024));
        this.add((GraphMousePlugin)new JgtVertexFocusingPlugin(1024, this.graphDisplay));
        this.add((GraphMousePlugin)(this.allowEdgeSelection ? new SelectingGraphMousePlugin() : new VertexSelectingGraphMousePlugin()));
        this.add((GraphMousePlugin)new RegionSelectingGraphMousePlugin());
        this.add((GraphMousePlugin)TranslatingGraphMousePlugin.builder().translatingMask(1024).build());
        this.add((GraphMousePlugin)new ScalingGraphMousePlugin());
        this.add((GraphMousePlugin)new JgtCursorRestoringPlugin());
        this.setPluginsLoaded();
    }

    public boolean allowsEdgeSelection() {
        return this.allowEdgeSelection;
    }
}

