#############################################################################
##
#W  supergroups.g               GAP4 Package `RCWA'               Stefan Kohl
##
##  Data library of groups generated by 3 class transpositions which inter-
##  change residue classes with moduli <= 6: part containing lists of
##  supergroups.
##
##  For all i in [1..52394], supergroups[i] is a list of indices j such that
##  grps[j] is a supergroup of grps[i].
##
#############################################################################

local  supergroups, subgroups, i, j;

subgroups := 
  ReadAsFunction(Concatenation(PackageInfo("rcwa")[1].InstallationPath,
                               "/data/3ctsgroups6/subgroups.g"))();
supergroups := List([1..52394],i->[]);
for i in [1..52394] do
  for j in subgroups[i] do
    Add(supergroups[j],i);
  od;
od;
return supergroups;

#############################################################################
##
#E  supergroups.g . . . . . . . . . . . . . . . . . . . . . . . . . ends here
