/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(MEDIA_STREAM)

#include "JSMediaTrackSupportedConstraints.h"

#include "JSDOMConvertBoolean.h"
#include "JSDOMGlobalObject.h"
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/ObjectConstructor.h>



namespace WebCore {
using namespace JSC;

#if ENABLE(MEDIA_STREAM)

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const MediaTrackSupportedConstraints& dictionary)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    auto aspectRatioValue = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, dictionary.aspectRatio);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "aspectRatio"_s), aspectRatioValue);
    auto backgroundBlurValue = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, dictionary.backgroundBlur);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "backgroundBlur"_s), backgroundBlurValue);
    auto deviceIdValue = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, dictionary.deviceId);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "deviceId"_s), deviceIdValue);
    auto displaySurfaceValue = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, dictionary.displaySurface);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "displaySurface"_s), displaySurfaceValue);
    auto echoCancellationValue = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, dictionary.echoCancellation);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "echoCancellation"_s), echoCancellationValue);
    auto facingModeValue = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, dictionary.facingMode);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "facingMode"_s), facingModeValue);
    auto frameRateValue = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, dictionary.frameRate);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "frameRate"_s), frameRateValue);
    auto groupIdValue = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, dictionary.groupId);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "groupId"_s), groupIdValue);
    auto heightValue = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, dictionary.height);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "height"_s), heightValue);
    auto powerEfficientValue = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, dictionary.powerEfficient);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "powerEfficient"_s), powerEfficientValue);
    auto sampleRateValue = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, dictionary.sampleRate);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "sampleRate"_s), sampleRateValue);
    auto sampleSizeValue = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, dictionary.sampleSize);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "sampleSize"_s), sampleSizeValue);
    auto torchValue = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, dictionary.torch);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "torch"_s), torchValue);
    auto volumeValue = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, dictionary.volume);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "volume"_s), volumeValue);
    auto whiteBalanceModeValue = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, dictionary.whiteBalanceMode);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "whiteBalanceMode"_s), whiteBalanceModeValue);
    auto widthValue = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, dictionary.width);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "width"_s), widthValue);
    auto zoomValue = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, dictionary.zoom);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "zoom"_s), zoomValue);
    return result;
}

#endif

} // namespace WebCore


#endif // ENABLE(MEDIA_STREAM)
