// java wrapper for vtkOpenGLRenderer object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkOpenGLRenderer.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkRenderer_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkOpenGLRenderer_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkOpenGLRenderer",dType)) { return me; }
  if ((res= vtkRenderer_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenGLRenderer_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkOpenGLRenderer* op = static_cast<vtkOpenGLRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenGLRenderer_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkOpenGLRenderer* op = static_cast<vtkOpenGLRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkOpenGLRenderer_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkOpenGLRenderer* op = static_cast<vtkOpenGLRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkOpenGLRenderer_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkOpenGLRenderer* op = static_cast<vtkOpenGLRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLRenderer_DeviceRender_14(JNIEnv* env, jobject obj)
{

  vtkOpenGLRenderer* op = static_cast<vtkOpenGLRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeviceRender();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLRenderer_DeviceRenderOpaqueGeometry_15(JNIEnv* env, jobject obj,jobject id0)
{
  vtkFrameBufferObjectBase * temp0;
  temp0 = static_cast<vtkFrameBufferObjectBase*>(vtkJavaGetPointerFromObject(env, id0));

  vtkOpenGLRenderer* op = static_cast<vtkOpenGLRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeviceRenderOpaqueGeometry(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLRenderer_DeviceRenderTranslucentPolygonalGeometry_16(JNIEnv* env, jobject obj,jobject id0)
{
  vtkFrameBufferObjectBase * temp0;
  temp0 = static_cast<vtkFrameBufferObjectBase*>(vtkJavaGetPointerFromObject(env, id0));

  vtkOpenGLRenderer* op = static_cast<vtkOpenGLRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeviceRenderTranslucentPolygonalGeometry(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLRenderer_Clear_17(JNIEnv* env, jobject obj)
{

  vtkOpenGLRenderer* op = static_cast<vtkOpenGLRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->Clear();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenGLRenderer_UpdateLights_18(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkOpenGLRenderer* op = static_cast<vtkOpenGLRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->UpdateLights();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenGLRenderer_GetDepthPeelingHigherLayer_19(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkOpenGLRenderer* op = static_cast<vtkOpenGLRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDepthPeelingHigherLayer();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkOpenGLRenderer_HaveAppleQueryAllocationBug_110(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkOpenGLRenderer* op = static_cast<vtkOpenGLRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HaveAppleQueryAllocationBug();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkOpenGLRenderer_IsDualDepthPeelingSupported_111(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkOpenGLRenderer* op = static_cast<vtkOpenGLRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsDualDepthPeelingSupported();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkOpenGLRenderer_GetState_112(JNIEnv* env, jobject obj)
{
  vtkOpenGLState * temp20;

  vtkOpenGLRenderer* op = static_cast<vtkOpenGLRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetState();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkOpenGLRenderer_GetLightingUniforms_113(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkOpenGLRenderer* op = static_cast<vtkOpenGLRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLightingUniforms();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLRenderer_UpdateLightingUniforms_114(JNIEnv* env, jobject obj,jobject id0)
{
  vtkShaderProgram * temp0;
  temp0 = static_cast<vtkShaderProgram*>(vtkJavaGetPointerFromObject(env, id0));

  vtkOpenGLRenderer* op = static_cast<vtkOpenGLRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->UpdateLightingUniforms(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenGLRenderer_GetLightingComplexity_115(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkOpenGLRenderer* op = static_cast<vtkOpenGLRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLightingComplexity();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenGLRenderer_GetLightingCount_116(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkOpenGLRenderer* op = static_cast<vtkOpenGLRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLightingCount();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLRenderer_SetUserLightTransform_117(JNIEnv* env, jobject obj,jobject id0)
{
  vtkTransform * temp0;
  temp0 = static_cast<vtkTransform*>(vtkJavaGetPointerFromObject(env, id0));

  vtkOpenGLRenderer* op = static_cast<vtkOpenGLRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUserLightTransform(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkOpenGLRenderer_GetUserLightTransform_118(JNIEnv* env, jobject obj)
{
  vtkTransform * temp20;

  vtkOpenGLRenderer* op = static_cast<vtkOpenGLRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUserLightTransform();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLRenderer_SetEnvMapLookupTable_119(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPBRLUTTexture * temp0;
  temp0 = static_cast<vtkPBRLUTTexture*>(vtkJavaGetPointerFromObject(env, id0));

  vtkOpenGLRenderer* op = static_cast<vtkOpenGLRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEnvMapLookupTable(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkOpenGLRenderer_GetEnvMapLookupTable_120(JNIEnv* env, jobject obj)
{
  vtkPBRLUTTexture * temp20;

  vtkOpenGLRenderer* op = static_cast<vtkOpenGLRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEnvMapLookupTable();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLRenderer_SetEnvMapIrradiance_121(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPBRIrradianceTexture * temp0;
  temp0 = static_cast<vtkPBRIrradianceTexture*>(vtkJavaGetPointerFromObject(env, id0));

  vtkOpenGLRenderer* op = static_cast<vtkOpenGLRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEnvMapIrradiance(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkOpenGLRenderer_GetEnvMapIrradiance_122(JNIEnv* env, jobject obj)
{
  vtkPBRIrradianceTexture * temp20;

  vtkOpenGLRenderer* op = static_cast<vtkOpenGLRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEnvMapIrradiance();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLRenderer_SetEnvMapPrefiltered_123(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPBRPrefilterTexture * temp0;
  temp0 = static_cast<vtkPBRPrefilterTexture*>(vtkJavaGetPointerFromObject(env, id0));

  vtkOpenGLRenderer* op = static_cast<vtkOpenGLRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEnvMapPrefiltered(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkOpenGLRenderer_GetEnvMapPrefiltered_124(JNIEnv* env, jobject obj)
{
  vtkPBRPrefilterTexture * temp20;

  vtkOpenGLRenderer* op = static_cast<vtkOpenGLRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEnvMapPrefiltered();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkOpenGLRenderer_GetSphericalHarmonics_125(JNIEnv* env, jobject obj)
{
  vtkFloatArray * temp20;

  vtkOpenGLRenderer* op = static_cast<vtkOpenGLRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSphericalHarmonics();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLRenderer_SetUseSphericalHarmonics_126(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkOpenGLRenderer* op = static_cast<vtkOpenGLRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUseSphericalHarmonics(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkOpenGLRenderer_GetUseSphericalHarmonics_127(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkOpenGLRenderer* op = static_cast<vtkOpenGLRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUseSphericalHarmonics();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLRenderer_UseSphericalHarmonicsOn_128(JNIEnv* env, jobject obj)
{

  vtkOpenGLRenderer* op = static_cast<vtkOpenGLRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseSphericalHarmonicsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLRenderer_UseSphericalHarmonicsOff_129(JNIEnv* env, jobject obj)
{

  vtkOpenGLRenderer* op = static_cast<vtkOpenGLRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseSphericalHarmonicsOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLRenderer_SetEnvironmentTexture_130(JNIEnv* env, jobject obj,jobject id0,jboolean id1)
{
  vtkTexture * temp0;
  bool   temp1;
  temp0 = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = (id1 != 0) ? true : false;

  vtkOpenGLRenderer* op = static_cast<vtkOpenGLRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEnvironmentTexture(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLRenderer_ReleaseGraphicsResources_131(JNIEnv* env, jobject obj,jobject id0)
{
  vtkWindow * temp0;
  temp0 = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, id0));

  vtkOpenGLRenderer* op = static_cast<vtkOpenGLRenderer*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReleaseGraphicsResources(temp0);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkOpenGLRenderer_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkOpenGLRenderer::New());
}
