// java wrapper for vtkOpenGLRenderWindow object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkOpenGLRenderWindow.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkRenderWindow_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkOpenGLRenderWindow_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkOpenGLRenderWindow",dType)) { return me; }
  if ((res= vtkRenderWindow_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenGLRenderWindow_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkOpenGLRenderWindow* op = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenGLRenderWindow_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkOpenGLRenderWindow* op = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkOpenGLRenderWindow_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkOpenGLRenderWindow* op = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkOpenGLRenderWindow_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkOpenGLRenderWindow* op = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLRenderWindow_Start_14(JNIEnv* env, jobject obj)
{

  vtkOpenGLRenderWindow* op = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->Start();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLRenderWindow_Frame_15(JNIEnv* env, jobject obj)
{

  vtkOpenGLRenderWindow* op = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->Frame();

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkOpenGLRenderWindow_GetRenderingBackend_16(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkOpenGLRenderWindow* op = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRenderingBackend();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLRenderWindow_SetGlobalMaximumNumberOfMultiSamples_17(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkOpenGLRenderWindow* op = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGlobalMaximumNumberOfMultiSamples(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenGLRenderWindow_GetGlobalMaximumNumberOfMultiSamples_18(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkOpenGLRenderWindow* op = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGlobalMaximumNumberOfMultiSamples();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenGLRenderWindow_GetPixelData_19(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jint id3,jint id4,jobject id5,jint id6)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  int   temp4;
  vtkUnsignedCharArray * temp5;
  int   temp6;
  int   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = static_cast<vtkUnsignedCharArray*>(vtkJavaGetPointerFromObject(env, id5));
  temp6 = id6;

  vtkOpenGLRenderWindow* op = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPixelData(temp0,temp1,temp2,temp3,temp4,temp5,temp6);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenGLRenderWindow_SetPixelData_110(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jint id3,jobject id4,jint id5,jint id6)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  vtkUnsignedCharArray * temp4;
  int   temp5;
  int   temp6;
  int   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = static_cast<vtkUnsignedCharArray*>(vtkJavaGetPointerFromObject(env, id4));
  temp5 = id5;
  temp6 = id6;

  vtkOpenGLRenderWindow* op = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetPixelData(temp0,temp1,temp2,temp3,temp4,temp5,temp6);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenGLRenderWindow_GetRGBAPixelData_111(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jint id3,jint id4,jobject id5,jint id6)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  int   temp4;
  vtkFloatArray * temp5;
  int   temp6;
  int   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = static_cast<vtkFloatArray*>(vtkJavaGetPointerFromObject(env, id5));
  temp6 = id6;

  vtkOpenGLRenderWindow* op = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRGBAPixelData(temp0,temp1,temp2,temp3,temp4,temp5,temp6);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenGLRenderWindow_SetRGBAPixelData_112(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jint id3,jobject id4,jint id5,jint id6,jint id7)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  vtkFloatArray * temp4;
  int   temp5;
  int   temp6;
  int   temp7;
  int   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = static_cast<vtkFloatArray*>(vtkJavaGetPointerFromObject(env, id4));
  temp5 = id5;
  temp6 = id6;
  temp7 = id7;

  vtkOpenGLRenderWindow* op = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetRGBAPixelData(temp0,temp1,temp2,temp3,temp4,temp5,temp6,temp7);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenGLRenderWindow_GetRGBACharPixelData_113(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jint id3,jint id4,jobject id5,jint id6)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  int   temp4;
  vtkUnsignedCharArray * temp5;
  int   temp6;
  int   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = static_cast<vtkUnsignedCharArray*>(vtkJavaGetPointerFromObject(env, id5));
  temp6 = id6;

  vtkOpenGLRenderWindow* op = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRGBACharPixelData(temp0,temp1,temp2,temp3,temp4,temp5,temp6);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenGLRenderWindow_SetRGBACharPixelData_114(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jint id3,jobject id4,jint id5,jint id6,jint id7)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  vtkUnsignedCharArray * temp4;
  int   temp5;
  int   temp6;
  int   temp7;
  int   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = static_cast<vtkUnsignedCharArray*>(vtkJavaGetPointerFromObject(env, id4));
  temp5 = id5;
  temp6 = id6;
  temp7 = id7;

  vtkOpenGLRenderWindow* op = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetRGBACharPixelData(temp0,temp1,temp2,temp3,temp4,temp5,temp6,temp7);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenGLRenderWindow_GetZbufferData_115(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jint id3,jobject id4)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  vtkFloatArray * temp4;
  int   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = static_cast<vtkFloatArray*>(vtkJavaGetPointerFromObject(env, id4));

  vtkOpenGLRenderWindow* op = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetZbufferData(temp0,temp1,temp2,temp3,temp4);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenGLRenderWindow_SetZbufferData_116(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jint id3,jobject id4)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  vtkFloatArray * temp4;
  int   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = static_cast<vtkFloatArray*>(vtkJavaGetPointerFromObject(env, id4));

  vtkOpenGLRenderWindow* op = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetZbufferData(temp0,temp1,temp2,temp3,temp4);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLRenderWindow_ActivateTexture_117(JNIEnv* env, jobject obj,jobject id0)
{
  vtkTextureObject * temp0;
  temp0 = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkOpenGLRenderWindow* op = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->ActivateTexture(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLRenderWindow_DeactivateTexture_118(JNIEnv* env, jobject obj,jobject id0)
{
  vtkTextureObject * temp0;
  temp0 = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkOpenGLRenderWindow* op = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeactivateTexture(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenGLRenderWindow_GetTextureUnitForTexture_119(JNIEnv* env, jobject obj,jobject id0)
{
  vtkTextureObject * temp0;
  int   temp20;
  temp0 = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkOpenGLRenderWindow* op = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTextureUnitForTexture(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenGLRenderWindow_GetDepthBufferSize_120(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkOpenGLRenderWindow* op = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDepthBufferSize();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkOpenGLRenderWindow_GetUsingSRGBColorSpace_121(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkOpenGLRenderWindow* op = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUsingSRGBColorSpace();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenGLRenderWindow_GetColorBufferInternalFormat_122(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkOpenGLRenderWindow* op = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetColorBufferInternalFormat(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLRenderWindow_OpenGLInit_123(JNIEnv* env, jobject obj)
{

  vtkOpenGLRenderWindow* op = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->OpenGLInit();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLRenderWindow_OpenGLInitState_124(JNIEnv* env, jobject obj)
{

  vtkOpenGLRenderWindow* op = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->OpenGLInitState();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLRenderWindow_OpenGLInitContext_125(JNIEnv* env, jobject obj)
{

  vtkOpenGLRenderWindow* op = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->OpenGLInitContext();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkOpenGLRenderWindow_GetContextCreationTime_126(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkOpenGLRenderWindow* op = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetContextCreationTime();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkOpenGLRenderWindow_GetShaderCache_127(JNIEnv* env, jobject obj)
{
  vtkOpenGLShaderCache * temp20;

  vtkOpenGLRenderWindow* op = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetShaderCache();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkOpenGLRenderWindow_GetVBOCache_128(JNIEnv* env, jobject obj)
{
  vtkOpenGLVertexBufferObjectCache * temp20;

  vtkOpenGLRenderWindow* op = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVBOCache();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkOpenGLRenderWindow_GetRenderFramebuffer_129(JNIEnv* env, jobject obj)
{
  vtkOpenGLFramebufferObject * temp20;

  vtkOpenGLRenderWindow* op = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRenderFramebuffer();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkOpenGLRenderWindow_GetDisplayFramebuffer_130(JNIEnv* env, jobject obj)
{
  vtkOpenGLFramebufferObject * temp20;

  vtkOpenGLRenderWindow* op = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDisplayFramebuffer();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkOpenGLRenderWindow_GetTextureUnitManager_131(JNIEnv* env, jobject obj)
{
  vtkTextureUnitManager * temp20;

  vtkOpenGLRenderWindow* op = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTextureUnitManager();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLRenderWindow_WaitForCompletion_132(JNIEnv* env, jobject obj)
{

  vtkOpenGLRenderWindow* op = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->WaitForCompletion();

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkOpenGLRenderWindow_GetMaximumHardwareLineWidth_133(JNIEnv* env, jobject obj)
{
  float   temp20;

  vtkOpenGLRenderWindow* op = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaximumHardwareLineWidth();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkOpenGLRenderWindow_IsPointSpriteBugPresent_134(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkOpenGLRenderWindow* op = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsPointSpriteBugPresent();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkOpenGLRenderWindow_IsPrimIDBugPresent_135(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkOpenGLRenderWindow* op = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsPrimIDBugPresent();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenGLRenderWindow_GetDefaultTextureInternalFormat_136(JNIEnv* env, jobject obj,jint id0,jint id1,jboolean id2,jboolean id3,jboolean id4)
{
  int   temp0;
  int   temp1;
  bool   temp2;
  bool   temp3;
  bool   temp4;
  int   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = (id2 != 0) ? true : false;
  temp3 = (id3 != 0) ? true : false;
  temp4 = (id4 != 0) ? true : false;

  vtkOpenGLRenderWindow* op = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDefaultTextureInternalFormat(temp0,temp1,temp2,temp3,temp4);
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkOpenGLRenderWindow_GetOpenGLSupportMessage_137(JNIEnv* env, jobject obj)
{
  std::string   temp20;

  vtkOpenGLRenderWindow* op = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOpenGLSupportMessage();
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenGLRenderWindow_SupportsOpenGL_138(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkOpenGLRenderWindow* op = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SupportsOpenGL();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkOpenGLRenderWindow_ReportCapabilities_139(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkOpenGLRenderWindow* op = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ReportCapabilities();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLRenderWindow_Initialize_140(JNIEnv* env, jobject obj)
{

  vtkOpenGLRenderWindow* op = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->Initialize();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLRenderWindow_PushContext_141(JNIEnv* env, jobject obj)
{

  vtkOpenGLRenderWindow* op = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->PushContext();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLRenderWindow_PopContext_142(JNIEnv* env, jobject obj)
{

  vtkOpenGLRenderWindow* op = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->PopContext();

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkOpenGLRenderWindow_InitializeFromCurrentContext_143(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkOpenGLRenderWindow* op = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->InitializeFromCurrentContext();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkOpenGLRenderWindow_SetSwapControl_144(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  bool   temp20;
  temp0 = id0;

  vtkOpenGLRenderWindow* op = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetSwapControl(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkOpenGLRenderWindow_GetState_145(JNIEnv* env, jobject obj)
{
  vtkOpenGLState * temp20;

  vtkOpenGLRenderWindow* op = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetState();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkOpenGLRenderWindow_GetTQuad2DVBO_146(JNIEnv* env, jobject obj)
{
  vtkOpenGLBufferObject * temp20;

  vtkOpenGLRenderWindow* op = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTQuad2DVBO();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenGLRenderWindow_GetNoiseTextureUnit_147(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkOpenGLRenderWindow* op = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNoiseTextureUnit();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLRenderWindow_End_148(JNIEnv* env, jobject obj)
{

  vtkOpenGLRenderWindow* op = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->End();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLRenderWindow_Render_149(JNIEnv* env, jobject obj)
{

  vtkOpenGLRenderWindow* op = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->Render();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLRenderWindow_StereoMidpoint_150(JNIEnv* env, jobject obj)
{

  vtkOpenGLRenderWindow* op = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->StereoMidpoint();

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkOpenGLRenderWindow_GetBufferNeedsResolving_151(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkOpenGLRenderWindow* op = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBufferNeedsResolving();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLRenderWindow_ReleaseGraphicsResources_152(JNIEnv* env, jobject obj,jobject id0)
{
  vtkWindow * temp0;
  temp0 = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, id0));

  vtkOpenGLRenderWindow* op = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReleaseGraphicsResources(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLRenderWindow_BlitDisplayFramebuffer_153(JNIEnv* env, jobject obj)
{

  vtkOpenGLRenderWindow* op = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->BlitDisplayFramebuffer();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLRenderWindow_BlitDisplayFramebufferColorAndDepth_154(JNIEnv* env, jobject obj)
{

  vtkOpenGLRenderWindow* op = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->BlitDisplayFramebufferColorAndDepth();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLRenderWindow_BlitDisplayFramebuffer_155(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jint id3,jint id4,jint id5,jint id6,jint id7,jint id8,jint id9,jint id10)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  int   temp4;
  int   temp5;
  int   temp6;
  int   temp7;
  int   temp8;
  int   temp9;
  int   temp10;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;
  temp6 = id6;
  temp7 = id7;
  temp8 = id8;
  temp9 = id9;
  temp10 = id10;

  vtkOpenGLRenderWindow* op = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->BlitDisplayFramebuffer(temp0,temp1,temp2,temp3,temp4,temp5,temp6,temp7,temp8,temp9,temp10);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLRenderWindow_BlitToRenderFramebuffer_156(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkOpenGLRenderWindow* op = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->BlitToRenderFramebuffer(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLRenderWindow_BlitToRenderFramebuffer_157(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jint id3,jint id4,jint id5,jint id6,jint id7,jint id8,jint id9)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  int   temp4;
  int   temp5;
  int   temp6;
  int   temp7;
  int   temp8;
  int   temp9;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;
  temp6 = id6;
  temp7 = id7;
  temp8 = id8;
  temp9 = id9;

  vtkOpenGLRenderWindow* op = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->BlitToRenderFramebuffer(temp0,temp1,temp2,temp3,temp4,temp5,temp6,temp7,temp8,temp9);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLRenderWindow_SetFrameBlitMode_158(JNIEnv* env, jobject obj,jint id0)
{
  vtkOpenGLRenderWindow::FrameBlitModes   temp0;
  temp0 = static_cast<vtkOpenGLRenderWindow::FrameBlitModes>(id0);

  vtkOpenGLRenderWindow* op = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFrameBlitMode(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenGLRenderWindow_GetFrameBlitModeMinValue_159(JNIEnv* env, jobject obj)
{
  vtkOpenGLRenderWindow::FrameBlitModes   temp20;

  vtkOpenGLRenderWindow* op = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFrameBlitModeMinValue();
  return static_cast<jint>(temp20);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenGLRenderWindow_GetFrameBlitModeMaxValue_160(JNIEnv* env, jobject obj)
{
  vtkOpenGLRenderWindow::FrameBlitModes   temp20;

  vtkOpenGLRenderWindow* op = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFrameBlitModeMaxValue();
  return static_cast<jint>(temp20);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenGLRenderWindow_GetFrameBlitMode_161(JNIEnv* env, jobject obj)
{
  vtkOpenGLRenderWindow::FrameBlitModes   temp20;

  vtkOpenGLRenderWindow* op = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFrameBlitMode();
  return static_cast<jint>(temp20);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLRenderWindow_SetFrameBlitModeToBlitToHardware_162(JNIEnv* env, jobject obj)
{

  vtkOpenGLRenderWindow* op = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFrameBlitModeToBlitToHardware();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLRenderWindow_SetFrameBlitModeToBlitToCurrent_163(JNIEnv* env, jobject obj)
{

  vtkOpenGLRenderWindow* op = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFrameBlitModeToBlitToCurrent();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLRenderWindow_SetFrameBlitModeToBlitToCurrentWithDepth_164(JNIEnv* env, jobject obj)
{

  vtkOpenGLRenderWindow* op = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFrameBlitModeToBlitToCurrentWithDepth();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLRenderWindow_SetFrameBlitModeToNoBlit_165(JNIEnv* env, jobject obj)
{

  vtkOpenGLRenderWindow* op = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFrameBlitModeToNoBlit();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLRenderWindow_SetFramebufferFlipY_166(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkOpenGLRenderWindow* op = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFramebufferFlipY(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkOpenGLRenderWindow_GetFramebufferFlipY_167(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkOpenGLRenderWindow* op = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFramebufferFlipY();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLRenderWindow_FramebufferFlipYOn_168(JNIEnv* env, jobject obj)
{

  vtkOpenGLRenderWindow* op = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->FramebufferFlipYOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLRenderWindow_FramebufferFlipYOff_169(JNIEnv* env, jobject obj)
{

  vtkOpenGLRenderWindow* op = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->FramebufferFlipYOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLRenderWindow_SetRenderBufferTargetDepthSize_170(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkOpenGLRenderWindow* op = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRenderBufferTargetDepthSize(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenGLRenderWindow_GetRenderBufferTargetDepthSize_171(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkOpenGLRenderWindow* op = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRenderBufferTargetDepthSize();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLRenderWindow_TextureDepthBlit_172(JNIEnv* env, jobject obj,jobject id0)
{
  vtkTextureObject * temp0;
  temp0 = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkOpenGLRenderWindow* op = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->TextureDepthBlit(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLRenderWindow_TextureDepthBlit_173(JNIEnv* env, jobject obj,jobject id0,jint id1,jint id2,jint id3,jint id4)
{
  vtkTextureObject * temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  int   temp4;
  temp0 = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;

  vtkOpenGLRenderWindow* op = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->TextureDepthBlit(temp0,temp1,temp2,temp3,temp4);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLRenderWindow_TextureDepthBlit_174(JNIEnv* env, jobject obj,jobject id0,jint id1,jint id2,jint id3,jint id4,jint id5,jint id6,jint id7,jint id8)
{
  vtkTextureObject * temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  int   temp4;
  int   temp5;
  int   temp6;
  int   temp7;
  int   temp8;
  temp0 = static_cast<vtkTextureObject*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;
  temp6 = id6;
  temp7 = id7;
  temp8 = id8;

  vtkOpenGLRenderWindow* op = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->TextureDepthBlit(temp0,temp1,temp2,temp3,temp4,temp5,temp6,temp7,temp8);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkOpenGLRenderWindow_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkOpenGLRenderWindow::New());
}
