// java wrapper for vtkCellPicker object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkCellPicker.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkPicker_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkCellPicker_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkCellPicker",dType)) { return me; }
  if ((res= vtkPicker_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCellPicker_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCellPicker* op = static_cast<vtkCellPicker*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCellPicker_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCellPicker* op = static_cast<vtkCellPicker*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCellPicker_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCellPicker* op = static_cast<vtkCellPicker*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCellPicker_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCellPicker* op = static_cast<vtkCellPicker*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCellPicker_Pick_14(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jobject id3)
{
  double   temp0;
  double   temp1;
  double   temp2;
  vtkRenderer * temp3;
  int   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, id3));

  vtkCellPicker* op = static_cast<vtkCellPicker*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Pick(temp0,temp1,temp2,temp3);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCellPicker_Pick3DRay_15(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1,jobject id2)
{
  double temp0[3];
  double temp1[4];
  vtkRenderer * temp2;
  int   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 4, &temp1[0]);
  temp2 = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, id2));

  vtkCellPicker* op = static_cast<vtkCellPicker*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Pick3DRay(temp0,temp1,temp2);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->SetDoubleArrayRegion(id1, 0, 4, &temp1[0]);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCellPicker_AddLocator_16(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAbstractCellLocator * temp0;
  temp0 = static_cast<vtkAbstractCellLocator*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCellPicker* op = static_cast<vtkCellPicker*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddLocator(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCellPicker_RemoveLocator_17(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAbstractCellLocator * temp0;
  temp0 = static_cast<vtkAbstractCellLocator*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCellPicker* op = static_cast<vtkCellPicker*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveLocator(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCellPicker_RemoveAllLocators_18(JNIEnv* env, jobject obj)
{

  vtkCellPicker* op = static_cast<vtkCellPicker*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveAllLocators();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCellPicker_SetVolumeOpacityIsovalue_19(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkCellPicker* op = static_cast<vtkCellPicker*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetVolumeOpacityIsovalue(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkCellPicker_GetVolumeOpacityIsovalue_110(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkCellPicker* op = static_cast<vtkCellPicker*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVolumeOpacityIsovalue();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCellPicker_SetUseVolumeGradientOpacity_111(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkCellPicker* op = static_cast<vtkCellPicker*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUseVolumeGradientOpacity(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCellPicker_UseVolumeGradientOpacityOn_112(JNIEnv* env, jobject obj)
{

  vtkCellPicker* op = static_cast<vtkCellPicker*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseVolumeGradientOpacityOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCellPicker_UseVolumeGradientOpacityOff_113(JNIEnv* env, jobject obj)
{

  vtkCellPicker* op = static_cast<vtkCellPicker*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseVolumeGradientOpacityOff();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCellPicker_GetUseVolumeGradientOpacity_114(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCellPicker* op = static_cast<vtkCellPicker*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUseVolumeGradientOpacity();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCellPicker_SetPickClippingPlanes_115(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkCellPicker* op = static_cast<vtkCellPicker*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPickClippingPlanes(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCellPicker_PickClippingPlanesOn_116(JNIEnv* env, jobject obj)
{

  vtkCellPicker* op = static_cast<vtkCellPicker*>(vtkJavaGetPointerFromObject(env, obj));
  op->PickClippingPlanesOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCellPicker_PickClippingPlanesOff_117(JNIEnv* env, jobject obj)
{

  vtkCellPicker* op = static_cast<vtkCellPicker*>(vtkJavaGetPointerFromObject(env, obj));
  op->PickClippingPlanesOff();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCellPicker_GetPickClippingPlanes_118(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCellPicker* op = static_cast<vtkCellPicker*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPickClippingPlanes();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCellPicker_GetClippingPlaneId_119(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCellPicker* op = static_cast<vtkCellPicker*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetClippingPlaneId();
  return temp20;

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkCellPicker_GetPickNormal_120(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkCellPicker* op = static_cast<vtkCellPicker*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPickNormal();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkCellPicker_GetMapperNormal_121(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkCellPicker* op = static_cast<vtkCellPicker*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMapperNormal();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkCellPicker_GetPointIJK_122(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkCellPicker* op = static_cast<vtkCellPicker*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointIJK();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 3);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkCellPicker_GetCellIJK_123(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkCellPicker* op = static_cast<vtkCellPicker*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellIJK();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 3);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCellPicker_GetPointId_124(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkCellPicker* op = static_cast<vtkCellPicker*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointId();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCellPicker_GetCellId_125(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkCellPicker* op = static_cast<vtkCellPicker*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellId();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCellPicker_GetSubId_126(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCellPicker* op = static_cast<vtkCellPicker*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSubId();
  return temp20;

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkCellPicker_GetPCoords_127(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkCellPicker* op = static_cast<vtkCellPicker*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPCoords();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCellPicker_GetTexture_128(JNIEnv* env, jobject obj)
{
  vtkTexture * temp20;

  vtkCellPicker* op = static_cast<vtkCellPicker*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTexture();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCellPicker_SetPickTextureData_129(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkCellPicker* op = static_cast<vtkCellPicker*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPickTextureData(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCellPicker_PickTextureDataOn_130(JNIEnv* env, jobject obj)
{

  vtkCellPicker* op = static_cast<vtkCellPicker*>(vtkJavaGetPointerFromObject(env, obj));
  op->PickTextureDataOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCellPicker_PickTextureDataOff_131(JNIEnv* env, jobject obj)
{

  vtkCellPicker* op = static_cast<vtkCellPicker*>(vtkJavaGetPointerFromObject(env, obj));
  op->PickTextureDataOff();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCellPicker_GetPickTextureData_132(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCellPicker* op = static_cast<vtkCellPicker*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPickTextureData();
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkCellPicker_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkCellPicker::New());
}
