// java wrapper for vtkROIStencilSource object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkROIStencilSource.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkImageStencilSource_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkROIStencilSource_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkROIStencilSource",dType)) { return me; }
  if ((res= vtkImageStencilSource_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkROIStencilSource_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkROIStencilSource* op = static_cast<vtkROIStencilSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkROIStencilSource_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkROIStencilSource* op = static_cast<vtkROIStencilSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkROIStencilSource_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkROIStencilSource* op = static_cast<vtkROIStencilSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkROIStencilSource_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkROIStencilSource* op = static_cast<vtkROIStencilSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkROIStencilSource_GetShape_14(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkROIStencilSource* op = static_cast<vtkROIStencilSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetShape();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkROIStencilSource_SetShape_15(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkROIStencilSource* op = static_cast<vtkROIStencilSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetShape(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkROIStencilSource_GetShapeMinValue_16(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkROIStencilSource* op = static_cast<vtkROIStencilSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetShapeMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkROIStencilSource_GetShapeMaxValue_17(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkROIStencilSource* op = static_cast<vtkROIStencilSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetShapeMaxValue();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkROIStencilSource_SetShapeToBox_18(JNIEnv* env, jobject obj)
{

  vtkROIStencilSource* op = static_cast<vtkROIStencilSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetShapeToBox();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkROIStencilSource_SetShapeToEllipsoid_19(JNIEnv* env, jobject obj)
{

  vtkROIStencilSource* op = static_cast<vtkROIStencilSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetShapeToEllipsoid();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkROIStencilSource_SetShapeToCylinderX_110(JNIEnv* env, jobject obj)
{

  vtkROIStencilSource* op = static_cast<vtkROIStencilSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetShapeToCylinderX();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkROIStencilSource_SetShapeToCylinderY_111(JNIEnv* env, jobject obj)
{

  vtkROIStencilSource* op = static_cast<vtkROIStencilSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetShapeToCylinderY();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkROIStencilSource_SetShapeToCylinderZ_112(JNIEnv* env, jobject obj)
{

  vtkROIStencilSource* op = static_cast<vtkROIStencilSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetShapeToCylinderZ();

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkROIStencilSource_GetShapeAsString_113(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkROIStencilSource* op = static_cast<vtkROIStencilSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetShapeAsString();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkROIStencilSource_GetBounds_114(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkROIStencilSource* op = static_cast<vtkROIStencilSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBounds();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 6);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkROIStencilSource_SetBounds_115(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3,jdouble id4,jdouble id5)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  double   temp4;
  double   temp5;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;

  vtkROIStencilSource* op = static_cast<vtkROIStencilSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBounds(temp0,temp1,temp2,temp3,temp4,temp5);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkROIStencilSource_SetBounds_116(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[6];
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

  vtkROIStencilSource* op = static_cast<vtkROIStencilSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBounds(temp0);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkROIStencilSource_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkROIStencilSource::New());
}
