// java wrapper for vtkImageHistogram object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkImageHistogram.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkThreadedImageAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkImageHistogram_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkImageHistogram",dType)) { return me; }
  if ((res= vtkThreadedImageAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageHistogram_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageHistogram* op = static_cast<vtkImageHistogram*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageHistogram_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageHistogram* op = static_cast<vtkImageHistogram*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageHistogram_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageHistogram* op = static_cast<vtkImageHistogram*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageHistogram_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageHistogram* op = static_cast<vtkImageHistogram*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageHistogram_SetActiveComponent_14(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImageHistogram* op = static_cast<vtkImageHistogram*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetActiveComponent(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageHistogram_GetActiveComponent_15(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageHistogram* op = static_cast<vtkImageHistogram*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetActiveComponent();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageHistogram_SetAutomaticBinning_16(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImageHistogram* op = static_cast<vtkImageHistogram*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAutomaticBinning(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageHistogram_AutomaticBinningOn_17(JNIEnv* env, jobject obj)
{

  vtkImageHistogram* op = static_cast<vtkImageHistogram*>(vtkJavaGetPointerFromObject(env, obj));
  op->AutomaticBinningOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageHistogram_AutomaticBinningOff_18(JNIEnv* env, jobject obj)
{

  vtkImageHistogram* op = static_cast<vtkImageHistogram*>(vtkJavaGetPointerFromObject(env, obj));
  op->AutomaticBinningOff();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageHistogram_GetAutomaticBinning_19(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageHistogram* op = static_cast<vtkImageHistogram*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAutomaticBinning();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageHistogram_SetMaximumNumberOfBins_110(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImageHistogram* op = static_cast<vtkImageHistogram*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMaximumNumberOfBins(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageHistogram_GetMaximumNumberOfBins_111(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageHistogram* op = static_cast<vtkImageHistogram*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaximumNumberOfBins();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageHistogram_SetNumberOfBins_112(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImageHistogram* op = static_cast<vtkImageHistogram*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfBins(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageHistogram_GetNumberOfBins_113(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageHistogram* op = static_cast<vtkImageHistogram*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfBins();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageHistogram_SetBinOrigin_114(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkImageHistogram* op = static_cast<vtkImageHistogram*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBinOrigin(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkImageHistogram_GetBinOrigin_115(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkImageHistogram* op = static_cast<vtkImageHistogram*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBinOrigin();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageHistogram_SetBinSpacing_116(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkImageHistogram* op = static_cast<vtkImageHistogram*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBinSpacing(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkImageHistogram_GetBinSpacing_117(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkImageHistogram* op = static_cast<vtkImageHistogram*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBinSpacing();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageHistogram_SetStencilData_118(JNIEnv* env, jobject obj,jobject id0)
{
  vtkImageStencilData * temp0;
  temp0 = static_cast<vtkImageStencilData*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImageHistogram* op = static_cast<vtkImageHistogram*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetStencilData(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageHistogram_GetStencil_119(JNIEnv* env, jobject obj)
{
  vtkImageStencilData * temp20;

  vtkImageHistogram* op = static_cast<vtkImageHistogram*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetStencil();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageHistogram_SetStencilConnection_120(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAlgorithmOutput * temp0;
  temp0 = static_cast<vtkAlgorithmOutput*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImageHistogram* op = static_cast<vtkImageHistogram*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetStencilConnection(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageHistogram_SetGenerateHistogramImage_121(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImageHistogram* op = static_cast<vtkImageHistogram*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGenerateHistogramImage(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageHistogram_GenerateHistogramImageOn_122(JNIEnv* env, jobject obj)
{

  vtkImageHistogram* op = static_cast<vtkImageHistogram*>(vtkJavaGetPointerFromObject(env, obj));
  op->GenerateHistogramImageOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageHistogram_GenerateHistogramImageOff_123(JNIEnv* env, jobject obj)
{

  vtkImageHistogram* op = static_cast<vtkImageHistogram*>(vtkJavaGetPointerFromObject(env, obj));
  op->GenerateHistogramImageOff();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageHistogram_GetGenerateHistogramImage_124(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageHistogram* op = static_cast<vtkImageHistogram*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGenerateHistogramImage();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageHistogram_SetHistogramImageSize_125(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkImageHistogram* op = static_cast<vtkImageHistogram*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetHistogramImageSize(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageHistogram_SetHistogramImageSize_126(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[2];
  env->GetIntArrayRegion(id0, 0, 2, reinterpret_cast<jint*>(&temp0[0]));

  vtkImageHistogram* op = static_cast<vtkImageHistogram*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetHistogramImageSize(temp0);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkImageHistogram_GetHistogramImageSize_127(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkImageHistogram* op = static_cast<vtkImageHistogram*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetHistogramImageSize();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageHistogram_SetHistogramImageScale_128(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImageHistogram* op = static_cast<vtkImageHistogram*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetHistogramImageScale(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageHistogram_GetHistogramImageScaleMinValue_129(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageHistogram* op = static_cast<vtkImageHistogram*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetHistogramImageScaleMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageHistogram_GetHistogramImageScaleMaxValue_130(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageHistogram* op = static_cast<vtkImageHistogram*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetHistogramImageScaleMaxValue();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageHistogram_SetHistogramImageScaleToLinear_131(JNIEnv* env, jobject obj)
{

  vtkImageHistogram* op = static_cast<vtkImageHistogram*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetHistogramImageScaleToLinear();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageHistogram_SetHistogramImageScaleToLog_132(JNIEnv* env, jobject obj)
{

  vtkImageHistogram* op = static_cast<vtkImageHistogram*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetHistogramImageScaleToLog();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageHistogram_SetHistogramImageScaleToSqrt_133(JNIEnv* env, jobject obj)
{

  vtkImageHistogram* op = static_cast<vtkImageHistogram*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetHistogramImageScaleToSqrt();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageHistogram_GetHistogramImageScale_134(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageHistogram* op = static_cast<vtkImageHistogram*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetHistogramImageScale();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkImageHistogram_GetHistogramImageScaleAsString_135(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkImageHistogram* op = static_cast<vtkImageHistogram*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetHistogramImageScaleAsString();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageHistogram_GetHistogram_136(JNIEnv* env, jobject obj)
{
  vtkIdTypeArray * temp20;

  vtkImageHistogram* op = static_cast<vtkImageHistogram*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetHistogram();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageHistogram_GetTotal_137(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkImageHistogram* op = static_cast<vtkImageHistogram*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTotal();
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkImageHistogram_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkImageHistogram::New());
}
