// java wrapper for vtkSQLiteDatabase object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkSQLiteDatabase.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkSQLDatabase_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkSQLiteDatabase_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkSQLiteDatabase",dType)) { return me; }
  if ((res= vtkSQLDatabase_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSQLiteDatabase_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSQLiteDatabase* op = static_cast<vtkSQLiteDatabase*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSQLiteDatabase_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSQLiteDatabase* op = static_cast<vtkSQLiteDatabase*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSQLiteDatabase_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSQLiteDatabase* op = static_cast<vtkSQLiteDatabase*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSQLiteDatabase_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSQLiteDatabase* op = static_cast<vtkSQLiteDatabase*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkSQLiteDatabase_Open_14(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  bool   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSQLiteDatabase* op = static_cast<vtkSQLiteDatabase*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Open(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkSQLiteDatabase_Open_15(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  bool   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkSQLiteDatabase* op = static_cast<vtkSQLiteDatabase*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Open(temp0,temp1);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSQLiteDatabase_Close_16(JNIEnv* env, jobject obj)
{

  vtkSQLiteDatabase* op = static_cast<vtkSQLiteDatabase*>(vtkJavaGetPointerFromObject(env, obj));
  op->Close();

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkSQLiteDatabase_IsOpen_17(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkSQLiteDatabase* op = static_cast<vtkSQLiteDatabase*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsOpen();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSQLiteDatabase_GetQueryInstance_18(JNIEnv* env, jobject obj)
{
  vtkSQLQuery * temp20;

  vtkSQLiteDatabase* op = static_cast<vtkSQLiteDatabase*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetQueryInstance();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSQLiteDatabase_GetTables_19(JNIEnv* env, jobject obj)
{
  vtkStringArray * temp20;

  vtkSQLiteDatabase* op = static_cast<vtkSQLiteDatabase*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTables();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSQLiteDatabase_GetRecord_110(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  vtkStringArray * temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSQLiteDatabase* op = static_cast<vtkSQLiteDatabase*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRecord(temp0);
  delete[] temp0;
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkSQLiteDatabase_IsSupported_111(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  bool   temp20;
  temp0 = id0;

  vtkSQLiteDatabase* op = static_cast<vtkSQLiteDatabase*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsSupported(temp0);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkSQLiteDatabase_HasError_112(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkSQLiteDatabase* op = static_cast<vtkSQLiteDatabase*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasError();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkSQLiteDatabase_GetLastErrorText_113(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkSQLiteDatabase* op = static_cast<vtkSQLiteDatabase*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLastErrorText();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkSQLiteDatabase_GetDatabaseType_114(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkSQLiteDatabase* op = static_cast<vtkSQLiteDatabase*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDatabaseType();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkSQLiteDatabase_GetDatabaseFileName_115(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkSQLiteDatabase* op = static_cast<vtkSQLiteDatabase*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDatabaseFileName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSQLiteDatabase_SetDatabaseFileName_116(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSQLiteDatabase* op = static_cast<vtkSQLiteDatabase*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDatabaseFileName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkSQLiteDatabase_GetURL_117(JNIEnv* env, jobject obj)
{
  vtkStdString   temp20;

  vtkSQLiteDatabase* op = static_cast<vtkSQLiteDatabase*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetURL();
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkSQLiteDatabase_GetColumnSpecification_118(JNIEnv* env, jobject obj,jobject id0,jint id1,jint id2)
{
  vtkSQLDatabaseSchema * temp0;
  int   temp1;
  int   temp2;
  vtkStdString   temp20;
  temp0 = static_cast<vtkSQLDatabaseSchema*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;
  temp2 = id2;

  vtkSQLiteDatabase* op = static_cast<vtkSQLiteDatabase*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetColumnSpecification(temp0,temp1,temp2);
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkSQLiteDatabase_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkSQLiteDatabase::New());
}
