// java wrapper for vtkMFIXReader object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkMFIXReader.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkUnstructuredGridAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkMFIXReader_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkMFIXReader",dType)) { return me; }
  if ((res= vtkUnstructuredGridAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMFIXReader_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMFIXReader* op = static_cast<vtkMFIXReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMFIXReader_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMFIXReader* op = static_cast<vtkMFIXReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMFIXReader_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMFIXReader* op = static_cast<vtkMFIXReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMFIXReader_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMFIXReader* op = static_cast<vtkMFIXReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMFIXReader_SetFileName_14(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMFIXReader* op = static_cast<vtkMFIXReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFileName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkMFIXReader_GetFileName_15(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkMFIXReader* op = static_cast<vtkMFIXReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFileName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMFIXReader_GetNumberOfCells_16(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkMFIXReader* op = static_cast<vtkMFIXReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfCells();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMFIXReader_GetNumberOfPoints_17(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkMFIXReader* op = static_cast<vtkMFIXReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfPoints();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMFIXReader_GetNumberOfCellFields_18(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkMFIXReader* op = static_cast<vtkMFIXReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfCellFields();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMFIXReader_SetTimeStep_19(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkMFIXReader* op = static_cast<vtkMFIXReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTimeStep(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMFIXReader_GetTimeStep_110(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkMFIXReader* op = static_cast<vtkMFIXReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTimeStep();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMFIXReader_GetNumberOfTimeSteps_111(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkMFIXReader* op = static_cast<vtkMFIXReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfTimeSteps();
  return temp20;

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkMFIXReader_GetTimeStepRange_112(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkMFIXReader* op = static_cast<vtkMFIXReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTimeStepRange();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMFIXReader_SetTimeStepRange_113(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkMFIXReader* op = static_cast<vtkMFIXReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTimeStepRange(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMFIXReader_SetTimeStepRange_114(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[2];
  env->GetIntArrayRegion(id0, 0, 2, reinterpret_cast<jint*>(&temp0[0]));

  vtkMFIXReader* op = static_cast<vtkMFIXReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTimeStepRange(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMFIXReader_GetNumberOfCellArrays_115(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkMFIXReader* op = static_cast<vtkMFIXReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfCellArrays();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkMFIXReader_GetCellArrayName_116(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkMFIXReader* op = static_cast<vtkMFIXReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellArrayName(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMFIXReader_GetCellArrayStatus_117(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMFIXReader* op = static_cast<vtkMFIXReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellArrayStatus(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMFIXReader_SetCellArrayStatus_118(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkMFIXReader* op = static_cast<vtkMFIXReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCellArrayStatus(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMFIXReader_DisableAllCellArrays_119(JNIEnv* env, jobject obj)
{

  vtkMFIXReader* op = static_cast<vtkMFIXReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->DisableAllCellArrays();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMFIXReader_EnableAllCellArrays_120(JNIEnv* env, jobject obj)
{

  vtkMFIXReader* op = static_cast<vtkMFIXReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->EnableAllCellArrays();

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkMFIXReader_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkMFIXReader::New());
}
