// java wrapper for vtkExodusIIReader object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkExodusIIReader.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkMultiBlockDataSetAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkExodusIIReader_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkExodusIIReader",dType)) { return me; }
  if ((res= vtkMultiBlockDataSetAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkExodusIIReader_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkExodusIIReader_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_CanReadFile_14(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CanReadFile(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkExodusIIReader_GetMTime_15(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMTime();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkExodusIIReader_GetMetadataMTime_16(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMetadataMTime();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_SetFileName_17(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFileName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkExodusIIReader_GetFileName_18(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFileName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_SetXMLFileName_19(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetXMLFileName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkExodusIIReader_GetXMLFileName_110(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetXMLFileName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_SetTimeStep_111(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTimeStep(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetTimeStep_112(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTimeStep();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_SetModeShape_113(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetModeShape(temp0);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkExodusIIReader_GetModeShapesRange_114(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetModeShapesRange();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 2);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkExodusIIReader_GetTimeStepRange_115(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTimeStepRange();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_SetGenerateObjectIdCellArray_116(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGenerateObjectIdCellArray(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetGenerateObjectIdCellArray_117(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGenerateObjectIdCellArray();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_GenerateObjectIdCellArrayOn_118(JNIEnv* env, jobject obj)
{

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->GenerateObjectIdCellArrayOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_GenerateObjectIdCellArrayOff_119(JNIEnv* env, jobject obj)
{

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->GenerateObjectIdCellArrayOff();

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkExodusIIReader_GetObjectIdArrayName_120(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetObjectIdArrayName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_SetGenerateGlobalElementIdArray_121(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGenerateGlobalElementIdArray(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetGenerateGlobalElementIdArray_122(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGenerateGlobalElementIdArray();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_GenerateGlobalElementIdArrayOn_123(JNIEnv* env, jobject obj)
{

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->GenerateGlobalElementIdArrayOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_GenerateGlobalElementIdArrayOff_124(JNIEnv* env, jobject obj)
{

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->GenerateGlobalElementIdArrayOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_SetGenerateGlobalNodeIdArray_125(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGenerateGlobalNodeIdArray(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetGenerateGlobalNodeIdArray_126(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGenerateGlobalNodeIdArray();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_GenerateGlobalNodeIdArrayOn_127(JNIEnv* env, jobject obj)
{

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->GenerateGlobalNodeIdArrayOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_GenerateGlobalNodeIdArrayOff_128(JNIEnv* env, jobject obj)
{

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->GenerateGlobalNodeIdArrayOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_SetGenerateImplicitElementIdArray_129(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGenerateImplicitElementIdArray(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetGenerateImplicitElementIdArray_130(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGenerateImplicitElementIdArray();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_GenerateImplicitElementIdArrayOn_131(JNIEnv* env, jobject obj)
{

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->GenerateImplicitElementIdArrayOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_GenerateImplicitElementIdArrayOff_132(JNIEnv* env, jobject obj)
{

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->GenerateImplicitElementIdArrayOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_SetGenerateImplicitNodeIdArray_133(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGenerateImplicitNodeIdArray(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetGenerateImplicitNodeIdArray_134(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGenerateImplicitNodeIdArray();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_GenerateImplicitNodeIdArrayOn_135(JNIEnv* env, jobject obj)
{

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->GenerateImplicitNodeIdArrayOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_GenerateImplicitNodeIdArrayOff_136(JNIEnv* env, jobject obj)
{

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->GenerateImplicitNodeIdArrayOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_SetGenerateFileIdArray_137(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGenerateFileIdArray(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetGenerateFileIdArray_138(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGenerateFileIdArray();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_GenerateFileIdArrayOn_139(JNIEnv* env, jobject obj)
{

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->GenerateFileIdArrayOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_GenerateFileIdArrayOff_140(JNIEnv* env, jobject obj)
{

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->GenerateFileIdArrayOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_SetFileId_141(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFileId(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetFileId_142(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFileId();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkExodusIIReader_GetGlobalElementIdArrayName_143(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGlobalElementIdArrayName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkExodusIIReader_GetPedigreeElementIdArrayName_144(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPedigreeElementIdArrayName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetGlobalElementID_145(JNIEnv* env, jobject obj,jobject id0,jint id1)
{
  vtkDataSet * temp0;
  int   temp1;
  int   temp20;
  temp0 = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGlobalElementID(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetGlobalElementID_146(JNIEnv* env, jobject obj,jobject id0,jint id1,jint id2)
{
  vtkDataSet * temp0;
  int   temp1;
  int   temp2;
  int   temp20;
  temp0 = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;
  temp2 = id2;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGlobalElementID(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkExodusIIReader_GetImplicitElementIdArrayName_147(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetImplicitElementIdArrayName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkExodusIIReader_GetGlobalFaceIdArrayName_148(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGlobalFaceIdArrayName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkExodusIIReader_GetPedigreeFaceIdArrayName_149(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPedigreeFaceIdArrayName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetGlobalFaceID_150(JNIEnv* env, jobject obj,jobject id0,jint id1)
{
  vtkDataSet * temp0;
  int   temp1;
  int   temp20;
  temp0 = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGlobalFaceID(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetGlobalFaceID_151(JNIEnv* env, jobject obj,jobject id0,jint id1,jint id2)
{
  vtkDataSet * temp0;
  int   temp1;
  int   temp2;
  int   temp20;
  temp0 = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;
  temp2 = id2;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGlobalFaceID(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkExodusIIReader_GetImplicitFaceIdArrayName_152(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetImplicitFaceIdArrayName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkExodusIIReader_GetGlobalEdgeIdArrayName_153(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGlobalEdgeIdArrayName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkExodusIIReader_GetPedigreeEdgeIdArrayName_154(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPedigreeEdgeIdArrayName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetGlobalEdgeID_155(JNIEnv* env, jobject obj,jobject id0,jint id1)
{
  vtkDataSet * temp0;
  int   temp1;
  int   temp20;
  temp0 = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGlobalEdgeID(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetGlobalEdgeID_156(JNIEnv* env, jobject obj,jobject id0,jint id1,jint id2)
{
  vtkDataSet * temp0;
  int   temp1;
  int   temp2;
  int   temp20;
  temp0 = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;
  temp2 = id2;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGlobalEdgeID(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkExodusIIReader_GetImplicitEdgeIdArrayName_157(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetImplicitEdgeIdArrayName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkExodusIIReader_GetGlobalNodeIdArrayName_158(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGlobalNodeIdArrayName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkExodusIIReader_GetPedigreeNodeIdArrayName_159(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPedigreeNodeIdArrayName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetGlobalNodeID_160(JNIEnv* env, jobject obj,jobject id0,jint id1)
{
  vtkDataSet * temp0;
  int   temp1;
  int   temp20;
  temp0 = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGlobalNodeID(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetGlobalNodeID_161(JNIEnv* env, jobject obj,jobject id0,jint id1,jint id2)
{
  vtkDataSet * temp0;
  int   temp1;
  int   temp2;
  int   temp20;
  temp0 = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;
  temp2 = id2;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGlobalNodeID(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkExodusIIReader_GetImplicitNodeIdArrayName_162(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetImplicitNodeIdArrayName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkExodusIIReader_GetSideSetSourceElementIdArrayName_163(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSideSetSourceElementIdArrayName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkExodusIIReader_GetSideSetSourceElementSideArrayName_164(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSideSetSourceElementSideArrayName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_SetApplyDisplacements_165(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetApplyDisplacements(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetApplyDisplacements_166(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetApplyDisplacements();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_ApplyDisplacementsOn_167(JNIEnv* env, jobject obj)
{

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->ApplyDisplacementsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_ApplyDisplacementsOff_168(JNIEnv* env, jobject obj)
{

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->ApplyDisplacementsOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_SetDisplacementMagnitude_169(JNIEnv* env, jobject obj,jfloat id0)
{
  float   temp0;
  temp0 = id0;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDisplacementMagnitude(temp0);

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkExodusIIReader_GetDisplacementMagnitude_170(JNIEnv* env, jobject obj)
{
  float   temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDisplacementMagnitude();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_SetHasModeShapes_171(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetHasModeShapes(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetHasModeShapes_172(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetHasModeShapes();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_HasModeShapesOn_173(JNIEnv* env, jobject obj)
{

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->HasModeShapesOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_HasModeShapesOff_174(JNIEnv* env, jobject obj)
{

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->HasModeShapesOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_SetModeShapeTime_175(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetModeShapeTime(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkExodusIIReader_GetModeShapeTime_176(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetModeShapeTime();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_SetAnimateModeShapes_177(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAnimateModeShapes(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetAnimateModeShapes_178(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAnimateModeShapes();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_AnimateModeShapesOn_179(JNIEnv* env, jobject obj)
{

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->AnimateModeShapesOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_AnimateModeShapesOff_180(JNIEnv* env, jobject obj)
{

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->AnimateModeShapesOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_SetIgnoreFileTime_181(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetIgnoreFileTime(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkExodusIIReader_GetIgnoreFileTime_182(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetIgnoreFileTime();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_IgnoreFileTimeOn_183(JNIEnv* env, jobject obj)
{

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->IgnoreFileTimeOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_IgnoreFileTimeOff_184(JNIEnv* env, jobject obj)
{

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->IgnoreFileTimeOff();

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkExodusIIReader_GetTitle_185(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTitle();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetDimensionality_186(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDimensionality();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetNumberOfTimeSteps_187(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfTimeSteps();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetNumberOfNodesInFile_188(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfNodesInFile();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetNumberOfEdgesInFile_189(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfEdgesInFile();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetNumberOfFacesInFile_190(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfFacesInFile();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetNumberOfElementsInFile_191(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfElementsInFile();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetObjectTypeFromName_192(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetObjectTypeFromName(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkExodusIIReader_GetObjectTypeName_193(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetObjectTypeName(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetNumberOfNodes_194(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfNodes();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetNumberOfObjects_195(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfObjects(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetNumberOfEntriesInObject_196(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  int   temp20;
  temp0 = id0;
  temp1 = id1;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfEntriesInObject(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetObjectId_197(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  int   temp20;
  temp0 = id0;
  temp1 = id1;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetObjectId(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkExodusIIReader_GetObjectName_198(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  const char * temp20;
  temp0 = id0;
  temp1 = id1;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetObjectName(temp0,temp1);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetObjectIndex_199(JNIEnv* env, jobject obj,jint id0, jbyteArray id1, jint len1)
{
  int   temp0;
  char * temp1;
  int   temp20;
  temp0 = id0;
  temp1 = vtkJavaUTF8ToChars(env, id1, len1);

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetObjectIndex(temp0,temp1);
  delete[] temp1;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetObjectIndex_1100(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  int   temp20;
  temp0 = id0;
  temp1 = id1;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetObjectIndex(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetObjectStatus_1101(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  int   temp20;
  temp0 = id0;
  temp1 = id1;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetObjectStatus(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetObjectStatus_1102(JNIEnv* env, jobject obj,jint id0, jbyteArray id1, jint len1)
{
  int   temp0;
  char * temp1;
  int   temp20;
  temp0 = id0;
  temp1 = vtkJavaUTF8ToChars(env, id1, len1);

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetObjectStatus(temp0,temp1);
  delete[] temp1;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_SetObjectStatus_1103(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2)
{
  int   temp0;
  int   temp1;
  int   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetObjectStatus(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_SetObjectStatus_1104(JNIEnv* env, jobject obj,jint id0, jbyteArray id1, jint len1,jint id2)
{
  int   temp0;
  char * temp1;
  int   temp2;
  temp0 = id0;
  temp1 = vtkJavaUTF8ToChars(env, id1, len1);
  temp2 = id2;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetObjectStatus(temp0,temp1,temp2);
  delete[] temp1;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetNumberOfObjectArrays_1105(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfObjectArrays(temp0);
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkExodusIIReader_GetObjectArrayName_1106(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  const char * temp20;
  temp0 = id0;
  temp1 = id1;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetObjectArrayName(temp0,temp1);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetObjectArrayIndex_1107(JNIEnv* env, jobject obj,jint id0, jbyteArray id1, jint len1)
{
  int   temp0;
  char * temp1;
  int   temp20;
  temp0 = id0;
  temp1 = vtkJavaUTF8ToChars(env, id1, len1);

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetObjectArrayIndex(temp0,temp1);
  delete[] temp1;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetNumberOfObjectArrayComponents_1108(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  int   temp20;
  temp0 = id0;
  temp1 = id1;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfObjectArrayComponents(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetObjectArrayStatus_1109(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  int   temp20;
  temp0 = id0;
  temp1 = id1;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetObjectArrayStatus(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetObjectArrayStatus_1110(JNIEnv* env, jobject obj,jint id0, jbyteArray id1, jint len1)
{
  int   temp0;
  char * temp1;
  int   temp20;
  temp0 = id0;
  temp1 = vtkJavaUTF8ToChars(env, id1, len1);

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetObjectArrayStatus(temp0,temp1);
  delete[] temp1;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_SetObjectArrayStatus_1111(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2)
{
  int   temp0;
  int   temp1;
  int   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetObjectArrayStatus(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_SetObjectArrayStatus_1112(JNIEnv* env, jobject obj,jint id0, jbyteArray id1, jint len1,jint id2)
{
  int   temp0;
  char * temp1;
  int   temp2;
  temp0 = id0;
  temp1 = vtkJavaUTF8ToChars(env, id1, len1);
  temp2 = id2;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetObjectArrayStatus(temp0,temp1,temp2);
  delete[] temp1;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetNumberOfObjectAttributes_1113(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  int   temp20;
  temp0 = id0;
  temp1 = id1;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfObjectAttributes(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkExodusIIReader_GetObjectAttributeName_1114(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2)
{
  int   temp0;
  int   temp1;
  int   temp2;
  const char * temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetObjectAttributeName(temp0,temp1,temp2);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetObjectAttributeIndex_1115(JNIEnv* env, jobject obj,jint id0,jint id1, jbyteArray id2, jint len2)
{
  int   temp0;
  int   temp1;
  char * temp2;
  int   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = vtkJavaUTF8ToChars(env, id2, len2);

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetObjectAttributeIndex(temp0,temp1,temp2);
  delete[] temp2;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetObjectAttributeStatus_1116(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetObjectAttributeStatus(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetObjectAttributeStatus_1117(JNIEnv* env, jobject obj,jint id0,jint id1, jbyteArray id2, jint len2)
{
  int   temp0;
  int   temp1;
  char * temp2;
  int   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = vtkJavaUTF8ToChars(env, id2, len2);

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetObjectAttributeStatus(temp0,temp1,temp2);
  delete[] temp2;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_SetObjectAttributeStatus_1118(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jint id3)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetObjectAttributeStatus(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_SetObjectAttributeStatus_1119(JNIEnv* env, jobject obj,jint id0,jint id1, jbyteArray id2, jint len2,jint id3)
{
  int   temp0;
  int   temp1;
  char * temp2;
  int   temp3;
  temp0 = id0;
  temp1 = id1;
  temp2 = vtkJavaUTF8ToChars(env, id2, len2);
  temp3 = id3;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetObjectAttributeStatus(temp0,temp1,temp2,temp3);
  delete[] temp2;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkExodusIIReader_GetTotalNumberOfNodes_1120(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTotalNumberOfNodes();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkExodusIIReader_GetTotalNumberOfEdges_1121(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTotalNumberOfEdges();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkExodusIIReader_GetTotalNumberOfFaces_1122(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTotalNumberOfFaces();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkExodusIIReader_GetTotalNumberOfElements_1123(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTotalNumberOfElements();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetNumberOfPartArrays_1124(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfPartArrays();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkExodusIIReader_GetPartArrayName_1125(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPartArrayName(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetPartArrayID_1126(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPartArrayID(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkExodusIIReader_GetPartBlockInfo_1127(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPartBlockInfo(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_SetPartArrayStatus_1128(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPartArrayStatus(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_SetPartArrayStatus_1129(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPartArrayStatus(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetPartArrayStatus_1130(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPartArrayStatus(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetPartArrayStatus_1131(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPartArrayStatus(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetNumberOfMaterialArrays_1132(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfMaterialArrays();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkExodusIIReader_GetMaterialArrayName_1133(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaterialArrayName(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetMaterialArrayID_1134(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaterialArrayID(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_SetMaterialArrayStatus_1135(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMaterialArrayStatus(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_SetMaterialArrayStatus_1136(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMaterialArrayStatus(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetMaterialArrayStatus_1137(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaterialArrayStatus(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetMaterialArrayStatus_1138(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaterialArrayStatus(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetNumberOfAssemblyArrays_1139(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfAssemblyArrays();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkExodusIIReader_GetAssemblyArrayName_1140(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAssemblyArrayName(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetAssemblyArrayID_1141(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAssemblyArrayID(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_SetAssemblyArrayStatus_1142(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAssemblyArrayStatus(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_SetAssemblyArrayStatus_1143(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAssemblyArrayStatus(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetAssemblyArrayStatus_1144(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAssemblyArrayStatus(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetAssemblyArrayStatus_1145(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAssemblyArrayStatus(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetNumberOfHierarchyArrays_1146(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfHierarchyArrays();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkExodusIIReader_GetHierarchyArrayName_1147(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetHierarchyArrayName(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_SetHierarchyArrayStatus_1148(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetHierarchyArrayStatus(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_SetHierarchyArrayStatus_1149(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetHierarchyArrayStatus(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetHierarchyArrayStatus_1150(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetHierarchyArrayStatus(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetHierarchyArrayStatus_1151(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetHierarchyArrayStatus(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetDisplayType_1152(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDisplayType();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_SetDisplayType_1153(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDisplayType(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_IsValidVariable_1154(JNIEnv* env, jobject obj, jbyteArray id0, jint len0, jbyteArray id1, jint len1)
{
  char * temp0;
  char * temp1;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = vtkJavaUTF8ToChars(env, id1, len1);

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsValidVariable(temp0,temp1);
  delete[] temp0;
  delete[] temp1;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetVariableID_1155(JNIEnv* env, jobject obj, jbyteArray id0, jint len0, jbyteArray id1, jint len1)
{
  char * temp0;
  char * temp1;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = vtkJavaUTF8ToChars(env, id1, len1);

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVariableID(temp0,temp1);
  delete[] temp0;
  delete[] temp1;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_SetAllArrayStatus_1156(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAllArrayStatus(temp0,temp1);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetTimeSeriesData_1157(JNIEnv* env, jobject obj,jint id0, jbyteArray id1, jint len1, jbyteArray id2, jint len2,jobject id3)
{
  int   temp0;
  char * temp1;
  char * temp2;
  vtkFloatArray * temp3;
  int   temp20;
  temp0 = id0;
  temp1 = vtkJavaUTF8ToChars(env, id1, len1);
  temp2 = vtkJavaUTF8ToChars(env, id2, len2);
  temp3 = static_cast<vtkFloatArray*>(vtkJavaGetPointerFromObject(env, id3));

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTimeSeriesData(temp0,temp1,temp2,temp3);
  delete[] temp1;
  delete[] temp2;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetNumberOfEdgeBlockArrays_1158(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfEdgeBlockArrays();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkExodusIIReader_GetEdgeBlockArrayName_1159(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgeBlockArrayName(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetEdgeBlockArrayStatus_1160(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgeBlockArrayStatus(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_SetEdgeBlockArrayStatus_1161(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEdgeBlockArrayStatus(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetNumberOfFaceBlockArrays_1162(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfFaceBlockArrays();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkExodusIIReader_GetFaceBlockArrayName_1163(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFaceBlockArrayName(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetFaceBlockArrayStatus_1164(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFaceBlockArrayStatus(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_SetFaceBlockArrayStatus_1165(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFaceBlockArrayStatus(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetNumberOfElementBlockArrays_1166(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfElementBlockArrays();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkExodusIIReader_GetElementBlockArrayName_1167(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetElementBlockArrayName(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetElementBlockArrayStatus_1168(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetElementBlockArrayStatus(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_SetElementBlockArrayStatus_1169(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetElementBlockArrayStatus(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetNumberOfGlobalResultArrays_1170(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGlobalResultArrays();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkExodusIIReader_GetGlobalResultArrayName_1171(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGlobalResultArrayName(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetGlobalResultArrayStatus_1172(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGlobalResultArrayStatus(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_SetGlobalResultArrayStatus_1173(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGlobalResultArrayStatus(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetNumberOfPointResultArrays_1174(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfPointResultArrays();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkExodusIIReader_GetPointResultArrayName_1175(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointResultArrayName(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetPointResultArrayStatus_1176(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointResultArrayStatus(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_SetPointResultArrayStatus_1177(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPointResultArrayStatus(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetNumberOfEdgeResultArrays_1178(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfEdgeResultArrays();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkExodusIIReader_GetEdgeResultArrayName_1179(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgeResultArrayName(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetEdgeResultArrayStatus_1180(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgeResultArrayStatus(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_SetEdgeResultArrayStatus_1181(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEdgeResultArrayStatus(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetNumberOfFaceResultArrays_1182(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfFaceResultArrays();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkExodusIIReader_GetFaceResultArrayName_1183(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFaceResultArrayName(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetFaceResultArrayStatus_1184(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFaceResultArrayStatus(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_SetFaceResultArrayStatus_1185(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFaceResultArrayStatus(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetNumberOfElementResultArrays_1186(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfElementResultArrays();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkExodusIIReader_GetElementResultArrayName_1187(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetElementResultArrayName(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetElementResultArrayStatus_1188(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetElementResultArrayStatus(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_SetElementResultArrayStatus_1189(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetElementResultArrayStatus(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetNumberOfNodeMapArrays_1190(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfNodeMapArrays();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkExodusIIReader_GetNodeMapArrayName_1191(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNodeMapArrayName(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetNodeMapArrayStatus_1192(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNodeMapArrayStatus(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_SetNodeMapArrayStatus_1193(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNodeMapArrayStatus(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetNumberOfEdgeMapArrays_1194(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfEdgeMapArrays();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkExodusIIReader_GetEdgeMapArrayName_1195(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgeMapArrayName(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetEdgeMapArrayStatus_1196(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgeMapArrayStatus(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_SetEdgeMapArrayStatus_1197(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEdgeMapArrayStatus(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetNumberOfFaceMapArrays_1198(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfFaceMapArrays();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkExodusIIReader_GetFaceMapArrayName_1199(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFaceMapArrayName(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetFaceMapArrayStatus_1200(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFaceMapArrayStatus(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_SetFaceMapArrayStatus_1201(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFaceMapArrayStatus(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetNumberOfElementMapArrays_1202(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfElementMapArrays();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkExodusIIReader_GetElementMapArrayName_1203(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetElementMapArrayName(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetElementMapArrayStatus_1204(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetElementMapArrayStatus(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_SetElementMapArrayStatus_1205(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetElementMapArrayStatus(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetNumberOfNodeSetArrays_1206(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfNodeSetArrays();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkExodusIIReader_GetNodeSetArrayName_1207(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNodeSetArrayName(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetNodeSetArrayStatus_1208(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNodeSetArrayStatus(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_SetNodeSetArrayStatus_1209(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNodeSetArrayStatus(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetNumberOfSideSetArrays_1210(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfSideSetArrays();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkExodusIIReader_GetSideSetArrayName_1211(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSideSetArrayName(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetSideSetArrayStatus_1212(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSideSetArrayStatus(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_SetSideSetArrayStatus_1213(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSideSetArrayStatus(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetNumberOfEdgeSetArrays_1214(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfEdgeSetArrays();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkExodusIIReader_GetEdgeSetArrayName_1215(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgeSetArrayName(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetEdgeSetArrayStatus_1216(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgeSetArrayStatus(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_SetEdgeSetArrayStatus_1217(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEdgeSetArrayStatus(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetNumberOfFaceSetArrays_1218(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfFaceSetArrays();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkExodusIIReader_GetFaceSetArrayName_1219(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFaceSetArrayName(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetFaceSetArrayStatus_1220(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFaceSetArrayStatus(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_SetFaceSetArrayStatus_1221(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFaceSetArrayStatus(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetNumberOfElementSetArrays_1222(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfElementSetArrays();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkExodusIIReader_GetElementSetArrayName_1223(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetElementSetArrayName(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetElementSetArrayStatus_1224(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetElementSetArrayStatus(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_SetElementSetArrayStatus_1225(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetElementSetArrayStatus(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetNumberOfNodeSetResultArrays_1226(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfNodeSetResultArrays();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkExodusIIReader_GetNodeSetResultArrayName_1227(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNodeSetResultArrayName(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetNodeSetResultArrayStatus_1228(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNodeSetResultArrayStatus(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_SetNodeSetResultArrayStatus_1229(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNodeSetResultArrayStatus(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetNumberOfSideSetResultArrays_1230(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfSideSetResultArrays();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkExodusIIReader_GetSideSetResultArrayName_1231(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSideSetResultArrayName(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetSideSetResultArrayStatus_1232(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSideSetResultArrayStatus(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_SetSideSetResultArrayStatus_1233(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSideSetResultArrayStatus(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetNumberOfEdgeSetResultArrays_1234(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfEdgeSetResultArrays();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkExodusIIReader_GetEdgeSetResultArrayName_1235(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgeSetResultArrayName(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetEdgeSetResultArrayStatus_1236(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgeSetResultArrayStatus(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_SetEdgeSetResultArrayStatus_1237(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEdgeSetResultArrayStatus(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetNumberOfFaceSetResultArrays_1238(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfFaceSetResultArrays();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkExodusIIReader_GetFaceSetResultArrayName_1239(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFaceSetResultArrayName(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetFaceSetResultArrayStatus_1240(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFaceSetResultArrayStatus(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_SetFaceSetResultArrayStatus_1241(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFaceSetResultArrayStatus(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetNumberOfElementSetResultArrays_1242(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfElementSetResultArrays();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkExodusIIReader_GetElementSetResultArrayName_1243(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetElementSetResultArrayName(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetElementSetResultArrayStatus_1244(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetElementSetResultArrayStatus(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_SetElementSetResultArrayStatus_1245(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetElementSetResultArrayStatus(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_Reset_1246(JNIEnv* env, jobject obj)
{

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->Reset();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_ResetSettings_1247(JNIEnv* env, jobject obj)
{

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->ResetSettings();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_ResetCache_1248(JNIEnv* env, jobject obj)
{

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->ResetCache();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_SetCacheSize_1249(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCacheSize(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkExodusIIReader_GetCacheSize_1250(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCacheSize();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_SetSqueezePoints_1251(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSqueezePoints(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkExodusIIReader_GetSqueezePoints_1252(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSqueezePoints();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_Dump_1253(JNIEnv* env, jobject obj)
{

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->Dump();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkExodusIIReader_GetSIL_1254(JNIEnv* env, jobject obj)
{
  vtkGraph * temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSIL();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetSILUpdateStamp_1255(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSILUpdateStamp();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExodusIIReader_GetMaxNameLength_1256(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaxNameLength();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkExodusIIReader_GLOBAL_1VARIABLE_1257(JNIEnv* env, jobject obj)
{
  vtkInformationIntegerKey * temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GLOBAL_VARIABLE();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkExodusIIReader_GLOBAL_1TEMPORAL_1VARIABLE_1258(JNIEnv* env, jobject obj)
{
  vtkInformationIntegerKey * temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GLOBAL_TEMPORAL_VARIABLE();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_SetUseLegacyBlockNames_1259(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUseLegacyBlockNames(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkExodusIIReader_GetUseLegacyBlockNames_1260(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUseLegacyBlockNames();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_UseLegacyBlockNamesOn_1261(JNIEnv* env, jobject obj)
{

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseLegacyBlockNamesOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExodusIIReader_UseLegacyBlockNamesOff_1262(JNIEnv* env, jobject obj)
{

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseLegacyBlockNamesOff();

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkExodusIIReader_GetObjectName_1263(JNIEnv* env, jobject obj)
{
  std::string   temp20;

  vtkExodusIIReader* op = static_cast<vtkExodusIIReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetObjectName();
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkExodusIIReader_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkExodusIIReader::New());
}
