// java wrapper for vtkSelectPolyData object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkSelectPolyData.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkPolyDataAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkSelectPolyData_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkSelectPolyData",dType)) { return me; }
  if ((res= vtkPolyDataAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSelectPolyData_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSelectPolyData* op = static_cast<vtkSelectPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSelectPolyData_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSelectPolyData* op = static_cast<vtkSelectPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSelectPolyData_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSelectPolyData* op = static_cast<vtkSelectPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSelectPolyData_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSelectPolyData* op = static_cast<vtkSelectPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectPolyData_SetGenerateSelectionScalars_14(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkSelectPolyData* op = static_cast<vtkSelectPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGenerateSelectionScalars(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSelectPolyData_GetGenerateSelectionScalars_15(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSelectPolyData* op = static_cast<vtkSelectPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGenerateSelectionScalars();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectPolyData_GenerateSelectionScalarsOn_16(JNIEnv* env, jobject obj)
{

  vtkSelectPolyData* op = static_cast<vtkSelectPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->GenerateSelectionScalarsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectPolyData_GenerateSelectionScalarsOff_17(JNIEnv* env, jobject obj)
{

  vtkSelectPolyData* op = static_cast<vtkSelectPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->GenerateSelectionScalarsOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectPolyData_SetSelectionScalarsArrayName_18(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSelectPolyData* op = static_cast<vtkSelectPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSelectionScalarsArrayName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkSelectPolyData_GetSelectionScalarsArrayName_19(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkSelectPolyData* op = static_cast<vtkSelectPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSelectionScalarsArrayName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectPolyData_SetInsideOut_110(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkSelectPolyData* op = static_cast<vtkSelectPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInsideOut(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSelectPolyData_GetInsideOut_111(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSelectPolyData* op = static_cast<vtkSelectPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInsideOut();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectPolyData_InsideOutOn_112(JNIEnv* env, jobject obj)
{

  vtkSelectPolyData* op = static_cast<vtkSelectPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->InsideOutOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectPolyData_InsideOutOff_113(JNIEnv* env, jobject obj)
{

  vtkSelectPolyData* op = static_cast<vtkSelectPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->InsideOutOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectPolyData_SetEdgeSearchMode_114(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkSelectPolyData* op = static_cast<vtkSelectPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEdgeSearchMode(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSelectPolyData_GetEdgeSearchModeMinValue_115(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSelectPolyData* op = static_cast<vtkSelectPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgeSearchModeMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSelectPolyData_GetEdgeSearchModeMaxValue_116(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSelectPolyData* op = static_cast<vtkSelectPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgeSearchModeMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSelectPolyData_GetEdgeSearchMode_117(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSelectPolyData* op = static_cast<vtkSelectPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgeSearchMode();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectPolyData_SetEdgeSearchModeToGreedy_118(JNIEnv* env, jobject obj)
{

  vtkSelectPolyData* op = static_cast<vtkSelectPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEdgeSearchModeToGreedy();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectPolyData_SetEdgeSearchModeToDijkstra_119(JNIEnv* env, jobject obj)
{

  vtkSelectPolyData* op = static_cast<vtkSelectPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEdgeSearchModeToDijkstra();

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkSelectPolyData_GetEdgeSearchModeAsString_120(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkSelectPolyData* op = static_cast<vtkSelectPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgeSearchModeAsString();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectPolyData_SetLoop_121(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPoints * temp0;
  temp0 = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, id0));

  vtkSelectPolyData* op = static_cast<vtkSelectPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLoop(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSelectPolyData_GetLoop_122(JNIEnv* env, jobject obj)
{
  vtkPoints * temp20;

  vtkSelectPolyData* op = static_cast<vtkSelectPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLoop();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectPolyData_SetClosestPoint_123(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkSelectPolyData* op = static_cast<vtkSelectPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetClosestPoint(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectPolyData_SetClosestPoint_124(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkSelectPolyData* op = static_cast<vtkSelectPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetClosestPoint(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkSelectPolyData_GetClosestPoint_125(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkSelectPolyData* op = static_cast<vtkSelectPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetClosestPoint();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectPolyData_SetSelectionMode_126(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkSelectPolyData* op = static_cast<vtkSelectPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSelectionMode(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSelectPolyData_GetSelectionModeMinValue_127(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSelectPolyData* op = static_cast<vtkSelectPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSelectionModeMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSelectPolyData_GetSelectionModeMaxValue_128(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSelectPolyData* op = static_cast<vtkSelectPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSelectionModeMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSelectPolyData_GetSelectionMode_129(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSelectPolyData* op = static_cast<vtkSelectPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSelectionMode();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectPolyData_SetSelectionModeToSmallestRegion_130(JNIEnv* env, jobject obj)
{

  vtkSelectPolyData* op = static_cast<vtkSelectPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSelectionModeToSmallestRegion();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectPolyData_SetSelectionModeToLargestRegion_131(JNIEnv* env, jobject obj)
{

  vtkSelectPolyData* op = static_cast<vtkSelectPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSelectionModeToLargestRegion();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectPolyData_SetSelectionModeToClosestPointRegion_132(JNIEnv* env, jobject obj)
{

  vtkSelectPolyData* op = static_cast<vtkSelectPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSelectionModeToClosestPointRegion();

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkSelectPolyData_GetSelectionModeAsString_133(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkSelectPolyData* op = static_cast<vtkSelectPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSelectionModeAsString();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectPolyData_SetGenerateUnselectedOutput_134(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkSelectPolyData* op = static_cast<vtkSelectPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGenerateUnselectedOutput(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSelectPolyData_GetGenerateUnselectedOutput_135(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSelectPolyData* op = static_cast<vtkSelectPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGenerateUnselectedOutput();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectPolyData_GenerateUnselectedOutputOn_136(JNIEnv* env, jobject obj)
{

  vtkSelectPolyData* op = static_cast<vtkSelectPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->GenerateUnselectedOutputOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectPolyData_GenerateUnselectedOutputOff_137(JNIEnv* env, jobject obj)
{

  vtkSelectPolyData* op = static_cast<vtkSelectPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->GenerateUnselectedOutputOff();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSelectPolyData_GetUnselectedOutput_138(JNIEnv* env, jobject obj)
{
  vtkPolyData * temp20;

  vtkSelectPolyData* op = static_cast<vtkSelectPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUnselectedOutput();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSelectPolyData_GetUnselectedOutputPort_139(JNIEnv* env, jobject obj)
{
  vtkAlgorithmOutput * temp20;

  vtkSelectPolyData* op = static_cast<vtkSelectPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUnselectedOutputPort();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSelectPolyData_GetSelectionEdges_140(JNIEnv* env, jobject obj)
{
  vtkPolyData * temp20;

  vtkSelectPolyData* op = static_cast<vtkSelectPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSelectionEdges();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSelectPolyData_GetMTime_141(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkSelectPolyData* op = static_cast<vtkSelectPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMTime();
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkSelectPolyData_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkSelectPolyData::New());
}
