// java wrapper for vtkCollisionDetectionFilter object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkCollisionDetectionFilter.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkPolyDataAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkCollisionDetectionFilter_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkCollisionDetectionFilter",dType)) { return me; }
  if ((res= vtkPolyDataAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCollisionDetectionFilter_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCollisionDetectionFilter* op = static_cast<vtkCollisionDetectionFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCollisionDetectionFilter_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCollisionDetectionFilter* op = static_cast<vtkCollisionDetectionFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCollisionDetectionFilter_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCollisionDetectionFilter* op = static_cast<vtkCollisionDetectionFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCollisionDetectionFilter_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCollisionDetectionFilter* op = static_cast<vtkCollisionDetectionFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCollisionDetectionFilter_SetCollisionMode_14(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkCollisionDetectionFilter* op = static_cast<vtkCollisionDetectionFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCollisionMode(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCollisionDetectionFilter_GetCollisionModeMinValue_15(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCollisionDetectionFilter* op = static_cast<vtkCollisionDetectionFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCollisionModeMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCollisionDetectionFilter_GetCollisionModeMaxValue_16(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCollisionDetectionFilter* op = static_cast<vtkCollisionDetectionFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCollisionModeMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCollisionDetectionFilter_GetCollisionMode_17(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCollisionDetectionFilter* op = static_cast<vtkCollisionDetectionFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCollisionMode();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCollisionDetectionFilter_SetCollisionModeToAllContacts_18(JNIEnv* env, jobject obj)
{

  vtkCollisionDetectionFilter* op = static_cast<vtkCollisionDetectionFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCollisionModeToAllContacts();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCollisionDetectionFilter_SetCollisionModeToFirstContact_19(JNIEnv* env, jobject obj)
{

  vtkCollisionDetectionFilter* op = static_cast<vtkCollisionDetectionFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCollisionModeToFirstContact();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCollisionDetectionFilter_SetCollisionModeToHalfContacts_110(JNIEnv* env, jobject obj)
{

  vtkCollisionDetectionFilter* op = static_cast<vtkCollisionDetectionFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCollisionModeToHalfContacts();

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkCollisionDetectionFilter_GetCollisionModeAsString_111(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkCollisionDetectionFilter* op = static_cast<vtkCollisionDetectionFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCollisionModeAsString();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCollisionDetectionFilter_SetInputData_112(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkPolyData * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, id1));

  vtkCollisionDetectionFilter* op = static_cast<vtkCollisionDetectionFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInputData(temp0,temp1);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCollisionDetectionFilter_GetInputData_113(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkPolyData * temp20;
  temp0 = id0;

  vtkCollisionDetectionFilter* op = static_cast<vtkCollisionDetectionFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInputData(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCollisionDetectionFilter_GetContactCells_114(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkIdTypeArray * temp20;
  temp0 = id0;

  vtkCollisionDetectionFilter* op = static_cast<vtkCollisionDetectionFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetContactCells(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCollisionDetectionFilter_GetContactsOutputPort_115(JNIEnv* env, jobject obj)
{
  vtkAlgorithmOutput * temp20;

  vtkCollisionDetectionFilter* op = static_cast<vtkCollisionDetectionFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetContactsOutputPort();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCollisionDetectionFilter_GetContactsOutput_116(JNIEnv* env, jobject obj)
{
  vtkPolyData * temp20;

  vtkCollisionDetectionFilter* op = static_cast<vtkCollisionDetectionFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetContactsOutput();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCollisionDetectionFilter_SetTransform_117(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkLinearTransform * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkLinearTransform*>(vtkJavaGetPointerFromObject(env, id1));

  vtkCollisionDetectionFilter* op = static_cast<vtkCollisionDetectionFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTransform(temp0,temp1);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCollisionDetectionFilter_GetTransform_118(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkLinearTransform * temp20;
  temp0 = id0;

  vtkCollisionDetectionFilter* op = static_cast<vtkCollisionDetectionFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTransform(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCollisionDetectionFilter_SetMatrix_119(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkMatrix4x4 * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, id1));

  vtkCollisionDetectionFilter* op = static_cast<vtkCollisionDetectionFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMatrix(temp0,temp1);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCollisionDetectionFilter_GetMatrix_120(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkMatrix4x4 * temp20;
  temp0 = id0;

  vtkCollisionDetectionFilter* op = static_cast<vtkCollisionDetectionFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMatrix(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCollisionDetectionFilter_SetBoxTolerance_121(JNIEnv* env, jobject obj,jfloat id0)
{
  float   temp0;
  temp0 = id0;

  vtkCollisionDetectionFilter* op = static_cast<vtkCollisionDetectionFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBoxTolerance(temp0);

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkCollisionDetectionFilter_GetBoxTolerance_122(JNIEnv* env, jobject obj)
{
  float   temp20;

  vtkCollisionDetectionFilter* op = static_cast<vtkCollisionDetectionFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBoxTolerance();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCollisionDetectionFilter_SetCellTolerance_123(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkCollisionDetectionFilter* op = static_cast<vtkCollisionDetectionFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCellTolerance(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkCollisionDetectionFilter_GetCellTolerance_124(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkCollisionDetectionFilter* op = static_cast<vtkCollisionDetectionFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellTolerance();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCollisionDetectionFilter_SetGenerateScalars_125(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkCollisionDetectionFilter* op = static_cast<vtkCollisionDetectionFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGenerateScalars(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCollisionDetectionFilter_GetGenerateScalars_126(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCollisionDetectionFilter* op = static_cast<vtkCollisionDetectionFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGenerateScalars();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCollisionDetectionFilter_GenerateScalarsOn_127(JNIEnv* env, jobject obj)
{

  vtkCollisionDetectionFilter* op = static_cast<vtkCollisionDetectionFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->GenerateScalarsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCollisionDetectionFilter_GenerateScalarsOff_128(JNIEnv* env, jobject obj)
{

  vtkCollisionDetectionFilter* op = static_cast<vtkCollisionDetectionFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->GenerateScalarsOff();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCollisionDetectionFilter_GetNumberOfContacts_129(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCollisionDetectionFilter* op = static_cast<vtkCollisionDetectionFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfContacts();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCollisionDetectionFilter_GetNumberOfBoxTests_130(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCollisionDetectionFilter* op = static_cast<vtkCollisionDetectionFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfBoxTests();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCollisionDetectionFilter_SetNumberOfCellsPerNode_131(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkCollisionDetectionFilter* op = static_cast<vtkCollisionDetectionFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfCellsPerNode(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCollisionDetectionFilter_GetNumberOfCellsPerNode_132(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCollisionDetectionFilter* op = static_cast<vtkCollisionDetectionFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfCellsPerNode();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCollisionDetectionFilter_SetOpacity_133(JNIEnv* env, jobject obj,jfloat id0)
{
  float   temp0;
  temp0 = id0;

  vtkCollisionDetectionFilter* op = static_cast<vtkCollisionDetectionFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOpacity(temp0);

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkCollisionDetectionFilter_GetOpacityMinValue_134(JNIEnv* env, jobject obj)
{
  float   temp20;

  vtkCollisionDetectionFilter* op = static_cast<vtkCollisionDetectionFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOpacityMinValue();
  return temp20;

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkCollisionDetectionFilter_GetOpacityMaxValue_135(JNIEnv* env, jobject obj)
{
  float   temp20;

  vtkCollisionDetectionFilter* op = static_cast<vtkCollisionDetectionFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOpacityMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkCollisionDetectionFilter_GetOpacity_136(JNIEnv* env, jobject obj)
{
  float   temp20;

  vtkCollisionDetectionFilter* op = static_cast<vtkCollisionDetectionFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOpacity();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCollisionDetectionFilter_GetMTime_137(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkCollisionDetectionFilter* op = static_cast<vtkCollisionDetectionFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMTime();
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkCollisionDetectionFilter_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkCollisionDetectionFilter::New());
}
