// java wrapper for vtkTransform2D object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkTransform2D.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkTransform2D_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkTransform2D",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTransform2D_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTransform2D* op = static_cast<vtkTransform2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTransform2D_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTransform2D* op = static_cast<vtkTransform2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTransform2D_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTransform2D* op = static_cast<vtkTransform2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTransform2D_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTransform2D* op = static_cast<vtkTransform2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTransform2D_Identity_14(JNIEnv* env, jobject obj)
{

  vtkTransform2D* op = static_cast<vtkTransform2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->Identity();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTransform2D_Inverse_15(JNIEnv* env, jobject obj)
{

  vtkTransform2D* op = static_cast<vtkTransform2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->Inverse();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTransform2D_Translate_16(JNIEnv* env, jobject obj,jdouble id0,jdouble id1)
{
  double   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkTransform2D* op = static_cast<vtkTransform2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->Translate(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTransform2D_Translate_17(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkTransform2D* op = static_cast<vtkTransform2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->Translate(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTransform2D_Translate_18(JNIEnv* env, jobject obj,jfloatArray id0)
{
  float temp0[2];
  env->GetFloatArrayRegion(id0, 0, 2, &temp0[0]);

  vtkTransform2D* op = static_cast<vtkTransform2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->Translate(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTransform2D_Rotate_19(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkTransform2D* op = static_cast<vtkTransform2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->Rotate(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTransform2D_Scale_110(JNIEnv* env, jobject obj,jdouble id0,jdouble id1)
{
  double   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkTransform2D* op = static_cast<vtkTransform2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->Scale(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTransform2D_Scale_111(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkTransform2D* op = static_cast<vtkTransform2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->Scale(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTransform2D_Scale_112(JNIEnv* env, jobject obj,jfloatArray id0)
{
  float temp0[2];
  env->GetFloatArrayRegion(id0, 0, 2, &temp0[0]);

  vtkTransform2D* op = static_cast<vtkTransform2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->Scale(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTransform2D_SetMatrix_113(JNIEnv* env, jobject obj,jobject id0)
{
  vtkMatrix3x3 * temp0;
  temp0 = static_cast<vtkMatrix3x3*>(vtkJavaGetPointerFromObject(env, id0));

  vtkTransform2D* op = static_cast<vtkTransform2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMatrix(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTransform2D_SetMatrix_114(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[9];
  env->GetDoubleArrayRegion(id0, 0, 9, &temp0[0]);

  vtkTransform2D* op = static_cast<vtkTransform2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMatrix(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTransform2D_GetMatrix_115(JNIEnv* env, jobject obj)
{
  vtkMatrix3x3 * temp20;

  vtkTransform2D* op = static_cast<vtkTransform2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMatrix();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTransform2D_GetMatrix_116(JNIEnv* env, jobject obj,jobject id0)
{
  vtkMatrix3x3 * temp0;
  temp0 = static_cast<vtkMatrix3x3*>(vtkJavaGetPointerFromObject(env, id0));

  vtkTransform2D* op = static_cast<vtkTransform2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetMatrix(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTransform2D_GetPosition_117(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkTransform2D* op = static_cast<vtkTransform2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetPosition(temp0);
  env->SetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTransform2D_GetPosition_118(JNIEnv* env, jobject obj,jfloatArray id0)
{
  float temp0[2];
  env->GetFloatArrayRegion(id0, 0, 2, &temp0[0]);

  vtkTransform2D* op = static_cast<vtkTransform2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetPosition(temp0);
  env->SetFloatArrayRegion(id0, 0, 2, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTransform2D_GetScale_119(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkTransform2D* op = static_cast<vtkTransform2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetScale(temp0);
  env->SetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTransform2D_GetScale_120(JNIEnv* env, jobject obj,jfloatArray id0)
{
  float temp0[2];
  env->GetFloatArrayRegion(id0, 0, 2, &temp0[0]);

  vtkTransform2D* op = static_cast<vtkTransform2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetScale(temp0);
  env->SetFloatArrayRegion(id0, 0, 2, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTransform2D_GetInverse_121(JNIEnv* env, jobject obj,jobject id0)
{
  vtkMatrix3x3 * temp0;
  temp0 = static_cast<vtkMatrix3x3*>(vtkJavaGetPointerFromObject(env, id0));

  vtkTransform2D* op = static_cast<vtkTransform2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetInverse(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTransform2D_GetTranspose_122(JNIEnv* env, jobject obj,jobject id0)
{
  vtkMatrix3x3 * temp0;
  temp0 = static_cast<vtkMatrix3x3*>(vtkJavaGetPointerFromObject(env, id0));

  vtkTransform2D* op = static_cast<vtkTransform2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetTranspose(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTransform2D_GetMTime_123(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkTransform2D* op = static_cast<vtkTransform2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMTime();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTransform2D_TransformPoints_124(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkPoints2D * temp0;
  vtkPoints2D * temp1;
  temp0 = static_cast<vtkPoints2D*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkPoints2D*>(vtkJavaGetPointerFromObject(env, id1));

  vtkTransform2D* op = static_cast<vtkTransform2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->TransformPoints(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTransform2D_InverseTransformPoints_125(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkPoints2D * temp0;
  vtkPoints2D * temp1;
  temp0 = static_cast<vtkPoints2D*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkPoints2D*>(vtkJavaGetPointerFromObject(env, id1));

  vtkTransform2D* op = static_cast<vtkTransform2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->InverseTransformPoints(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTransform2D_MultiplyPoint_126(JNIEnv* env, jobject obj,jfloatArray id0,jfloatArray id1)
{
  float temp0[3];
  float temp1[3];
  env->GetFloatArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetFloatArrayRegion(id1, 0, 3, &temp1[0]);

  vtkTransform2D* op = static_cast<vtkTransform2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->MultiplyPoint(temp0,temp1);
  env->SetFloatArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTransform2D_MultiplyPoint_127(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[3];
  double temp1[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkTransform2D* op = static_cast<vtkTransform2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->MultiplyPoint(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkTransform2D_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkTransform2D::New());
}
