// java wrapper for vtkStructuredExtent object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkStructuredExtent.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkStructuredExtent_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkStructuredExtent",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkStructuredExtent_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkStructuredExtent* op = static_cast<vtkStructuredExtent*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkStructuredExtent_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkStructuredExtent* op = static_cast<vtkStructuredExtent*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkStructuredExtent_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkStructuredExtent* op = static_cast<vtkStructuredExtent*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkStructuredExtent_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkStructuredExtent* op = static_cast<vtkStructuredExtent*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStructuredExtent_Clamp_14(JNIEnv* env, jobject obj,jintArray id0,jintArray id1)
{
  int temp0[6];
  int temp1[6];
  env->GetIntArrayRegion(id0, 0, 6, reinterpret_cast<jint*>(&temp0[0]));
  env->GetIntArrayRegion(id1, 0, 6, reinterpret_cast<jint*>(&temp1[0]));

  vtkStructuredExtent* op = static_cast<vtkStructuredExtent*>(vtkJavaGetPointerFromObject(env, obj));
  op->Clamp(temp0,temp1);
  env->SetIntArrayRegion(id0, 0, 6, reinterpret_cast<jint*>(&temp0[0]));

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkStructuredExtent_StrictlySmaller_15(JNIEnv* env, jobject obj,jintArray id0,jintArray id1)
{
  int temp0[6];
  int temp1[6];
  bool   temp20;
  env->GetIntArrayRegion(id0, 0, 6, reinterpret_cast<jint*>(&temp0[0]));
  env->GetIntArrayRegion(id1, 0, 6, reinterpret_cast<jint*>(&temp1[0]));

  vtkStructuredExtent* op = static_cast<vtkStructuredExtent*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->StrictlySmaller(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkStructuredExtent_Smaller_16(JNIEnv* env, jobject obj,jintArray id0,jintArray id1)
{
  int temp0[6];
  int temp1[6];
  bool   temp20;
  env->GetIntArrayRegion(id0, 0, 6, reinterpret_cast<jint*>(&temp0[0]));
  env->GetIntArrayRegion(id1, 0, 6, reinterpret_cast<jint*>(&temp1[0]));

  vtkStructuredExtent* op = static_cast<vtkStructuredExtent*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Smaller(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStructuredExtent_Grow_17(JNIEnv* env, jobject obj,jintArray id0,jint id1)
{
  int temp0[6];
  int   temp1;
  env->GetIntArrayRegion(id0, 0, 6, reinterpret_cast<jint*>(&temp0[0]));
  temp1 = id1;

  vtkStructuredExtent* op = static_cast<vtkStructuredExtent*>(vtkJavaGetPointerFromObject(env, obj));
  op->Grow(temp0,temp1);
  env->SetIntArrayRegion(id0, 0, 6, reinterpret_cast<jint*>(&temp0[0]));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStructuredExtent_Grow_18(JNIEnv* env, jobject obj,jintArray id0,jint id1,jintArray id2)
{
  int temp0[6];
  int   temp1;
  int temp2[6];
  env->GetIntArrayRegion(id0, 0, 6, reinterpret_cast<jint*>(&temp0[0]));
  temp1 = id1;
  env->GetIntArrayRegion(id2, 0, 6, reinterpret_cast<jint*>(&temp2[0]));

  vtkStructuredExtent* op = static_cast<vtkStructuredExtent*>(vtkJavaGetPointerFromObject(env, obj));
  op->Grow(temp0,temp1,temp2);
  env->SetIntArrayRegion(id0, 0, 6, reinterpret_cast<jint*>(&temp0[0]));
  env->SetIntArrayRegion(id2, 0, 6, reinterpret_cast<jint*>(&temp2[0]));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStructuredExtent_Transform_19(JNIEnv* env, jobject obj,jintArray id0,jintArray id1)
{
  int temp0[6];
  int temp1[6];
  env->GetIntArrayRegion(id0, 0, 6, reinterpret_cast<jint*>(&temp0[0]));
  env->GetIntArrayRegion(id1, 0, 6, reinterpret_cast<jint*>(&temp1[0]));

  vtkStructuredExtent* op = static_cast<vtkStructuredExtent*>(vtkJavaGetPointerFromObject(env, obj));
  op->Transform(temp0,temp1);
  env->SetIntArrayRegion(id0, 0, 6, reinterpret_cast<jint*>(&temp0[0]));
  env->SetIntArrayRegion(id1, 0, 6, reinterpret_cast<jint*>(&temp1[0]));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkStructuredExtent_GetDimensions_110(JNIEnv* env, jobject obj,jintArray id0,jintArray id1)
{
  int temp0[6];
  int temp1[3];
  env->GetIntArrayRegion(id0, 0, 6, reinterpret_cast<jint*>(&temp0[0]));
  env->GetIntArrayRegion(id1, 0, 3, reinterpret_cast<jint*>(&temp1[0]));

  vtkStructuredExtent* op = static_cast<vtkStructuredExtent*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetDimensions(temp0,temp1);
  env->SetIntArrayRegion(id1, 0, 3, reinterpret_cast<jint*>(&temp1[0]));

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkStructuredExtent_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkStructuredExtent::New());
}
