// java wrapper for vtkSphere object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkSphere.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkImplicitFunction_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkSphere_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkSphere",dType)) { return me; }
  if ((res= vtkImplicitFunction_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSphere_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSphere* op = static_cast<vtkSphere*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSphere_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSphere* op = static_cast<vtkSphere*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSphere_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSphere* op = static_cast<vtkSphere*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSphere_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSphere* op = static_cast<vtkSphere*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkSphere_EvaluateFunction_14(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  double   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkSphere* op = static_cast<vtkSphere*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->EvaluateFunction(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSphere_EvaluateGradient_15(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[3];
  double temp1[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkSphere* op = static_cast<vtkSphere*>(vtkJavaGetPointerFromObject(env, obj));
  op->EvaluateGradient(temp0,temp1);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSphere_SetRadius_16(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkSphere* op = static_cast<vtkSphere*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRadius(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkSphere_GetRadius_17(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkSphere* op = static_cast<vtkSphere*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRadius();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSphere_SetCenter_18(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkSphere* op = static_cast<vtkSphere*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCenter(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSphere_SetCenter_19(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkSphere* op = static_cast<vtkSphere*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCenter(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkSphere_GetCenter_110(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkSphere* op = static_cast<vtkSphere*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCenter();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkSphere_Evaluate_111(JNIEnv* env, jobject obj,jdoubleArray id0,jdouble id1,jdoubleArray id2)
{
  double temp0[3];
  double   temp1;
  double temp2[3];
  double   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  temp1 = id1;
  env->GetDoubleArrayRegion(id2, 0, 3, &temp2[0]);

  vtkSphere* op = static_cast<vtkSphere*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Evaluate(temp0,temp1,temp2);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->SetDoubleArrayRegion(id2, 0, 3, &temp2[0]);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSphere_EvaluateFunction_112(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkDataArray * temp0;
  vtkDataArray * temp1;
  temp0 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id1));

  vtkSphere* op = static_cast<vtkSphere*>(vtkJavaGetPointerFromObject(env, obj));
  op->EvaluateFunction(temp0,temp1);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkSphere_EvaluateFunction_113(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkSphere* op = static_cast<vtkSphere*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->EvaluateFunction(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkSphere_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkSphere::New());
}
