// java wrapper for vtkHigherOrderHexahedron object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkHigherOrderHexahedron.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkNonLinearCell_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkHigherOrderHexahedron_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkHigherOrderHexahedron",dType)) { return me; }
  if ((res= vtkNonLinearCell_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHigherOrderHexahedron_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkHigherOrderHexahedron* op = static_cast<vtkHigherOrderHexahedron*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHigherOrderHexahedron_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkHigherOrderHexahedron* op = static_cast<vtkHigherOrderHexahedron*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHigherOrderHexahedron_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkHigherOrderHexahedron* op = static_cast<vtkHigherOrderHexahedron*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHigherOrderHexahedron_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkHigherOrderHexahedron* op = static_cast<vtkHigherOrderHexahedron*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHigherOrderHexahedron_GetCellType_14(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkHigherOrderHexahedron* op = static_cast<vtkHigherOrderHexahedron*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellType();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHigherOrderHexahedron_GetCellDimension_15(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkHigherOrderHexahedron* op = static_cast<vtkHigherOrderHexahedron*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellDimension();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHigherOrderHexahedron_RequiresInitialization_16(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkHigherOrderHexahedron* op = static_cast<vtkHigherOrderHexahedron*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RequiresInitialization();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHigherOrderHexahedron_GetNumberOfEdges_17(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkHigherOrderHexahedron* op = static_cast<vtkHigherOrderHexahedron*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfEdges();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHigherOrderHexahedron_GetNumberOfFaces_18(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkHigherOrderHexahedron* op = static_cast<vtkHigherOrderHexahedron*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfFaces();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHigherOrderHexahedron_GetEdge_19(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkCell * temp20;
  temp0 = id0;

  vtkHigherOrderHexahedron* op = static_cast<vtkHigherOrderHexahedron*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdge(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHigherOrderHexahedron_GetFace_110(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkCell * temp20;
  temp0 = id0;

  vtkHigherOrderHexahedron* op = static_cast<vtkHigherOrderHexahedron*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFace(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHigherOrderHexahedron_Initialize_111(JNIEnv* env, jobject obj)
{

  vtkHigherOrderHexahedron* op = static_cast<vtkHigherOrderHexahedron*>(vtkJavaGetPointerFromObject(env, obj));
  op->Initialize();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHigherOrderHexahedron_CellBoundary_112(JNIEnv* env, jobject obj,jint id0,jdoubleArray id1,jobject id2)
{
  int   temp0;
  double temp1[3];
  vtkIdList * temp2;
  int   temp20;
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  temp2 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id2));

  vtkHigherOrderHexahedron* op = static_cast<vtkHigherOrderHexahedron*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CellBoundary(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHigherOrderHexahedron_Contour_113(JNIEnv* env, jobject obj,jdouble id0,jobject id1,jobject id2,jobject id3,jobject id4,jobject id5,jobject id6,jobject id7,jobject id8,jlong id9,jobject id10)
{
  double   temp0;
  vtkDataArray * temp1;
  vtkIncrementalPointLocator * temp2;
  vtkCellArray * temp3;
  vtkCellArray * temp4;
  vtkCellArray * temp5;
  vtkPointData * temp6;
  vtkPointData * temp7;
  vtkCellData * temp8;
  long long   temp9;
  vtkCellData * temp10;
  temp0 = id0;
  temp1 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkIncrementalPointLocator*>(vtkJavaGetPointerFromObject(env, id2));
  temp3 = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, id3));
  temp4 = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, id4));
  temp5 = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, id5));
  temp6 = static_cast<vtkPointData*>(vtkJavaGetPointerFromObject(env, id6));
  temp7 = static_cast<vtkPointData*>(vtkJavaGetPointerFromObject(env, id7));
  temp8 = static_cast<vtkCellData*>(vtkJavaGetPointerFromObject(env, id8));
  temp9 = id9;
  temp10 = static_cast<vtkCellData*>(vtkJavaGetPointerFromObject(env, id10));

  vtkHigherOrderHexahedron* op = static_cast<vtkHigherOrderHexahedron*>(vtkJavaGetPointerFromObject(env, obj));
  op->Contour(temp0,temp1,temp2,temp3,temp4,temp5,temp6,temp7,temp8,temp9,temp10);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHigherOrderHexahedron_Clip_114(JNIEnv* env, jobject obj,jdouble id0,jobject id1,jobject id2,jobject id3,jobject id4,jobject id5,jobject id6,jlong id7,jobject id8,jint id9)
{
  double   temp0;
  vtkDataArray * temp1;
  vtkIncrementalPointLocator * temp2;
  vtkCellArray * temp3;
  vtkPointData * temp4;
  vtkPointData * temp5;
  vtkCellData * temp6;
  long long   temp7;
  vtkCellData * temp8;
  int   temp9;
  temp0 = id0;
  temp1 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkIncrementalPointLocator*>(vtkJavaGetPointerFromObject(env, id2));
  temp3 = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, id3));
  temp4 = static_cast<vtkPointData*>(vtkJavaGetPointerFromObject(env, id4));
  temp5 = static_cast<vtkPointData*>(vtkJavaGetPointerFromObject(env, id5));
  temp6 = static_cast<vtkCellData*>(vtkJavaGetPointerFromObject(env, id6));
  temp7 = id7;
  temp8 = static_cast<vtkCellData*>(vtkJavaGetPointerFromObject(env, id8));
  temp9 = id9;

  vtkHigherOrderHexahedron* op = static_cast<vtkHigherOrderHexahedron*>(vtkJavaGetPointerFromObject(env, obj));
  op->Clip(temp0,temp1,temp2,temp3,temp4,temp5,temp6,temp7,temp8,temp9);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHigherOrderHexahedron_TriangulateLocalIds_115(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkIdList * temp1;
  int   temp20;
  temp0 = id0;
  temp1 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id1));

  vtkHigherOrderHexahedron* op = static_cast<vtkHigherOrderHexahedron*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->TriangulateLocalIds(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHigherOrderHexahedron_SetParametricCoords_116(JNIEnv* env, jobject obj)
{

  vtkHigherOrderHexahedron* op = static_cast<vtkHigherOrderHexahedron*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetParametricCoords();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHigherOrderHexahedron_GetParametricCenter_117(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  int   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkHigherOrderHexahedron* op = static_cast<vtkHigherOrderHexahedron*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetParametricCenter(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkHigherOrderHexahedron_GetParametricDistance_118(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  double   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkHigherOrderHexahedron* op = static_cast<vtkHigherOrderHexahedron*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetParametricDistance(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHigherOrderHexahedron_SetOrderFromCellData_119(JNIEnv* env, jobject obj,jobject id0,jlong id1,jlong id2)
{
  vtkCellData * temp0;
  long long   temp1;
  long long   temp2;
  temp0 = static_cast<vtkCellData*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;
  temp2 = id2;

  vtkHigherOrderHexahedron* op = static_cast<vtkHigherOrderHexahedron*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOrderFromCellData(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHigherOrderHexahedron_SetUniformOrderFromNumPoints_120(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkHigherOrderHexahedron* op = static_cast<vtkHigherOrderHexahedron*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUniformOrderFromNumPoints(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHigherOrderHexahedron_SetOrder_121(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2)
{
  int   temp0;
  int   temp1;
  int   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkHigherOrderHexahedron* op = static_cast<vtkHigherOrderHexahedron*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOrder(temp0,temp1,temp2);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHigherOrderHexahedron_GetOrder_122(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkHigherOrderHexahedron* op = static_cast<vtkHigherOrderHexahedron*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOrder(temp0);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkHigherOrderHexahedron_PointCountSupportsUniformOrder_123(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  bool   temp20;
  temp0 = id0;

  vtkHigherOrderHexahedron* op = static_cast<vtkHigherOrderHexahedron*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->PointCountSupportsUniformOrder(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHigherOrderHexahedron_PointIndexFromIJK_124(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkHigherOrderHexahedron* op = static_cast<vtkHigherOrderHexahedron*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->PointIndexFromIJK(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHigherOrderHexahedron_GetEdgeCell_125(JNIEnv* env, jobject obj)
{
  vtkHigherOrderCurve * temp20;

  vtkHigherOrderHexahedron* op = static_cast<vtkHigherOrderHexahedron*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgeCell();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHigherOrderHexahedron_GetFaceCell_126(JNIEnv* env, jobject obj)
{
  vtkHigherOrderQuadrilateral * temp20;

  vtkHigherOrderHexahedron* op = static_cast<vtkHigherOrderHexahedron*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFaceCell();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHigherOrderHexahedron_GetInterpolation_127(JNIEnv* env, jobject obj)
{
  vtkHigherOrderInterpolation * temp20;

  vtkHigherOrderHexahedron* op = static_cast<vtkHigherOrderHexahedron*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInterpolation();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHigherOrderHexahedron_NodeNumberingMappingFromVTK8To9_128(JNIEnv* env, jobject obj,jintArray id0,jlong id1)
{
  int temp0[3];
  long long   temp1;
  long long   temp20;
  env->GetIntArrayRegion(id0, 0, 3, reinterpret_cast<jint*>(&temp0[0]));
  temp1 = id1;

  vtkHigherOrderHexahedron* op = static_cast<vtkHigherOrderHexahedron*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->NodeNumberingMappingFromVTK8To9(temp0,temp1);
  return temp20;

}
