// java wrapper for vtkDataAssembly object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkDataAssembly.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkDataAssembly_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkDataAssembly",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataAssembly_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataAssembly* op = static_cast<vtkDataAssembly*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataAssembly_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataAssembly* op = static_cast<vtkDataAssembly*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataAssembly_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataAssembly* op = static_cast<vtkDataAssembly*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataAssembly_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataAssembly* op = static_cast<vtkDataAssembly*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataAssembly_Initialize_14(JNIEnv* env, jobject obj)
{

  vtkDataAssembly* op = static_cast<vtkDataAssembly*>(vtkJavaGetPointerFromObject(env, obj));
  op->Initialize();

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkDataAssembly_InitializeFromXML_15(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  bool   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataAssembly* op = static_cast<vtkDataAssembly*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->InitializeFromXML(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataAssembly_GetRootNode_16(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDataAssembly* op = static_cast<vtkDataAssembly*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRootNode();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataAssembly_SetRootNodeName_17(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataAssembly* op = static_cast<vtkDataAssembly*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRootNodeName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDataAssembly_GetRootNodeName_18(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkDataAssembly* op = static_cast<vtkDataAssembly*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRootNodeName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataAssembly_AddNode_19(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkDataAssembly* op = static_cast<vtkDataAssembly*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AddNode(temp0,temp1);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataAssembly_AddSubtree_110(JNIEnv* env, jobject obj,jint id0,jobject id1,jint id2)
{
  int   temp0;
  vtkDataAssembly * temp1;
  int   temp2;
  int   temp20;
  temp0 = id0;
  temp1 = static_cast<vtkDataAssembly*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = id2;

  vtkDataAssembly* op = static_cast<vtkDataAssembly*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AddSubtree(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkDataAssembly_RemoveNode_111(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  bool   temp20;
  temp0 = id0;

  vtkDataAssembly* op = static_cast<vtkDataAssembly*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RemoveNode(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataAssembly_SetNodeName_112(JNIEnv* env, jobject obj,jint id0, jbyteArray id1, jint len1)
{
  int   temp0;
  char * temp1;
  temp0 = id0;
  temp1 = vtkJavaUTF8ToChars(env, id1, len1);

  vtkDataAssembly* op = static_cast<vtkDataAssembly*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNodeName(temp0,temp1);
  delete[] temp1;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDataAssembly_GetNodeName_113(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkDataAssembly* op = static_cast<vtkDataAssembly*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNodeName(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDataAssembly_GetNodePath_114(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  std::string   temp20;
  temp0 = id0;

  vtkDataAssembly* op = static_cast<vtkDataAssembly*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNodePath(temp0);
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataAssembly_GetFirstNodeByPath_115(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataAssembly* op = static_cast<vtkDataAssembly*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFirstNodeByPath(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkDataAssembly_AddDataSetIndex_116(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
   unsigned int   temp1;
  bool   temp20;
  temp0 = id0;
  temp1 = id1;

  vtkDataAssembly* op = static_cast<vtkDataAssembly*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AddDataSetIndex(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkDataAssembly_AddDataSetIndexRange_117(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2)
{
  int   temp0;
   unsigned int   temp1;
  int   temp2;
  bool   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkDataAssembly* op = static_cast<vtkDataAssembly*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AddDataSetIndexRange(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkDataAssembly_RemoveDataSetIndex_118(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
   unsigned int   temp1;
  bool   temp20;
  temp0 = id0;
  temp1 = id1;

  vtkDataAssembly* op = static_cast<vtkDataAssembly*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RemoveDataSetIndex(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkDataAssembly_RemoveAllDataSetIndices_119(JNIEnv* env, jobject obj,jint id0,jboolean id1)
{
  int   temp0;
  bool   temp1;
  bool   temp20;
  temp0 = id0;
  temp1 = (id1 != 0) ? true : false;

  vtkDataAssembly* op = static_cast<vtkDataAssembly*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RemoveAllDataSetIndices(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataAssembly_FindFirstNodeWithName_120(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkDataAssembly* op = static_cast<vtkDataAssembly*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->FindFirstNodeWithName(temp0,temp1);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataAssembly_GetNumberOfChildren_121(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkDataAssembly* op = static_cast<vtkDataAssembly*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfChildren(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataAssembly_GetChild_122(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  int   temp20;
  temp0 = id0;
  temp1 = id1;

  vtkDataAssembly* op = static_cast<vtkDataAssembly*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetChild(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataAssembly_GetChildIndex_123(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  int   temp20;
  temp0 = id0;
  temp1 = id1;

  vtkDataAssembly* op = static_cast<vtkDataAssembly*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetChildIndex(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataAssembly_GetParent_124(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkDataAssembly* op = static_cast<vtkDataAssembly*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetParent(temp0);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkDataAssembly_HasAttribute_125(JNIEnv* env, jobject obj,jint id0, jbyteArray id1, jint len1)
{
  int   temp0;
  char * temp1;
  bool   temp20;
  temp0 = id0;
  temp1 = vtkJavaUTF8ToChars(env, id1, len1);

  vtkDataAssembly* op = static_cast<vtkDataAssembly*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasAttribute(temp0,temp1);
  delete[] temp1;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataAssembly_SetAttribute_126(JNIEnv* env, jobject obj,jint id0, jbyteArray id1, jint len1, jbyteArray id2, jint len2)
{
  int   temp0;
  char * temp1;
  char * temp2;
  temp0 = id0;
  temp1 = vtkJavaUTF8ToChars(env, id1, len1);
  temp2 = vtkJavaUTF8ToChars(env, id2, len2);

  vtkDataAssembly* op = static_cast<vtkDataAssembly*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAttribute(temp0,temp1,temp2);
  delete[] temp1;
  delete[] temp2;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataAssembly_SetAttribute_127(JNIEnv* env, jobject obj,jint id0, jbyteArray id1, jint len1,jint id2)
{
  int   temp0;
  char * temp1;
  int   temp2;
  temp0 = id0;
  temp1 = vtkJavaUTF8ToChars(env, id1, len1);
  temp2 = id2;

  vtkDataAssembly* op = static_cast<vtkDataAssembly*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAttribute(temp0,temp1,temp2);
  delete[] temp1;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataAssembly_SetAttribute_128(JNIEnv* env, jobject obj,jint id0, jbyteArray id1, jint len1,jlong id2)
{
  int   temp0;
  char * temp1;
  long long   temp2;
  temp0 = id0;
  temp1 = vtkJavaUTF8ToChars(env, id1, len1);
  temp2 = id2;

  vtkDataAssembly* op = static_cast<vtkDataAssembly*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAttribute(temp0,temp1,temp2);
  delete[] temp1;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDataAssembly_GetAttributeOrDefault_129(JNIEnv* env, jobject obj,jint id0, jbyteArray id1, jint len1, jbyteArray id2, jint len2)
{
  int   temp0;
  char * temp1;
  char * temp2;
  const char * temp20;
  temp0 = id0;
  temp1 = vtkJavaUTF8ToChars(env, id1, len1);
  temp2 = vtkJavaUTF8ToChars(env, id2, len2);

  vtkDataAssembly* op = static_cast<vtkDataAssembly*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAttributeOrDefault(temp0,temp1,temp2);
  delete[] temp1;
  delete[] temp2;
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataAssembly_GetAttributeOrDefault_130(JNIEnv* env, jobject obj,jint id0, jbyteArray id1, jint len1,jint id2)
{
  int   temp0;
  char * temp1;
  int   temp2;
  int   temp20;
  temp0 = id0;
  temp1 = vtkJavaUTF8ToChars(env, id1, len1);
  temp2 = id2;

  vtkDataAssembly* op = static_cast<vtkDataAssembly*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAttributeOrDefault(temp0,temp1,temp2);
  delete[] temp1;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataAssembly_GetAttributeOrDefault_131(JNIEnv* env, jobject obj,jint id0, jbyteArray id1, jint len1,jlong id2)
{
  int   temp0;
  char * temp1;
  long long   temp2;
  long long   temp20;
  temp0 = id0;
  temp1 = vtkJavaUTF8ToChars(env, id1, len1);
  temp2 = id2;

  vtkDataAssembly* op = static_cast<vtkDataAssembly*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAttributeOrDefault(temp0,temp1,temp2);
  delete[] temp1;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataAssembly_Visit_132(JNIEnv* env, jobject obj,jobject id0,jint id1)
{
  vtkDataAssemblyVisitor * temp0;
  int   temp1;
  temp0 = static_cast<vtkDataAssemblyVisitor*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkDataAssembly* op = static_cast<vtkDataAssembly*>(vtkJavaGetPointerFromObject(env, obj));
  op->Visit(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataAssembly_Visit_133(JNIEnv* env, jobject obj,jint id0,jobject id1,jint id2)
{
  int   temp0;
  vtkDataAssemblyVisitor * temp1;
  int   temp2;
  temp0 = id0;
  temp1 = static_cast<vtkDataAssemblyVisitor*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = id2;

  vtkDataAssembly* op = static_cast<vtkDataAssembly*>(vtkJavaGetPointerFromObject(env, obj));
  op->Visit(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataAssembly_DeepCopy_134(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataAssembly * temp0;
  temp0 = static_cast<vtkDataAssembly*>(vtkJavaGetPointerFromObject(env, id0));

  vtkDataAssembly* op = static_cast<vtkDataAssembly*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeepCopy(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkDataAssembly_IsNodeNameValid_135(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  bool   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataAssembly* op = static_cast<vtkDataAssembly*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsNodeNameValid(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDataAssembly_MakeValidNodeName_136(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  std::string   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataAssembly* op = static_cast<vtkDataAssembly*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->MakeValidNodeName(temp0);
  delete[] temp0;
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkDataAssembly_IsNodeNameReserved_137(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  bool   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataAssembly* op = static_cast<vtkDataAssembly*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsNodeNameReserved(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkDataAssembly_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkDataAssembly::New());
}
