// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause

#ifndef vtkRenderingAnariObjectFactory_h
#define vtkRenderingAnariObjectFactory_h

#include "vtkRenderingAnariModule.h" // For export macro
#include "vtkObjectFactory.h"

VTK_ABI_NAMESPACE_BEGIN

class VTKRENDERINGANARI_EXPORT vtkRenderingAnariObjectFactory : public vtkObjectFactory
{
public:
  static vtkRenderingAnariObjectFactory * New();
  vtkTypeMacro(vtkRenderingAnariObjectFactory, vtkObjectFactory);

  const char * GetDescription() VTK_FUTURE_CONST override { return "vtkRenderingAnari factory overrides."; }

  const char * GetVTKSourceVersion() VTK_FUTURE_CONST override;

  void PrintSelf(ostream &os, vtkIndent indent) override;

protected:
  vtkRenderingAnariObjectFactory();

private:
  vtkRenderingAnariObjectFactory(const vtkRenderingAnariObjectFactory&) = delete;
  void operator=(const vtkRenderingAnariObjectFactory&) = delete;
};

VTK_ABI_NAMESPACE_END

#endif // vtkRenderingAnariObjectFactory_h
