// python wrapper for vtkAnariActorNode
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkAnariActorNode.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkAnariActorNode(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkAnariActorNode_ClassNew(); }

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkAnariActorNode_ScalingMode_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRenderingAnari.vtkAnariActorNode.ScalingMode", // tp_name
  sizeof(PyLongObject), // tp_basicsize
  0, // tp_itemsize
  nullptr, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  nullptr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  nullptr, // tp_str
  nullptr, // tp_getattro
  nullptr, // tp_setattro
  nullptr, // tp_as_buffer
  Py_TPFLAGS_DEFAULT
#if PY_VERSION_HEX >= 0x030A0000
    | Py_TPFLAGS_DISALLOW_INSTANTIATION
#endif
  , // tp_flags
  nullptr, // tp_doc
  nullptr, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  0, // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  nullptr, // tp_getset
  &PyLong_Type, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  0, // tp_dictoffset
  nullptr, // tp_init
  nullptr, // tp_alloc
  nullptr, // tp_new
  PyObject_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

template<class T>
static PyObject *PyvtkAnariActorNode_ScalingMode_FromEnum(T val)
{
  return PyVTKEnum_New(&PyvtkAnariActorNode_ScalingMode_Type, static_cast<int>(val));
}


static PyObject *
PyvtkAnariActorNode_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkAnariActorNode::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAnariActorNode_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAnariActorNode *op = static_cast<vtkAnariActorNode *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkAnariActorNode::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAnariActorNode_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkAnariActorNode *tempr = vtkAnariActorNode::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAnariActorNode_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAnariActorNode *op = static_cast<vtkAnariActorNode *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkAnariActorNode *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkAnariActorNode::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAnariActorNode_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkAnariActorNode::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAnariActorNode_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAnariActorNode *op = static_cast<vtkAnariActorNode *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkAnariActorNode::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAnariActorNode_GetMTime(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMTime");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAnariActorNode *op = static_cast<vtkAnariActorNode *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    unsigned long tempr = (ap.IsBound() ?
      op->GetMTime() :
      op->vtkAnariActorNode::GetMTime());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAnariActorNode_ENABLE_SCALING(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "ENABLE_SCALING");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkInformationIntegerKey *tempr = vtkAnariActorNode::ENABLE_SCALING();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAnariActorNode_SetEnableScaling(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetEnableScaling");

  int temp0;
  vtkActor *temp1 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkActor"))
  {
    vtkAnariActorNode::SetEnableScaling(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAnariActorNode_GetEnableScaling(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetEnableScaling");

  vtkActor *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkActor"))
  {
    int tempr = vtkAnariActorNode::GetEnableScaling(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAnariActorNode_SCALE_ARRAY_NAME(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SCALE_ARRAY_NAME");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkInformationStringKey *tempr = vtkAnariActorNode::SCALE_ARRAY_NAME();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAnariActorNode_SetScaleArrayName(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetScaleArrayName");

  const char *temp0 = nullptr;
  vtkActor *temp1 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkActor"))
  {
    vtkAnariActorNode::SetScaleArrayName(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAnariActorNode_GetScaleArrayName(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetScaleArrayName");

  vtkActor *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkActor"))
  {
    const char *tempr = vtkAnariActorNode::GetScaleArrayName(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAnariActorNode_SCALE_FUNCTION(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SCALE_FUNCTION");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkInformationObjectBaseKey *tempr = vtkAnariActorNode::SCALE_FUNCTION();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAnariActorNode_SetScaleFunction(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetScaleFunction");

  vtkPiecewiseFunction *temp0 = nullptr;
  vtkActor *temp1 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkPiecewiseFunction") &&
      ap.GetVTKObject(temp1, "vtkActor"))
  {
    vtkAnariActorNode::SetScaleFunction(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAnariActorNode_GetScaleFunction(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetScaleFunction");

  vtkActor *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkActor"))
  {
    vtkPiecewiseFunction *tempr = vtkAnariActorNode::GetScaleFunction(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAnariActorNode_LUMINOSITY(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "LUMINOSITY");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkInformationDoubleKey *tempr = vtkAnariActorNode::LUMINOSITY();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAnariActorNode_SetLuminosity(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetLuminosity");

  double temp0;
  vtkProperty *temp1 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkProperty"))
  {
    vtkAnariActorNode::SetLuminosity(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAnariActorNode_GetLuminosity(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetLuminosity");

  vtkProperty *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkProperty"))
  {
    double tempr = vtkAnariActorNode::GetLuminosity(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAnariActorNode_ACTOR_NODE_NAME(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "ACTOR_NODE_NAME");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkInformationStringKey *tempr = vtkAnariActorNode::ACTOR_NODE_NAME();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAnariActorNode_OUTPUT_POINT_AND_CELL_ARRAYS(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "OUTPUT_POINT_AND_CELL_ARRAYS");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkInformationIntegerKey *tempr = vtkAnariActorNode::OUTPUT_POINT_AND_CELL_ARRAYS();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAnariActorNode_OUTPUT_POINT_AND_CELL_ARRAYS_DOUBLE_TO_FLOAT(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "OUTPUT_POINT_AND_CELL_ARRAYS_DOUBLE_TO_FLOAT");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkInformationIntegerKey *tempr = vtkAnariActorNode::OUTPUT_POINT_AND_CELL_ARRAYS_DOUBLE_TO_FLOAT();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAnariActorNode_SCENEGRAPH_TIME_CONSTANT_POINT_ARRAYS(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SCENEGRAPH_TIME_CONSTANT_POINT_ARRAYS");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkInformationStringVectorKey *tempr = vtkAnariActorNode::SCENEGRAPH_TIME_CONSTANT_POINT_ARRAYS();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAnariActorNode_SCENEGRAPH_TIME_CONSTANT_CELL_ARRAYS(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SCENEGRAPH_TIME_CONSTANT_CELL_ARRAYS");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkInformationStringVectorKey *tempr = vtkAnariActorNode::SCENEGRAPH_TIME_CONSTANT_CELL_ARRAYS();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkAnariActorNode_Methods[] = {
  {"IsTypeOf", PyvtkAnariActorNode_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkAnariActorNode_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkAnariActorNode_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkAnariActorNode\nC++: static vtkAnariActorNode *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkAnariActorNode_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkAnariActorNode\nC++: vtkAnariActorNode *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkAnariActorNode_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkAnariActorNode_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetMTime", PyvtkAnariActorNode_GetMTime, METH_VARARGS,
   "GetMTime(self) -> int\nC++: vtkMTimeType GetMTime() override;\n\nOverridden to take into account my renderables time, including\nmapper and data into mapper inclusive of composite input\n"},
  {"ENABLE_SCALING", PyvtkAnariActorNode_ENABLE_SCALING, METH_VARARGS,
   "ENABLE_SCALING() -> vtkInformationIntegerKey\nC++: static vtkInformationIntegerKey *ENABLE_SCALING()\n\nA key to set the ScalingMode. The default is ALL_EXACT. ALL_EXACT\nmeans use vtkActor PointSize/LineWidth for all radii.\nALL_APPROXIMATE sets all radii to approximate GL's pixel sizes\nvia a function of PointSize/LineWidth and object bounding box.\nEACH_MAPPED means map every value from SCALE_ARRAY_NAME through\nthe SCALE_FUNCTION lookup table to set each radius independently.\nEACH_EXACT means use the SCALE_ARRAY_NAME to set each radius\ndirectly.\n"},
  {"SetEnableScaling", PyvtkAnariActorNode_SetEnableScaling, METH_VARARGS,
   "SetEnableScaling(value:int, __b:vtkActor) -> None\nC++: static void SetEnableScaling(int value, vtkActor *)\n\nConvenience method to set enabled scaling on my renderable.\n"},
  {"GetEnableScaling", PyvtkAnariActorNode_GetEnableScaling, METH_VARARGS,
   "GetEnableScaling(__a:vtkActor) -> int\nC++: static int GetEnableScaling(vtkActor *)\n\nConvenience method to set enabled scaling on my renderable.\n"},
  {"SCALE_ARRAY_NAME", PyvtkAnariActorNode_SCALE_ARRAY_NAME, METH_VARARGS,
   "SCALE_ARRAY_NAME() -> vtkInformationStringKey\nC++: static vtkInformationStringKey *SCALE_ARRAY_NAME()\n\nName of a point aligned, single component wide, double valued\narray that, when added to the mapper, will be used to scale each\nelement in the sphere and cylinder representations individually.\nWhen not supplied the radius is constant across all elements and\nis a function of the Mapper's PointSize and LineWidth.\n"},
  {"SetScaleArrayName", PyvtkAnariActorNode_SetScaleArrayName, METH_VARARGS,
   "SetScaleArrayName(__a:str, __b:vtkActor) -> None\nC++: static void SetScaleArrayName(const char *, vtkActor *)\n\nConvenience method to get/set a scale array on my renderable.\n"},
  {"GetScaleArrayName", PyvtkAnariActorNode_GetScaleArrayName, METH_VARARGS,
   "GetScaleArrayName(__a:vtkActor) -> str\nC++: static const char *GetScaleArrayName(vtkActor *)\n\nConvenience method to get/set a scale array on my renderable.\n"},
  {"SCALE_FUNCTION", PyvtkAnariActorNode_SCALE_FUNCTION, METH_VARARGS,
   "SCALE_FUNCTION() -> vtkInformationObjectBaseKey\nC++: static vtkInformationObjectBaseKey *SCALE_FUNCTION()\n\nA piecewise function for values from the scale array that alters\nthe resulting radii arbitrarily\n"},
  {"SetScaleFunction", PyvtkAnariActorNode_SetScaleFunction, METH_VARARGS,
   "SetScaleFunction(__a:vtkPiecewiseFunction, __b:vtkActor) -> None\nC++: static void SetScaleFunction(vtkPiecewiseFunction *,\n    vtkActor *)\n\nConvenience method to set a scale function on my renderable.\n"},
  {"GetScaleFunction", PyvtkAnariActorNode_GetScaleFunction, METH_VARARGS,
   "GetScaleFunction(__a:vtkActor) -> vtkPiecewiseFunction\nC++: static vtkPiecewiseFunction *GetScaleFunction(vtkActor *)\n\nConvenience method to set a scale function on my renderable.\n"},
  {"LUMINOSITY", PyvtkAnariActorNode_LUMINOSITY, METH_VARARGS,
   "LUMINOSITY() -> vtkInformationDoubleKey\nC++: static vtkInformationDoubleKey *LUMINOSITY()\n\nIndicates that the actor acts as a light emitting object.\n"},
  {"SetLuminosity", PyvtkAnariActorNode_SetLuminosity, METH_VARARGS,
   "SetLuminosity(value:float, __b:vtkProperty) -> None\nC++: static void SetLuminosity(double value, vtkProperty *)\n\nConvenience method to set luminosity on my renderable.\n"},
  {"GetLuminosity", PyvtkAnariActorNode_GetLuminosity, METH_VARARGS,
   "GetLuminosity(__a:vtkProperty) -> float\nC++: static double GetLuminosity(vtkProperty *)\n\nConvenience method to set luminosity on my renderable.\n"},
  {"ACTOR_NODE_NAME", PyvtkAnariActorNode_ACTOR_NODE_NAME, METH_VARARGS,
   "ACTOR_NODE_NAME() -> vtkInformationStringKey\nC++: static vtkInformationStringKey *ACTOR_NODE_NAME()\n\nName of the node, used for debugging or representation metadata\nin case an ANARI backend is chosen which - instead of rendering\nto a screen - outputs to intermediate authoring stages (such as\nfiles or network resources).\n"},
  {"OUTPUT_POINT_AND_CELL_ARRAYS", PyvtkAnariActorNode_OUTPUT_POINT_AND_CELL_ARRAYS, METH_VARARGS,
   "OUTPUT_POINT_AND_CELL_ARRAYS() -> vtkInformationIntegerKey\nC++: static vtkInformationIntegerKey *OUTPUT_POINT_AND_CELL_ARRAYS(\n    )\n\nIndicates that the actor includes point and cell attribute arrays\nwithin its rendering output. This allows ANARI backends that\ntransfer rendering data to intermediate authoring stages to get\naccess to additional data than what is typically used by VTK's\nrendering itself.\n"},
  {"OUTPUT_POINT_AND_CELL_ARRAYS_DOUBLE_TO_FLOAT", PyvtkAnariActorNode_OUTPUT_POINT_AND_CELL_ARRAYS_DOUBLE_TO_FLOAT, METH_VARARGS,
   "OUTPUT_POINT_AND_CELL_ARRAYS_DOUBLE_TO_FLOAT()\n    -> vtkInformationIntegerKey\nC++: static vtkInformationIntegerKey *OUTPUT_POINT_AND_CELL_ARRAYS_DOUBLE_TO_FLOAT(\n    )\n\nWhether the output enabled with OUTPUT_POINT_AND_CELL_ARRAYS\nshould convert double arrays to float.\n"},
  {"SCENEGRAPH_TIME_CONSTANT_POINT_ARRAYS", PyvtkAnariActorNode_SCENEGRAPH_TIME_CONSTANT_POINT_ARRAYS, METH_VARARGS,
   "SCENEGRAPH_TIME_CONSTANT_POINT_ARRAYS()\n    -> vtkInformationStringVectorKey\nC++: static vtkInformationStringVectorKey *SCENEGRAPH_TIME_CONSTANT_POINT_ARRAYS(\n    )\n\nArray metadata for intermediate authoring steps, which denotes\nthe arrays which are not written out separately for every\ntimestep, but instead contain only a single representation for\nall timesteps.\n"},
  {"SCENEGRAPH_TIME_CONSTANT_CELL_ARRAYS", PyvtkAnariActorNode_SCENEGRAPH_TIME_CONSTANT_CELL_ARRAYS, METH_VARARGS,
   "SCENEGRAPH_TIME_CONSTANT_CELL_ARRAYS()\n    -> vtkInformationStringVectorKey\nC++: static vtkInformationStringVectorKey *SCENEGRAPH_TIME_CONSTANT_CELL_ARRAYS(\n    )\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkAnariActorNode_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("m_time"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkAnariActorNode_GetMTime(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetMTime\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkAnariActorNode_Doc =
  "vtkAnariActorNode - links vtkActor and vtkMapper to ANARI\n\n"
  "Superclass: vtkActorNode\n\n"
  "Translates vtkActor/Mapper state into ANARI rendering calls\n\n"
  "@par Thanks: Kevin Griffin kgriffin\n\n"
  "vidia.com for creating and contributing the class and NVIDIA for\n"
  "supporting this work.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkAnariActorNode_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRenderingAnari.vtkAnariActorNode", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkAnariActorNode_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkAnariActorNode_StaticNew()
{
  return vtkAnariActorNode::New();
}

PyObject *PyvtkAnariActorNode_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkAnariActorNode_Type, PyvtkAnariActorNode_Methods,
    "vtkAnariActorNode",
 &PyvtkAnariActorNode_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkActorNode");

  PyObject *d = pytype->tp_dict;
  PyObject *o;

  PyType_Ready(&PyvtkAnariActorNode_ScalingMode_Type);
  // members of vtkAnariActorNode::ScalingMode
  {
    PyObject *enumval;
    PyObject *enumdict = PyDict_New();
    PyvtkAnariActorNode_ScalingMode_Type.tp_dict = enumdict;

    typedef vtkAnariActorNode::ScalingMode cxx_enum_type;
    static const struct {
      const char *name; cxx_enum_type value;
    } constants[4] = {
      { "ALL_EXACT", cxx_enum_type::ALL_EXACT },
      { "ALL_APPROXIMATE", cxx_enum_type::ALL_APPROXIMATE },
      { "EACH_MAPPED", cxx_enum_type::EACH_MAPPED },
      { "EACH_EXACT", cxx_enum_type::EACH_EXACT },
    };

    for (int c = 0; c < 4; c++)
    {
      enumval = PyvtkAnariActorNode_ScalingMode_FromEnum(constants[c].value);
      if (enumval)
      {
        PyDict_SetItemString(enumdict, constants[c].name, enumval);
        Py_DECREF(enumval);
      }
    }
  }

  PyVTKEnum_Add(&PyvtkAnariActorNode_ScalingMode_Type, "vtkAnariActorNode.ScalingMode");

  o = (PyObject *)&PyvtkAnariActorNode_ScalingMode_Type;
  if (PyDict_SetItemString(d, "ScalingMode", o) != 0)
  {
    Py_DECREF(o);
  }

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkAnariActorNode_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkAnariActorNode(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkAnariActorNode_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkAnariActorNode", o) != 0)
  {
    Py_DECREF(o);
  }

}

