// python wrapper for vtkBoostRandomSparseArraySource
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkArrayExtents.h"
#include "vtkBoostRandomSparseArraySource.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkBoostRandomSparseArraySource(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkBoostRandomSparseArraySource_ClassNew(); }


static PyObject *
PyvtkBoostRandomSparseArraySource_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkBoostRandomSparseArraySource::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkBoostRandomSparseArraySource_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostRandomSparseArraySource *op = static_cast<vtkBoostRandomSparseArraySource *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkBoostRandomSparseArraySource::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkBoostRandomSparseArraySource_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkBoostRandomSparseArraySource *tempr = vtkBoostRandomSparseArraySource::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkBoostRandomSparseArraySource_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostRandomSparseArraySource *op = static_cast<vtkBoostRandomSparseArraySource *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkBoostRandomSparseArraySource *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkBoostRandomSparseArraySource::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkBoostRandomSparseArraySource_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkBoostRandomSparseArraySource::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkBoostRandomSparseArraySource_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostRandomSparseArraySource *op = static_cast<vtkBoostRandomSparseArraySource *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkBoostRandomSparseArraySource::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkBoostRandomSparseArraySource_SetExtents(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetExtents");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostRandomSparseArraySource *op = static_cast<vtkBoostRandomSparseArraySource *>(vp);

  vtkArrayExtents *temp0 = nullptr;
  PyObject *pobj0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetSpecialObject(temp0, pobj0, "vtkArrayExtents"))
  {
    if (ap.IsBound())
    {
      op->SetExtents(*temp0);
    }
    else
    {
      op->vtkBoostRandomSparseArraySource::SetExtents(*temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  Py_XDECREF(pobj0);

  return result;
}


static PyObject *
PyvtkBoostRandomSparseArraySource_GetExtents(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetExtents");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostRandomSparseArraySource *op = static_cast<vtkBoostRandomSparseArraySource *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkArrayExtents tempr = (ap.IsBound() ?
      op->GetExtents() :
      op->vtkBoostRandomSparseArraySource::GetExtents());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildSpecialObject(&tempr, "vtkArrayExtents");
    }
  }

  return result;
}


static PyObject *
PyvtkBoostRandomSparseArraySource_GetElementProbabilitySeed(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetElementProbabilitySeed");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostRandomSparseArraySource *op = static_cast<vtkBoostRandomSparseArraySource *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    unsigned int tempr = (ap.IsBound() ?
      op->GetElementProbabilitySeed() :
      op->vtkBoostRandomSparseArraySource::GetElementProbabilitySeed());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkBoostRandomSparseArraySource_SetElementProbabilitySeed(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetElementProbabilitySeed");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostRandomSparseArraySource *op = static_cast<vtkBoostRandomSparseArraySource *>(vp);

  unsigned int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetElementProbabilitySeed(temp0);
    }
    else
    {
      op->vtkBoostRandomSparseArraySource::SetElementProbabilitySeed(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkBoostRandomSparseArraySource_GetElementProbability(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetElementProbability");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostRandomSparseArraySource *op = static_cast<vtkBoostRandomSparseArraySource *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetElementProbability() :
      op->vtkBoostRandomSparseArraySource::GetElementProbability());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkBoostRandomSparseArraySource_SetElementProbability(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetElementProbability");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostRandomSparseArraySource *op = static_cast<vtkBoostRandomSparseArraySource *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetElementProbability(temp0);
    }
    else
    {
      op->vtkBoostRandomSparseArraySource::SetElementProbability(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkBoostRandomSparseArraySource_GetElementValueSeed(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetElementValueSeed");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostRandomSparseArraySource *op = static_cast<vtkBoostRandomSparseArraySource *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    unsigned int tempr = (ap.IsBound() ?
      op->GetElementValueSeed() :
      op->vtkBoostRandomSparseArraySource::GetElementValueSeed());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkBoostRandomSparseArraySource_SetElementValueSeed(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetElementValueSeed");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostRandomSparseArraySource *op = static_cast<vtkBoostRandomSparseArraySource *>(vp);

  unsigned int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetElementValueSeed(temp0);
    }
    else
    {
      op->vtkBoostRandomSparseArraySource::SetElementValueSeed(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkBoostRandomSparseArraySource_GetMinValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMinValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostRandomSparseArraySource *op = static_cast<vtkBoostRandomSparseArraySource *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetMinValue() :
      op->vtkBoostRandomSparseArraySource::GetMinValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkBoostRandomSparseArraySource_SetMinValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMinValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostRandomSparseArraySource *op = static_cast<vtkBoostRandomSparseArraySource *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetMinValue(temp0);
    }
    else
    {
      op->vtkBoostRandomSparseArraySource::SetMinValue(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkBoostRandomSparseArraySource_GetMaxValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMaxValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostRandomSparseArraySource *op = static_cast<vtkBoostRandomSparseArraySource *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetMaxValue() :
      op->vtkBoostRandomSparseArraySource::GetMaxValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkBoostRandomSparseArraySource_SetMaxValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMaxValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostRandomSparseArraySource *op = static_cast<vtkBoostRandomSparseArraySource *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetMaxValue(temp0);
    }
    else
    {
      op->vtkBoostRandomSparseArraySource::SetMaxValue(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkBoostRandomSparseArraySource_Methods[] = {
  {"IsTypeOf", PyvtkBoostRandomSparseArraySource_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkBoostRandomSparseArraySource_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkBoostRandomSparseArraySource_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkBoostRandomSparseArraySource\nC++: static vtkBoostRandomSparseArraySource *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkBoostRandomSparseArraySource_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkBoostRandomSparseArraySource\nC++: vtkBoostRandomSparseArraySource *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkBoostRandomSparseArraySource_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkBoostRandomSparseArraySource_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetExtents", PyvtkBoostRandomSparseArraySource_SetExtents, METH_VARARGS,
   "SetExtents(self, __a:vtkArrayExtents) -> None\nC++: void SetExtents(const vtkArrayExtents &)\n\nSets the extents (dimensionality and size) of the output array\n"},
  {"GetExtents", PyvtkBoostRandomSparseArraySource_GetExtents, METH_VARARGS,
   "GetExtents(self) -> vtkArrayExtents\nC++: vtkArrayExtents GetExtents()\n\nReturns the extents (dimensionality and size) of the output array\n"},
  {"GetElementProbabilitySeed", PyvtkBoostRandomSparseArraySource_GetElementProbabilitySeed, METH_VARARGS,
   "GetElementProbabilitySeed(self) -> int\nC++: virtual vtkTypeUInt32 GetElementProbabilitySeed()\n\nStores a random-number-seed for determining which elements within\nthe output matrix will have non-zero values\n"},
  {"SetElementProbabilitySeed", PyvtkBoostRandomSparseArraySource_SetElementProbabilitySeed, METH_VARARGS,
   "SetElementProbabilitySeed(self, _arg:int) -> None\nC++: virtual void SetElementProbabilitySeed(vtkTypeUInt32 _arg)\n\n"},
  {"GetElementProbability", PyvtkBoostRandomSparseArraySource_GetElementProbability, METH_VARARGS,
   "GetElementProbability(self) -> float\nC++: virtual double GetElementProbability()\n\nStores the probability (in the range [0, 1]) that an element\nwithin the output matrix will have a non-zero value\n"},
  {"SetElementProbability", PyvtkBoostRandomSparseArraySource_SetElementProbability, METH_VARARGS,
   "SetElementProbability(self, _arg:float) -> None\nC++: virtual void SetElementProbability(double _arg)\n\n"},
  {"GetElementValueSeed", PyvtkBoostRandomSparseArraySource_GetElementValueSeed, METH_VARARGS,
   "GetElementValueSeed(self) -> int\nC++: virtual vtkTypeUInt32 GetElementValueSeed()\n\nStores a random-number-seed for computing random element values\n"},
  {"SetElementValueSeed", PyvtkBoostRandomSparseArraySource_SetElementValueSeed, METH_VARARGS,
   "SetElementValueSeed(self, _arg:int) -> None\nC++: virtual void SetElementValueSeed(vtkTypeUInt32 _arg)\n\n"},
  {"GetMinValue", PyvtkBoostRandomSparseArraySource_GetMinValue, METH_VARARGS,
   "GetMinValue(self) -> float\nC++: virtual double GetMinValue()\n\nStores the minimum value of any element\n"},
  {"SetMinValue", PyvtkBoostRandomSparseArraySource_SetMinValue, METH_VARARGS,
   "SetMinValue(self, _arg:float) -> None\nC++: virtual void SetMinValue(double _arg)\n\n"},
  {"GetMaxValue", PyvtkBoostRandomSparseArraySource_GetMaxValue, METH_VARARGS,
   "GetMaxValue(self) -> float\nC++: virtual double GetMaxValue()\n\nStores the maximum value of any element\n"},
  {"SetMaxValue", PyvtkBoostRandomSparseArraySource_SetMaxValue, METH_VARARGS,
   "SetMaxValue(self, _arg:float) -> None\nC++: virtual void SetMaxValue(double _arg)\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkBoostRandomSparseArraySource_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("extents"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkBoostRandomSparseArraySource_SetExtents(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkBoostRandomSparseArraySource_SetExtents(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetExtents\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("element_probability_seed"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkBoostRandomSparseArraySource_GetElementProbabilitySeed(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkBoostRandomSparseArraySource_SetElementProbabilitySeed(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkBoostRandomSparseArraySource_SetElementProbabilitySeed(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetElementProbabilitySeed/SetElementProbabilitySeed\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("element_probability"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkBoostRandomSparseArraySource_GetElementProbability(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkBoostRandomSparseArraySource_SetElementProbability(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkBoostRandomSparseArraySource_SetElementProbability(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetElementProbability/SetElementProbability\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("element_value_seed"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkBoostRandomSparseArraySource_GetElementValueSeed(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkBoostRandomSparseArraySource_SetElementValueSeed(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkBoostRandomSparseArraySource_SetElementValueSeed(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetElementValueSeed/SetElementValueSeed\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("min_value"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkBoostRandomSparseArraySource_GetMinValue(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkBoostRandomSparseArraySource_SetMinValue(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkBoostRandomSparseArraySource_SetMinValue(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetMinValue/SetMinValue\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("max_value"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkBoostRandomSparseArraySource_GetMaxValue(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkBoostRandomSparseArraySource_SetMaxValue(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkBoostRandomSparseArraySource_SetMaxValue(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetMaxValue/SetMaxValue\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("extents"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkBoostRandomSparseArraySource_GetExtents(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetExtents\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkBoostRandomSparseArraySource_Doc =
  "vtkBoostRandomSparseArraySource - generates a sparse N-way array\ncontaining random values.\n\n"
  "Superclass: vtkArrayDataAlgorithm\n\n"
  "@par Thanks: Developed by Timothy M. Shead (tshead@sandia.gov) at\n"
  "Sandia National Laboratories.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkBoostRandomSparseArraySource_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkInfovisBoostGraphAlgorithms.vtkBoostRandomSparseArraySource", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkBoostRandomSparseArraySource_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkBoostRandomSparseArraySource_StaticNew()
{
  return vtkBoostRandomSparseArraySource::New();
}

PyObject *PyvtkBoostRandomSparseArraySource_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkBoostRandomSparseArraySource_Type, PyvtkBoostRandomSparseArraySource_Methods,
    "vtkBoostRandomSparseArraySource",
 &PyvtkBoostRandomSparseArraySource_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkArrayDataAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkBoostRandomSparseArraySource_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkBoostRandomSparseArraySource(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkBoostRandomSparseArraySource_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkBoostRandomSparseArraySource", o) != 0)
  {
    Py_DECREF(o);
  }

}

