// python wrapper for vtkGeoJSONReader
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkGeoJSONReader.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkGeoJSONReader(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkGeoJSONReader_ClassNew(); }


static PyObject *
PyvtkGeoJSONReader_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkGeoJSONReader::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGeoJSONReader_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeoJSONReader *op = static_cast<vtkGeoJSONReader *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkGeoJSONReader::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGeoJSONReader_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkGeoJSONReader *tempr = vtkGeoJSONReader::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGeoJSONReader_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeoJSONReader *op = static_cast<vtkGeoJSONReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkGeoJSONReader *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkGeoJSONReader::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGeoJSONReader_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkGeoJSONReader::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGeoJSONReader_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeoJSONReader *op = static_cast<vtkGeoJSONReader *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkGeoJSONReader::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGeoJSONReader_SetFileName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFileName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeoJSONReader *op = static_cast<vtkGeoJSONReader *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetFilePath(temp0))
  {
    if (ap.IsBound())
    {
      op->SetFileName(temp0);
    }
    else
    {
      op->vtkGeoJSONReader::SetFileName(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeoJSONReader_GetFileName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFileName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeoJSONReader *op = static_cast<vtkGeoJSONReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetFileName() :
      op->vtkGeoJSONReader::GetFileName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGeoJSONReader_SetStringInput(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetStringInput");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeoJSONReader *op = static_cast<vtkGeoJSONReader *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetStringInput(temp0);
    }
    else
    {
      op->vtkGeoJSONReader::SetStringInput(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeoJSONReader_GetStringInput(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetStringInput");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeoJSONReader *op = static_cast<vtkGeoJSONReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetStringInput() :
      op->vtkGeoJSONReader::GetStringInput());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGeoJSONReader_SetStringInputMode(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetStringInputMode");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeoJSONReader *op = static_cast<vtkGeoJSONReader *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetStringInputMode(temp0);
    }
    else
    {
      op->vtkGeoJSONReader::SetStringInputMode(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeoJSONReader_GetStringInputMode(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetStringInputMode");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeoJSONReader *op = static_cast<vtkGeoJSONReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetStringInputMode() :
      op->vtkGeoJSONReader::GetStringInputMode());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGeoJSONReader_StringInputModeOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "StringInputModeOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeoJSONReader *op = static_cast<vtkGeoJSONReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->StringInputModeOn();
    }
    else
    {
      op->vtkGeoJSONReader::StringInputModeOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeoJSONReader_StringInputModeOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "StringInputModeOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeoJSONReader *op = static_cast<vtkGeoJSONReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->StringInputModeOff();
    }
    else
    {
      op->vtkGeoJSONReader::StringInputModeOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeoJSONReader_SetTriangulatePolygons(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTriangulatePolygons");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeoJSONReader *op = static_cast<vtkGeoJSONReader *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTriangulatePolygons(temp0);
    }
    else
    {
      op->vtkGeoJSONReader::SetTriangulatePolygons(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeoJSONReader_GetTriangulatePolygons(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTriangulatePolygons");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeoJSONReader *op = static_cast<vtkGeoJSONReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetTriangulatePolygons() :
      op->vtkGeoJSONReader::GetTriangulatePolygons());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGeoJSONReader_TriangulatePolygonsOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "TriangulatePolygonsOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeoJSONReader *op = static_cast<vtkGeoJSONReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->TriangulatePolygonsOn();
    }
    else
    {
      op->vtkGeoJSONReader::TriangulatePolygonsOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeoJSONReader_TriangulatePolygonsOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "TriangulatePolygonsOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeoJSONReader *op = static_cast<vtkGeoJSONReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->TriangulatePolygonsOff();
    }
    else
    {
      op->vtkGeoJSONReader::TriangulatePolygonsOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeoJSONReader_SetOutlinePolygons(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOutlinePolygons");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeoJSONReader *op = static_cast<vtkGeoJSONReader *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetOutlinePolygons(temp0);
    }
    else
    {
      op->vtkGeoJSONReader::SetOutlinePolygons(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeoJSONReader_GetOutlinePolygons(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetOutlinePolygons");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeoJSONReader *op = static_cast<vtkGeoJSONReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetOutlinePolygons() :
      op->vtkGeoJSONReader::GetOutlinePolygons());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGeoJSONReader_OutlinePolygonsOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "OutlinePolygonsOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeoJSONReader *op = static_cast<vtkGeoJSONReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->OutlinePolygonsOn();
    }
    else
    {
      op->vtkGeoJSONReader::OutlinePolygonsOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeoJSONReader_OutlinePolygonsOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "OutlinePolygonsOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeoJSONReader *op = static_cast<vtkGeoJSONReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->OutlinePolygonsOff();
    }
    else
    {
      op->vtkGeoJSONReader::OutlinePolygonsOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeoJSONReader_SetSerializedPropertiesArrayName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSerializedPropertiesArrayName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeoJSONReader *op = static_cast<vtkGeoJSONReader *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSerializedPropertiesArrayName(temp0);
    }
    else
    {
      op->vtkGeoJSONReader::SetSerializedPropertiesArrayName(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGeoJSONReader_GetSerializedPropertiesArrayName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSerializedPropertiesArrayName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeoJSONReader *op = static_cast<vtkGeoJSONReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetSerializedPropertiesArrayName() :
      op->vtkGeoJSONReader::GetSerializedPropertiesArrayName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGeoJSONReader_AddFeatureProperty(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddFeatureProperty");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGeoJSONReader *op = static_cast<vtkGeoJSONReader *>(vp);

  const char *temp0 = nullptr;
  vtkVariant *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetSpecialObject(temp1, "vtkVariant"))
  {
    if (ap.IsBound())
    {
      op->AddFeatureProperty(temp0, *temp1);
    }
    else
    {
      op->vtkGeoJSONReader::AddFeatureProperty(temp0, *temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkGeoJSONReader_Methods[] = {
  {"IsTypeOf", PyvtkGeoJSONReader_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkGeoJSONReader_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkGeoJSONReader_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkGeoJSONReader\nC++: static vtkGeoJSONReader *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkGeoJSONReader_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkGeoJSONReader\nC++: vtkGeoJSONReader *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkGeoJSONReader_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkGeoJSONReader_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetFileName", PyvtkGeoJSONReader_SetFileName, METH_VARARGS,
   "SetFileName(self, _arg:str) -> None\nC++: virtual void SetFileName(const char *_arg)\n\nAccessor for name of the file that will be opened on WriteData\n"},
  {"GetFileName", PyvtkGeoJSONReader_GetFileName, METH_VARARGS,
   "GetFileName(self) -> str\nC++: virtual char *GetFileName()\n\n"},
  {"SetStringInput", PyvtkGeoJSONReader_SetStringInput, METH_VARARGS,
   "SetStringInput(self, _arg:str) -> None\nC++: virtual void SetStringInput(const char *_arg)\n\nString used as data input (instead of file) when StringInputMode\nis enabled\n"},
  {"GetStringInput", PyvtkGeoJSONReader_GetStringInput, METH_VARARGS,
   "GetStringInput(self) -> str\nC++: virtual char *GetStringInput()\n\n"},
  {"SetStringInputMode", PyvtkGeoJSONReader_SetStringInputMode, METH_VARARGS,
   "SetStringInputMode(self, _arg:bool) -> None\nC++: virtual void SetStringInputMode(bool _arg)\n\nSet/get whether to use StringInput instead of reading input from\nfile The default is off\n"},
  {"GetStringInputMode", PyvtkGeoJSONReader_GetStringInputMode, METH_VARARGS,
   "GetStringInputMode(self) -> bool\nC++: virtual bool GetStringInputMode()\n\n"},
  {"StringInputModeOn", PyvtkGeoJSONReader_StringInputModeOn, METH_VARARGS,
   "StringInputModeOn(self) -> None\nC++: virtual void StringInputModeOn()\n\n"},
  {"StringInputModeOff", PyvtkGeoJSONReader_StringInputModeOff, METH_VARARGS,
   "StringInputModeOff(self) -> None\nC++: virtual void StringInputModeOff()\n\n"},
  {"SetTriangulatePolygons", PyvtkGeoJSONReader_SetTriangulatePolygons, METH_VARARGS,
   "SetTriangulatePolygons(self, _arg:bool) -> None\nC++: virtual void SetTriangulatePolygons(bool _arg)\n\nSet/get whether to convert all output polygons to triangles. Note\nthat if OutinePolygons mode is on, then no output polygons are\ngenerated, and in that case, this option is not relevant. The\ndefault is off.\n"},
  {"GetTriangulatePolygons", PyvtkGeoJSONReader_GetTriangulatePolygons, METH_VARARGS,
   "GetTriangulatePolygons(self) -> bool\nC++: virtual bool GetTriangulatePolygons()\n\n"},
  {"TriangulatePolygonsOn", PyvtkGeoJSONReader_TriangulatePolygonsOn, METH_VARARGS,
   "TriangulatePolygonsOn(self) -> None\nC++: virtual void TriangulatePolygonsOn()\n\n"},
  {"TriangulatePolygonsOff", PyvtkGeoJSONReader_TriangulatePolygonsOff, METH_VARARGS,
   "TriangulatePolygonsOff(self) -> None\nC++: virtual void TriangulatePolygonsOff()\n\n"},
  {"SetOutlinePolygons", PyvtkGeoJSONReader_SetOutlinePolygons, METH_VARARGS,
   "SetOutlinePolygons(self, _arg:bool) -> None\nC++: virtual void SetOutlinePolygons(bool _arg)\n\nSet/get option to generate the border outlining each polygon, so\nthat the output cells for polygons are vtkPolyLine instances. The\ndefault is off.\n"},
  {"GetOutlinePolygons", PyvtkGeoJSONReader_GetOutlinePolygons, METH_VARARGS,
   "GetOutlinePolygons(self) -> bool\nC++: virtual bool GetOutlinePolygons()\n\n"},
  {"OutlinePolygonsOn", PyvtkGeoJSONReader_OutlinePolygonsOn, METH_VARARGS,
   "OutlinePolygonsOn(self) -> None\nC++: virtual void OutlinePolygonsOn()\n\n"},
  {"OutlinePolygonsOff", PyvtkGeoJSONReader_OutlinePolygonsOff, METH_VARARGS,
   "OutlinePolygonsOff(self) -> None\nC++: virtual void OutlinePolygonsOff()\n\n"},
  {"SetSerializedPropertiesArrayName", PyvtkGeoJSONReader_SetSerializedPropertiesArrayName, METH_VARARGS,
   "SetSerializedPropertiesArrayName(self, _arg:str) -> None\nC++: virtual void SetSerializedPropertiesArrayName(\n    const char *_arg)\n\nSet/get name of data array for serialized GeoJSON \"properties\"\nnode. If specified, data will be stored as\nvtkCellData/vtkStringArray.\n"},
  {"GetSerializedPropertiesArrayName", PyvtkGeoJSONReader_GetSerializedPropertiesArrayName, METH_VARARGS,
   "GetSerializedPropertiesArrayName(self) -> str\nC++: virtual char *GetSerializedPropertiesArrayName()\n\n"},
  {"AddFeatureProperty", PyvtkGeoJSONReader_AddFeatureProperty, METH_VARARGS,
   "AddFeatureProperty(self, name:str, typeAndDefaultValue:vtkVariant)\n     -> None\nC++: void AddFeatureProperty(const char *name,\n    vtkVariant &typeAndDefaultValue)\n\nSpecify feature property to read in with geometry objects Note\nthat defaultValue specifies both type & value\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkGeoJSONReader_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("file_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGeoJSONReader_GetFileName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeoJSONReader_SetFileName(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeoJSONReader_SetFileName(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetFileName/SetFileName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("string_input"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGeoJSONReader_GetStringInput(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeoJSONReader_SetStringInput(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeoJSONReader_SetStringInput(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetStringInput/SetStringInput\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("string_input_mode"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGeoJSONReader_GetStringInputMode(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeoJSONReader_SetStringInputMode(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeoJSONReader_SetStringInputMode(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetStringInputMode/SetStringInputMode\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("triangulate_polygons"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGeoJSONReader_GetTriangulatePolygons(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeoJSONReader_SetTriangulatePolygons(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeoJSONReader_SetTriangulatePolygons(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetTriangulatePolygons/SetTriangulatePolygons\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("outline_polygons"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGeoJSONReader_GetOutlinePolygons(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeoJSONReader_SetOutlinePolygons(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeoJSONReader_SetOutlinePolygons(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetOutlinePolygons/SetOutlinePolygons\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("serialized_properties_array_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGeoJSONReader_GetSerializedPropertiesArrayName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGeoJSONReader_SetSerializedPropertiesArrayName(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGeoJSONReader_SetSerializedPropertiesArrayName(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetSerializedPropertiesArrayName/SetSerializedPropertiesArrayName\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkGeoJSONReader_Doc =
  "vtkGeoJSONReader - Convert Geo JSON format to vtkPolyData\n\n"
  "Superclass: vtkPolyDataAlgorithm\n\n"
  "Outputs a vtkPolyData from the input Geo JSON Data\n"
  "(http://www.geojson.org)\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkGeoJSONReader_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkIOGeoJSON.vtkGeoJSONReader", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkGeoJSONReader_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkGeoJSONReader_StaticNew()
{
  return vtkGeoJSONReader::New();
}

PyObject *PyvtkGeoJSONReader_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkGeoJSONReader_Type, PyvtkGeoJSONReader_Methods,
    "vtkGeoJSONReader",
 &PyvtkGeoJSONReader_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkPolyDataAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkGeoJSONReader_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkGeoJSONReader(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkGeoJSONReader_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkGeoJSONReader", o) != 0)
  {
    Py_DECREF(o);
  }

}

