// python wrapper for vtkBufferedArchiver
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkBufferedArchiver.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkBufferedArchiver(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkBufferedArchiver_ClassNew(); }


static PyObject *
PyvtkBufferedArchiver_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkBufferedArchiver::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkBufferedArchiver_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBufferedArchiver *op = static_cast<vtkBufferedArchiver *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkBufferedArchiver::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkBufferedArchiver_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkBufferedArchiver *tempr = vtkBufferedArchiver::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkBufferedArchiver_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBufferedArchiver *op = static_cast<vtkBufferedArchiver *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkBufferedArchiver *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkBufferedArchiver::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkBufferedArchiver_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkBufferedArchiver::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkBufferedArchiver_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBufferedArchiver *op = static_cast<vtkBufferedArchiver *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkBufferedArchiver::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkBufferedArchiver_OpenArchive(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "OpenArchive");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBufferedArchiver *op = static_cast<vtkBufferedArchiver *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->OpenArchive();
    }
    else
    {
      op->vtkBufferedArchiver::OpenArchive();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkBufferedArchiver_CloseArchive(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "CloseArchive");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBufferedArchiver *op = static_cast<vtkBufferedArchiver *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->CloseArchive();
    }
    else
    {
      op->vtkBufferedArchiver::CloseArchive();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkBufferedArchiver_InsertIntoArchive(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InsertIntoArchive");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBufferedArchiver *op = static_cast<vtkBufferedArchiver *>(vp);

  std::string temp0;
  const char *temp1 = nullptr;
  size_t temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->InsertIntoArchive(temp0, temp1, temp2);
    }
    else
    {
      op->vtkBufferedArchiver::InsertIntoArchive(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkBufferedArchiver_Contains(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Contains");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBufferedArchiver *op = static_cast<vtkBufferedArchiver *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = (ap.IsBound() ?
      op->Contains(temp0) :
      op->vtkBufferedArchiver::Contains(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkBufferedArchiver_GetBuffer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBuffer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBufferedArchiver *op = static_cast<vtkBufferedArchiver *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetBuffer() :
      op->vtkBufferedArchiver::GetBuffer());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkBufferedArchiver_GetBufferAddress(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBufferAddress");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBufferedArchiver *op = static_cast<vtkBufferedArchiver *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const void  *tempr = (ap.IsBound() ?
      op->GetBufferAddress() :
      op->vtkBufferedArchiver::GetBufferAddress());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkBufferedArchiver_SetAllocatedSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAllocatedSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBufferedArchiver *op = static_cast<vtkBufferedArchiver *>(vp);

  size_t temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetAllocatedSize(temp0);
    }
    else
    {
      op->vtkBufferedArchiver::SetAllocatedSize(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkBufferedArchiver_GetAllocatedSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAllocatedSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBufferedArchiver *op = static_cast<vtkBufferedArchiver *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    size_t tempr = (ap.IsBound() ?
      op->GetAllocatedSize() :
      op->vtkBufferedArchiver::GetAllocatedSize());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkBufferedArchiver_GetBufferSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBufferSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBufferedArchiver *op = static_cast<vtkBufferedArchiver *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    size_t tempr = (ap.IsBound() ?
      op->GetBufferSize() :
      op->vtkBufferedArchiver::GetBufferSize());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkBufferedArchiver_Methods[] = {
  {"IsTypeOf", PyvtkBufferedArchiver_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkBufferedArchiver_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkBufferedArchiver_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkBufferedArchiver\nC++: static vtkBufferedArchiver *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkBufferedArchiver_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkBufferedArchiver\nC++: vtkBufferedArchiver *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkBufferedArchiver_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkBufferedArchiver_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"OpenArchive", PyvtkBufferedArchiver_OpenArchive, METH_VARARGS,
   "OpenArchive(self) -> None\nC++: void OpenArchive() override;\n\nOpen the archive for writing.\n"},
  {"CloseArchive", PyvtkBufferedArchiver_CloseArchive, METH_VARARGS,
   "CloseArchive(self) -> None\nC++: void CloseArchive() override;\n\nClose the archive.\n"},
  {"InsertIntoArchive", PyvtkBufferedArchiver_InsertIntoArchive, METH_VARARGS,
   "InsertIntoArchive(self, relativePath:str, data:str, size:int)\n    -> None\nC++: void InsertIntoArchive(const std::string &relativePath,\n    const char *data, std::size_t size) override;\n\nInsert data of size size into the archive at relativePath.\n"},
  {"Contains", PyvtkBufferedArchiver_Contains, METH_VARARGS,
   "Contains(self, relativePath:str) -> bool\nC++: bool Contains(const std::string &relativePath) override;\n\nChecks if relativePath represents an entry in the archive.\n"},
  {"GetBuffer", PyvtkBufferedArchiver_GetBuffer, METH_VARARGS,
   "GetBuffer(self) -> str\nC++: const char *GetBuffer()\n\nAccess the buffer.\n"},
  {"GetBufferAddress", PyvtkBufferedArchiver_GetBufferAddress, METH_VARARGS,
   "GetBufferAddress(self) -> Pointer\nC++: const void *GetBufferAddress()\n\nAccess the address of the buffer.\n"},
  {"SetAllocatedSize", PyvtkBufferedArchiver_SetAllocatedSize, METH_VARARGS,
   "SetAllocatedSize(self, __a:int) -> None\nC++: void SetAllocatedSize(std::size_t)\n\nSet/Get the allocated buffer size.\n"},
  {"GetAllocatedSize", PyvtkBufferedArchiver_GetAllocatedSize, METH_VARARGS,
   "GetAllocatedSize(self) -> int\nC++: std::size_t GetAllocatedSize()\n\n"},
  {"GetBufferSize", PyvtkBufferedArchiver_GetBufferSize, METH_VARARGS,
   "GetBufferSize(self) -> int\nC++: std::size_t GetBufferSize()\n\nGet the buffer used size.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkBufferedArchiver_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("allocated_size"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkBufferedArchiver_GetAllocatedSize(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkBufferedArchiver_SetAllocatedSize(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkBufferedArchiver_SetAllocatedSize(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetAllocatedSize/SetAllocatedSize\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("buffer"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkBufferedArchiver_GetBuffer(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetBuffer\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("buffer_address"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkBufferedArchiver_GetBufferAddress(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetBufferAddress\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("buffer_size"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkBufferedArchiver_GetBufferSize(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetBufferSize\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkBufferedArchiver_Doc =
  "vtkBufferedArchiver - Writes an archive to a buffer for vtk-js\ndatasets\n\n"
  "Superclass: vtkArchiver\n\n"
  "vtkvtkJSBufferedArchiver is a specialized archiver for writing\n"
  "datasets into a memory buffer with zip compression.\n\n"
  "@sa\n"
  "vtkArchiver\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkBufferedArchiver_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkCommonArchive.vtkBufferedArchiver", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkBufferedArchiver_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkBufferedArchiver_StaticNew()
{
  return vtkBufferedArchiver::New();
}

PyObject *PyvtkBufferedArchiver_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkBufferedArchiver_Type, PyvtkBufferedArchiver_Methods,
    "vtkBufferedArchiver",
 &PyvtkBufferedArchiver_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkArchiver");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkBufferedArchiver_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkBufferedArchiver(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkBufferedArchiver_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkBufferedArchiver", o) != 0)
  {
    Py_DECREF(o);
  }

}

