// java wrapper for vtkImageItem object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkImageItem.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkContextItem_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkImageItem_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkImageItem",dType)) { return me; }
  if ((res= vtkContextItem_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageItem_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageItem* op = static_cast<vtkImageItem*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageItem_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageItem* op = static_cast<vtkImageItem*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageItem_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageItem* op = static_cast<vtkImageItem*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageItem_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageItem* op = static_cast<vtkImageItem*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkImageItem_Paint_14(JNIEnv* env, jobject obj,jobject id0)
{
  vtkContext2D * temp0;
  bool   temp20;
  temp0 = static_cast<vtkContext2D*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImageItem* op = static_cast<vtkImageItem*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Paint(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageItem_SetImage_15(JNIEnv* env, jobject obj,jobject id0)
{
  vtkImageData * temp0;
  temp0 = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImageItem* op = static_cast<vtkImageItem*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetImage(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageItem_GetImage_16(JNIEnv* env, jobject obj)
{
  vtkImageData * temp20;

  vtkImageItem* op = static_cast<vtkImageItem*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetImage();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageItem_SetPosition_17(JNIEnv* env, jobject obj,jfloat id0,jfloat id1)
{
  float   temp0;
  float   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkImageItem* op = static_cast<vtkImageItem*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPosition(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageItem_SetPosition_18(JNIEnv* env, jobject obj,jfloatArray id0)
{
  float temp0[2];
  env->GetFloatArrayRegion(id0, 0, 2, &temp0[0]);

  vtkImageItem* op = static_cast<vtkImageItem*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPosition(temp0);

}

extern "C" JNIEXPORT jfloatArray  JNICALL Java_vtk_vtkImageItem_GetPosition_19(JNIEnv* env, jobject obj)
{
  float * temp20;

  vtkImageItem* op = static_cast<vtkImageItem*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPosition();
  return vtkJavaMakeJArrayOfFloat(env, temp20, 2);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkImageItem_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkImageItem::New());
}
