// java wrapper for vtkPointDensityFilter object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkPointDensityFilter.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkImageAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkPointDensityFilter_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkPointDensityFilter",dType)) { return me; }
  if ((res= vtkImageAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPointDensityFilter_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPointDensityFilter* op = static_cast<vtkPointDensityFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPointDensityFilter_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPointDensityFilter* op = static_cast<vtkPointDensityFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPointDensityFilter_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPointDensityFilter* op = static_cast<vtkPointDensityFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPointDensityFilter_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPointDensityFilter* op = static_cast<vtkPointDensityFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointDensityFilter_SetSampleDimensions_14(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2)
{
  int   temp0;
  int   temp1;
  int   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkPointDensityFilter* op = static_cast<vtkPointDensityFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSampleDimensions(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointDensityFilter_SetSampleDimensions_15(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[3];
  env->GetIntArrayRegion(id0, 0, 3, reinterpret_cast<jint*>(&temp0[0]));

  vtkPointDensityFilter* op = static_cast<vtkPointDensityFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSampleDimensions(temp0);
  env->SetIntArrayRegion(id0, 0, 3, reinterpret_cast<jint*>(&temp0[0]));

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkPointDensityFilter_GetSampleDimensions_16(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkPointDensityFilter* op = static_cast<vtkPointDensityFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSampleDimensions();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointDensityFilter_SetModelBounds_17(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3,jdouble id4,jdouble id5)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  double   temp4;
  double   temp5;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;

  vtkPointDensityFilter* op = static_cast<vtkPointDensityFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetModelBounds(temp0,temp1,temp2,temp3,temp4,temp5);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointDensityFilter_SetModelBounds_18(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[6];
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

  vtkPointDensityFilter* op = static_cast<vtkPointDensityFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetModelBounds(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkPointDensityFilter_GetModelBounds_19(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkPointDensityFilter* op = static_cast<vtkPointDensityFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetModelBounds();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 6);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointDensityFilter_SetAdjustDistance_110(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkPointDensityFilter* op = static_cast<vtkPointDensityFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAdjustDistance(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkPointDensityFilter_GetAdjustDistanceMinValue_111(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkPointDensityFilter* op = static_cast<vtkPointDensityFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAdjustDistanceMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkPointDensityFilter_GetAdjustDistanceMaxValue_112(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkPointDensityFilter* op = static_cast<vtkPointDensityFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAdjustDistanceMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkPointDensityFilter_GetAdjustDistance_113(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkPointDensityFilter* op = static_cast<vtkPointDensityFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAdjustDistance();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointDensityFilter_SetDensityEstimate_114(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkPointDensityFilter* op = static_cast<vtkPointDensityFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDensityEstimate(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPointDensityFilter_GetDensityEstimateMinValue_115(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPointDensityFilter* op = static_cast<vtkPointDensityFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDensityEstimateMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPointDensityFilter_GetDensityEstimateMaxValue_116(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPointDensityFilter* op = static_cast<vtkPointDensityFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDensityEstimateMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPointDensityFilter_GetDensityEstimate_117(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPointDensityFilter* op = static_cast<vtkPointDensityFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDensityEstimate();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointDensityFilter_SetDensityEstimateToFixedRadius_118(JNIEnv* env, jobject obj)
{

  vtkPointDensityFilter* op = static_cast<vtkPointDensityFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDensityEstimateToFixedRadius();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointDensityFilter_SetDensityEstimateToRelativeRadius_119(JNIEnv* env, jobject obj)
{

  vtkPointDensityFilter* op = static_cast<vtkPointDensityFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDensityEstimateToRelativeRadius();

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkPointDensityFilter_GetDensityEstimateAsString_120(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkPointDensityFilter* op = static_cast<vtkPointDensityFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDensityEstimateAsString();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointDensityFilter_SetDensityForm_121(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkPointDensityFilter* op = static_cast<vtkPointDensityFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDensityForm(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPointDensityFilter_GetDensityFormMinValue_122(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPointDensityFilter* op = static_cast<vtkPointDensityFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDensityFormMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPointDensityFilter_GetDensityFormMaxValue_123(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPointDensityFilter* op = static_cast<vtkPointDensityFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDensityFormMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPointDensityFilter_GetDensityForm_124(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPointDensityFilter* op = static_cast<vtkPointDensityFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDensityForm();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointDensityFilter_SetDensityFormToVolumeNormalized_125(JNIEnv* env, jobject obj)
{

  vtkPointDensityFilter* op = static_cast<vtkPointDensityFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDensityFormToVolumeNormalized();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointDensityFilter_SetDensityFormToNumberOfPoints_126(JNIEnv* env, jobject obj)
{

  vtkPointDensityFilter* op = static_cast<vtkPointDensityFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDensityFormToNumberOfPoints();

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkPointDensityFilter_GetDensityFormAsString_127(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkPointDensityFilter* op = static_cast<vtkPointDensityFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDensityFormAsString();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointDensityFilter_SetRadius_128(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkPointDensityFilter* op = static_cast<vtkPointDensityFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRadius(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkPointDensityFilter_GetRadiusMinValue_129(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkPointDensityFilter* op = static_cast<vtkPointDensityFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRadiusMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkPointDensityFilter_GetRadiusMaxValue_130(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkPointDensityFilter* op = static_cast<vtkPointDensityFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRadiusMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkPointDensityFilter_GetRadius_131(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkPointDensityFilter* op = static_cast<vtkPointDensityFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRadius();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointDensityFilter_SetRelativeRadius_132(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkPointDensityFilter* op = static_cast<vtkPointDensityFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRelativeRadius(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkPointDensityFilter_GetRelativeRadiusMinValue_133(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkPointDensityFilter* op = static_cast<vtkPointDensityFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRelativeRadiusMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkPointDensityFilter_GetRelativeRadiusMaxValue_134(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkPointDensityFilter* op = static_cast<vtkPointDensityFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRelativeRadiusMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkPointDensityFilter_GetRelativeRadius_135(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkPointDensityFilter* op = static_cast<vtkPointDensityFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRelativeRadius();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointDensityFilter_SetScalarWeighting_136(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkPointDensityFilter* op = static_cast<vtkPointDensityFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScalarWeighting(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkPointDensityFilter_GetScalarWeighting_137(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkPointDensityFilter* op = static_cast<vtkPointDensityFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScalarWeighting();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointDensityFilter_ScalarWeightingOn_138(JNIEnv* env, jobject obj)
{

  vtkPointDensityFilter* op = static_cast<vtkPointDensityFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->ScalarWeightingOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointDensityFilter_ScalarWeightingOff_139(JNIEnv* env, jobject obj)
{

  vtkPointDensityFilter* op = static_cast<vtkPointDensityFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->ScalarWeightingOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointDensityFilter_SetComputeGradient_140(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkPointDensityFilter* op = static_cast<vtkPointDensityFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetComputeGradient(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkPointDensityFilter_GetComputeGradient_141(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkPointDensityFilter* op = static_cast<vtkPointDensityFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetComputeGradient();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointDensityFilter_ComputeGradientOn_142(JNIEnv* env, jobject obj)
{

  vtkPointDensityFilter* op = static_cast<vtkPointDensityFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->ComputeGradientOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointDensityFilter_ComputeGradientOff_143(JNIEnv* env, jobject obj)
{

  vtkPointDensityFilter* op = static_cast<vtkPointDensityFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->ComputeGradientOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointDensityFilter_SetLocator_144(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAbstractPointLocator * temp0;
  temp0 = static_cast<vtkAbstractPointLocator*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPointDensityFilter* op = static_cast<vtkPointDensityFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLocator(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPointDensityFilter_GetLocator_145(JNIEnv* env, jobject obj)
{
  vtkAbstractPointLocator * temp20;

  vtkPointDensityFilter* op = static_cast<vtkPointDensityFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLocator();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkPointDensityFilter_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkPointDensityFilter::New());
}
