// python wrapper for vtkPostgreSQLDatabase
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkStdString.h"
#include "vtkPostgreSQLDatabase.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkPostgreSQLDatabase(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPostgreSQLDatabase_ClassNew(); }


static PyObject *
PyvtkPostgreSQLDatabase_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkPostgreSQLDatabase::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPostgreSQLDatabase_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPostgreSQLDatabase *op = static_cast<vtkPostgreSQLDatabase *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkPostgreSQLDatabase::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPostgreSQLDatabase_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkPostgreSQLDatabase *tempr = vtkPostgreSQLDatabase::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPostgreSQLDatabase_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPostgreSQLDatabase *op = static_cast<vtkPostgreSQLDatabase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPostgreSQLDatabase *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkPostgreSQLDatabase::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPostgreSQLDatabase_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkPostgreSQLDatabase::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPostgreSQLDatabase_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPostgreSQLDatabase *op = static_cast<vtkPostgreSQLDatabase *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkPostgreSQLDatabase::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPostgreSQLDatabase_Open(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Open");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPostgreSQLDatabase *op = static_cast<vtkPostgreSQLDatabase *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0, 1) &&
      (ap.NoArgsLeft() || ap.GetValue(temp0)))
  {
    bool tempr = (ap.IsBound() ?
      op->Open(temp0) :
      op->vtkPostgreSQLDatabase::Open(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPostgreSQLDatabase_Close(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Close");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPostgreSQLDatabase *op = static_cast<vtkPostgreSQLDatabase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->Close();
    }
    else
    {
      op->vtkPostgreSQLDatabase::Close();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPostgreSQLDatabase_IsOpen(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsOpen");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPostgreSQLDatabase *op = static_cast<vtkPostgreSQLDatabase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->IsOpen() :
      op->vtkPostgreSQLDatabase::IsOpen());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPostgreSQLDatabase_GetQueryInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetQueryInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPostgreSQLDatabase *op = static_cast<vtkPostgreSQLDatabase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSQLQuery *tempr = (ap.IsBound() ?
      op->GetQueryInstance() :
      op->vtkPostgreSQLDatabase::GetQueryInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPostgreSQLDatabase_HasError(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "HasError");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPostgreSQLDatabase *op = static_cast<vtkPostgreSQLDatabase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->HasError() :
      op->vtkPostgreSQLDatabase::HasError());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPostgreSQLDatabase_GetLastErrorText(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetLastErrorText");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPostgreSQLDatabase *op = static_cast<vtkPostgreSQLDatabase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetLastErrorText() :
      op->vtkPostgreSQLDatabase::GetLastErrorText());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPostgreSQLDatabase_GetDatabaseType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDatabaseType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPostgreSQLDatabase *op = static_cast<vtkPostgreSQLDatabase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetDatabaseType() :
      op->vtkPostgreSQLDatabase::GetDatabaseType());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPostgreSQLDatabase_SetHostName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetHostName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPostgreSQLDatabase *op = static_cast<vtkPostgreSQLDatabase *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetHostName(temp0);
    }
    else
    {
      op->vtkPostgreSQLDatabase::SetHostName(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPostgreSQLDatabase_GetHostName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetHostName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPostgreSQLDatabase *op = static_cast<vtkPostgreSQLDatabase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetHostName() :
      op->vtkPostgreSQLDatabase::GetHostName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPostgreSQLDatabase_SetUser(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUser");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPostgreSQLDatabase *op = static_cast<vtkPostgreSQLDatabase *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUser(temp0);
    }
    else
    {
      op->vtkPostgreSQLDatabase::SetUser(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPostgreSQLDatabase_GetUser(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUser");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPostgreSQLDatabase *op = static_cast<vtkPostgreSQLDatabase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetUser() :
      op->vtkPostgreSQLDatabase::GetUser());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPostgreSQLDatabase_SetPassword(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPassword");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPostgreSQLDatabase *op = static_cast<vtkPostgreSQLDatabase *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPassword(temp0);
    }
    else
    {
      op->vtkPostgreSQLDatabase::SetPassword(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPostgreSQLDatabase_SetDatabaseName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDatabaseName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPostgreSQLDatabase *op = static_cast<vtkPostgreSQLDatabase *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDatabaseName(temp0);
    }
    else
    {
      op->vtkPostgreSQLDatabase::SetDatabaseName(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPostgreSQLDatabase_GetDatabaseName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDatabaseName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPostgreSQLDatabase *op = static_cast<vtkPostgreSQLDatabase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetDatabaseName() :
      op->vtkPostgreSQLDatabase::GetDatabaseName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPostgreSQLDatabase_SetConnectOptions(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetConnectOptions");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPostgreSQLDatabase *op = static_cast<vtkPostgreSQLDatabase *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetConnectOptions(temp0);
    }
    else
    {
      op->vtkPostgreSQLDatabase::SetConnectOptions(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPostgreSQLDatabase_GetConnectOptions(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetConnectOptions");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPostgreSQLDatabase *op = static_cast<vtkPostgreSQLDatabase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetConnectOptions() :
      op->vtkPostgreSQLDatabase::GetConnectOptions());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPostgreSQLDatabase_SetServerPort(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetServerPort");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPostgreSQLDatabase *op = static_cast<vtkPostgreSQLDatabase *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetServerPort(temp0);
    }
    else
    {
      op->vtkPostgreSQLDatabase::SetServerPort(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPostgreSQLDatabase_GetServerPortMinValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetServerPortMinValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPostgreSQLDatabase *op = static_cast<vtkPostgreSQLDatabase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetServerPortMinValue() :
      op->vtkPostgreSQLDatabase::GetServerPortMinValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPostgreSQLDatabase_GetServerPortMaxValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetServerPortMaxValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPostgreSQLDatabase *op = static_cast<vtkPostgreSQLDatabase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetServerPortMaxValue() :
      op->vtkPostgreSQLDatabase::GetServerPortMaxValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPostgreSQLDatabase_GetServerPort(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetServerPort");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPostgreSQLDatabase *op = static_cast<vtkPostgreSQLDatabase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetServerPort() :
      op->vtkPostgreSQLDatabase::GetServerPort());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPostgreSQLDatabase_GetURL(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetURL");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPostgreSQLDatabase *op = static_cast<vtkPostgreSQLDatabase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkStdString tempr = (ap.IsBound() ?
      op->GetURL() :
      op->vtkPostgreSQLDatabase::GetURL());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPostgreSQLDatabase_GetTables(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTables");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPostgreSQLDatabase *op = static_cast<vtkPostgreSQLDatabase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkStringArray *tempr = (ap.IsBound() ?
      op->GetTables() :
      op->vtkPostgreSQLDatabase::GetTables());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPostgreSQLDatabase_GetRecord(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRecord");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPostgreSQLDatabase *op = static_cast<vtkPostgreSQLDatabase *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkStringArray *tempr = (ap.IsBound() ?
      op->GetRecord(temp0) :
      op->vtkPostgreSQLDatabase::GetRecord(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPostgreSQLDatabase_IsSupported(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsSupported");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPostgreSQLDatabase *op = static_cast<vtkPostgreSQLDatabase *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = (ap.IsBound() ?
      op->IsSupported(temp0) :
      op->vtkPostgreSQLDatabase::IsSupported(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPostgreSQLDatabase_GetDatabases(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDatabases");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPostgreSQLDatabase *op = static_cast<vtkPostgreSQLDatabase *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkStringArray *tempr = (ap.IsBound() ?
      op->GetDatabases() :
      op->vtkPostgreSQLDatabase::GetDatabases());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPostgreSQLDatabase_CreateDatabase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "CreateDatabase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPostgreSQLDatabase *op = static_cast<vtkPostgreSQLDatabase *>(vp);

  const char *temp0 = nullptr;
  bool temp1 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1, 2) &&
      ap.GetValue(temp0) &&
      (ap.NoArgsLeft() || ap.GetValue(temp1)))
  {
    bool tempr = (ap.IsBound() ?
      op->CreateDatabase(temp0, temp1) :
      op->vtkPostgreSQLDatabase::CreateDatabase(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPostgreSQLDatabase_DropDatabase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "DropDatabase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPostgreSQLDatabase *op = static_cast<vtkPostgreSQLDatabase *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = (ap.IsBound() ?
      op->DropDatabase(temp0) :
      op->vtkPostgreSQLDatabase::DropDatabase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPostgreSQLDatabase_GetColumnSpecification(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetColumnSpecification");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPostgreSQLDatabase *op = static_cast<vtkPostgreSQLDatabase *>(vp);

  vtkSQLDatabaseSchema *temp0 = nullptr;
  int temp1;
  int temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetVTKObject(temp0, "vtkSQLDatabaseSchema") &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    vtkStdString tempr = (ap.IsBound() ?
      op->GetColumnSpecification(temp0, temp1, temp2) :
      op->vtkPostgreSQLDatabase::GetColumnSpecification(temp0, temp1, temp2));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPostgreSQLDatabase_ParseURL(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ParseURL");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPostgreSQLDatabase *op = static_cast<vtkPostgreSQLDatabase *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = (ap.IsBound() ?
      op->ParseURL(temp0) :
      op->vtkPostgreSQLDatabase::ParseURL(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkPostgreSQLDatabase_Methods[] = {
  {"IsTypeOf", PyvtkPostgreSQLDatabase_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkPostgreSQLDatabase_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkPostgreSQLDatabase_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkPostgreSQLDatabase\nC++: static vtkPostgreSQLDatabase *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkPostgreSQLDatabase_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkPostgreSQLDatabase\nC++: vtkPostgreSQLDatabase *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkPostgreSQLDatabase_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkPostgreSQLDatabase_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"Open", PyvtkPostgreSQLDatabase_Open, METH_VARARGS,
   "Open(self, password:str=...) -> bool\nC++: bool Open(const char *password=nullptr) override;\n\nOpen a new connection to the database.  You need to set the\nfilename before calling this function.  Returns true if the\ndatabase was opened successfully; false otherwise.\n"},
  {"Close", PyvtkPostgreSQLDatabase_Close, METH_VARARGS,
   "Close(self) -> None\nC++: void Close() override;\n\nClose the connection to the database.\n"},
  {"IsOpen", PyvtkPostgreSQLDatabase_IsOpen, METH_VARARGS,
   "IsOpen(self) -> bool\nC++: bool IsOpen() override;\n\nReturn whether the database has an open connection\n"},
  {"GetQueryInstance", PyvtkPostgreSQLDatabase_GetQueryInstance, METH_VARARGS,
   "GetQueryInstance(self) -> vtkSQLQuery\nC++: vtkSQLQuery *GetQueryInstance() override;\n\nReturn an empty query on this database.\n"},
  {"HasError", PyvtkPostgreSQLDatabase_HasError, METH_VARARGS,
   "HasError(self) -> bool\nC++: bool HasError() override;\n\nDid the last operation generate an error\n"},
  {"GetLastErrorText", PyvtkPostgreSQLDatabase_GetLastErrorText, METH_VARARGS,
   "GetLastErrorText(self) -> str\nC++: const char *GetLastErrorText() override;\n\nGet the last error text from the database\n"},
  {"GetDatabaseType", PyvtkPostgreSQLDatabase_GetDatabaseType, METH_VARARGS,
   "GetDatabaseType(self) -> str\nC++: const char *GetDatabaseType() override;\n\nString representing database type (e.g. \"psql\").\n"},
  {"SetHostName", PyvtkPostgreSQLDatabase_SetHostName, METH_VARARGS,
   "SetHostName(self, __a:str) -> None\nC++: virtual void SetHostName(const char *)\n\nThe database server host name.\n"},
  {"GetHostName", PyvtkPostgreSQLDatabase_GetHostName, METH_VARARGS,
   "GetHostName(self) -> str\nC++: virtual char *GetHostName()\n\n"},
  {"SetUser", PyvtkPostgreSQLDatabase_SetUser, METH_VARARGS,
   "SetUser(self, __a:str) -> None\nC++: virtual void SetUser(const char *)\n\nThe user name for connecting to the database server.\n"},
  {"GetUser", PyvtkPostgreSQLDatabase_GetUser, METH_VARARGS,
   "GetUser(self) -> str\nC++: virtual char *GetUser()\n\n"},
  {"SetPassword", PyvtkPostgreSQLDatabase_SetPassword, METH_VARARGS,
   "SetPassword(self, __a:str) -> None\nC++: virtual void SetPassword(const char *)\n\nThe user's password for connecting to the database server.\n"},
  {"SetDatabaseName", PyvtkPostgreSQLDatabase_SetDatabaseName, METH_VARARGS,
   "SetDatabaseName(self, __a:str) -> None\nC++: virtual void SetDatabaseName(const char *)\n\nThe name of the database to connect to.\n"},
  {"GetDatabaseName", PyvtkPostgreSQLDatabase_GetDatabaseName, METH_VARARGS,
   "GetDatabaseName(self) -> str\nC++: virtual char *GetDatabaseName()\n\n"},
  {"SetConnectOptions", PyvtkPostgreSQLDatabase_SetConnectOptions, METH_VARARGS,
   "SetConnectOptions(self, __a:str) -> None\nC++: virtual void SetConnectOptions(const char *)\n\nAdditional options for the database.\n"},
  {"GetConnectOptions", PyvtkPostgreSQLDatabase_GetConnectOptions, METH_VARARGS,
   "GetConnectOptions(self) -> str\nC++: virtual char *GetConnectOptions()\n\n"},
  {"SetServerPort", PyvtkPostgreSQLDatabase_SetServerPort, METH_VARARGS,
   "SetServerPort(self, __a:int) -> None\nC++: virtual void SetServerPort(int)\n\nThe port used for connecting to the database.\n"},
  {"GetServerPortMinValue", PyvtkPostgreSQLDatabase_GetServerPortMinValue, METH_VARARGS,
   "GetServerPortMinValue(self) -> int\nC++: virtual int GetServerPortMinValue()\n\n"},
  {"GetServerPortMaxValue", PyvtkPostgreSQLDatabase_GetServerPortMaxValue, METH_VARARGS,
   "GetServerPortMaxValue(self) -> int\nC++: virtual int GetServerPortMaxValue()\n\n"},
  {"GetServerPort", PyvtkPostgreSQLDatabase_GetServerPort, METH_VARARGS,
   "GetServerPort(self) -> int\nC++: virtual int GetServerPort()\n\n"},
  {"GetURL", PyvtkPostgreSQLDatabase_GetURL, METH_VARARGS,
   "GetURL(self) -> str\nC++: vtkStdString GetURL() override;\n\nGet a URL referencing the current database connection. This is\nnot well-defined if the HostName and DatabaseName have not been\nset. The URL will be of the form\n'psql://'[username[':'password]'@']hostname[':'port]'/'database.\n"},
  {"GetTables", PyvtkPostgreSQLDatabase_GetTables, METH_VARARGS,
   "GetTables(self) -> vtkStringArray\nC++: vtkStringArray *GetTables() override;\n\nGet the list of tables from the database\n"},
  {"GetRecord", PyvtkPostgreSQLDatabase_GetRecord, METH_VARARGS,
   "GetRecord(self, table:str) -> vtkStringArray\nC++: vtkStringArray *GetRecord(const char *table) override;\n\nGet the list of fields for a particular table\n"},
  {"IsSupported", PyvtkPostgreSQLDatabase_IsSupported, METH_VARARGS,
   "IsSupported(self, feature:int) -> bool\nC++: bool IsSupported(int feature) override;\n\nReturn whether a feature is supported by the database.\n"},
  {"GetDatabases", PyvtkPostgreSQLDatabase_GetDatabases, METH_VARARGS,
   "GetDatabases(self) -> vtkStringArray\nC++: vtkStringArray *GetDatabases()\n\nReturn a list of databases on the server.\n"},
  {"CreateDatabase", PyvtkPostgreSQLDatabase_CreateDatabase, METH_VARARGS,
   "CreateDatabase(self, dbName:str, dropExisting:bool=False) -> bool\nC++: bool CreateDatabase(const char *dbName,\n    bool dropExisting=false)\n\nCreate a new database, optionally dropping any existing database\nof the same name. Returns true when the database is properly\ncreated and false on failure.\n"},
  {"DropDatabase", PyvtkPostgreSQLDatabase_DropDatabase, METH_VARARGS,
   "DropDatabase(self, dbName:str) -> bool\nC++: bool DropDatabase(const char *dbName)\n\nDrop a database if it exists. Returns true on success and false\non failure.\n"},
  {"GetColumnSpecification", PyvtkPostgreSQLDatabase_GetColumnSpecification, METH_VARARGS,
   "GetColumnSpecification(self, schema:vtkSQLDatabaseSchema,\n    tblHandle:int, colHandle:int) -> str\nC++: vtkStdString GetColumnSpecification(\n    vtkSQLDatabaseSchema *schema, int tblHandle, int colHandle)\n    override;\n\nReturn the SQL string with the syntax to create a column inside a \"CREATE\nTABLE\" SQL statement. NB: this method implements the\nPostgreSQL-specific syntax:<column name> <column type> <column\nattributes>\n"},
  {"ParseURL", PyvtkPostgreSQLDatabase_ParseURL, METH_VARARGS,
   "ParseURL(self, url:str) -> bool\nC++: bool ParseURL(const char *url) override;\n\nOverridden to determine connection parameters given the URL. This\nis called by CreateFromURL() to initialize the instance. Look at\nCreateFromURL() for details about the URL format.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPostgreSQLDatabase_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("host_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPostgreSQLDatabase_GetHostName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPostgreSQLDatabase_SetHostName(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPostgreSQLDatabase_SetHostName(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetHostName/SetHostName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("user"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPostgreSQLDatabase_GetUser(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPostgreSQLDatabase_SetUser(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPostgreSQLDatabase_SetUser(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetUser/SetUser\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("password"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPostgreSQLDatabase_SetPassword(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPostgreSQLDatabase_SetPassword(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetPassword\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("database_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPostgreSQLDatabase_GetDatabaseName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPostgreSQLDatabase_SetDatabaseName(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPostgreSQLDatabase_SetDatabaseName(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetDatabaseName/SetDatabaseName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("connect_options"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPostgreSQLDatabase_GetConnectOptions(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPostgreSQLDatabase_SetConnectOptions(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPostgreSQLDatabase_SetConnectOptions(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetConnectOptions/SetConnectOptions\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("server_port"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPostgreSQLDatabase_GetServerPort(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPostgreSQLDatabase_SetServerPort(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPostgreSQLDatabase_SetServerPort(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetServerPort/SetServerPort\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("database_type"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPostgreSQLDatabase_GetDatabaseType(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetDatabaseType\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("last_error_text"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPostgreSQLDatabase_GetLastErrorText(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetLastErrorText\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("query_instance"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPostgreSQLDatabase_GetQueryInstance(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetQueryInstance\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("url"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPostgreSQLDatabase_GetURL(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetURL\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("tables"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPostgreSQLDatabase_GetTables(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetTables\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("databases"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPostgreSQLDatabase_GetDatabases(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetDatabases\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkPostgreSQLDatabase_Doc =
  "vtkPostgreSQLDatabase - maintain a connection to a PostgreSQL database\n\n"
  "Superclass: vtkSQLDatabase\n\n"
  "PostgreSQL (http://www.postgres.org) is a BSD-licensed SQL database.\n"
  "It's large, fast, and can not be easily embedded inside other\n"
  "applications.  Its databases are stored in files that belong to\n"
  "another process.\n\n"
  "This class provides a VTK interface to PostgreSQL.  You do need to\n"
  "download external libraries: we need a copy of PostgreSQL 8\n"
  "(currently 8.2 or 8.3) so that we can link against the libpq C\n"
  "interface.\n\n"
  "@par Thanks: Thanks to David Thompson and Andy Wilson from Sandia\n"
  "National Laboratories for implementing this class.\n\n"
  "@sa\n"
  "vtkPostgreSQLQuery\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPostgreSQLDatabase_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkIOPostgreSQL.vtkPostgreSQLDatabase", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkPostgreSQLDatabase_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkPostgreSQLDatabase_StaticNew()
{
  return vtkPostgreSQLDatabase::New();
}

PyObject *PyvtkPostgreSQLDatabase_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkPostgreSQLDatabase_Type, PyvtkPostgreSQLDatabase_Methods,
    "vtkPostgreSQLDatabase",
 &PyvtkPostgreSQLDatabase_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkSQLDatabase");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkPostgreSQLDatabase_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkPostgreSQLDatabase(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkPostgreSQLDatabase_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkPostgreSQLDatabase", o) != 0)
  {
    Py_DECREF(o);
  }

}

