const char metrics_psutils_cpu_lua[] =
"-- Linux is the only supported platform\n"
"if jit.os ~= 'Linux' then\n"
"    return { update = function() end }\n"
"end\n"
"\n"
"local utils = require('metrics.utils')\n"
"local psutils = require('metrics.psutils.psutils_linux')\n"
"\n"
"local collectors_list = {}\n"
"\n"
"local instance_file = arg[0]\n"
"\n"
"local threads = {}\n"
"\n"
"local function update_cpu_metrics()\n"
"    collectors_list.cpu_number = utils.set_gauge('cpu_number', 'The number of processors',\n"
"        psutils.get_cpu_count(), nil, nil, {default = true})\n"
"\n"
"    collectors_list.cpu_time = utils.set_gauge('cpu_time', 'Host CPU time',\n"
"        psutils.get_cpu_time(), nil, nil, {default = true})\n"
"\n"
"    local new_threads = {}\n"
"    for _, thread_info in ipairs(psutils.get_process_cpu_time()) do\n"
"        local labels = {\n"
"            thread_name = thread_info.comm,\n"
"            thread_pid = thread_info.pid,\n"
"            file_name = instance_file,\n"
"        }\n"
"\n"
"        local utime_labels = table.copy(labels)\n"
"        utime_labels.kind = 'user'\n"
"        collectors_list.cpu_thread = utils.set_gauge('cpu_thread', 'Tarantool thread cpu time',\n"
"            thread_info.utime, utime_labels, nil, {default = true})\n"
"\n"
"        local stime_labels = table.copy(labels)\n"
"        stime_labels.kind = 'system'\n"
"        collectors_list.cpu_thread = utils.set_gauge('cpu_thread', 'Tarantool thread cpu time',\n"
"            thread_info.stime, stime_labels, nil, {default = true})\n"
"\n"
"        threads[thread_info.pid] = nil\n"
"        new_threads[thread_info.pid] = labels\n"
"    end\n"
"\n"
"    for _, thread_info in pairs(threads) do\n"
"        thread_info.kind = 'user'\n"
"        collectors_list.cpu_thread:remove(thread_info)\n"
"\n"
"        thread_info.kind = 'system'\n"
"        collectors_list.cpu_thread:remove(thread_info)\n"
"    end\n"
"    threads = new_threads\n"
"end\n"
"\n"
"local function clear_cpu_metrics()\n"
"    utils.delete_collectors(collectors_list)\n"
"end\n"
"\n"
"return {\n"
"    update = update_cpu_metrics,\n"
"    list = collectors_list,\n"
"    clear = clear_cpu_metrics,\n"
"}\n"
""
;
