/* client functions auto-generated by pidl */

#include "includes.h"
#include <tevent.h>
#include "lib/util/tevent_ntstatus.h"
#include "bin/default/source4/librpc/gen_ndr/ndr_irpc.h"
#include "bin/default/source4/librpc/gen_ndr/ndr_irpc_c.h"

/* irpc - client functions generated by pidl */

struct dcerpc_irpc_uptime_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_irpc_uptime_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_irpc_uptime_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct irpc_uptime *r)
{
	struct tevent_req *req;
	struct dcerpc_irpc_uptime_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_irpc_uptime_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_irpc,
			NDR_IRPC_UPTIME, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_irpc_uptime_r_done, req);

	return req;
}

static void dcerpc_irpc_uptime_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_irpc_uptime_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_irpc_uptime_r_state *state =
		tevent_req_data(req,
		struct dcerpc_irpc_uptime_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_irpc_uptime_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct irpc_uptime *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_irpc,
			NDR_IRPC_UPTIME, mem_ctx, r);

	return status;
}

struct dcerpc_irpc_uptime_state {
	struct irpc_uptime orig;
	struct irpc_uptime tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_irpc_uptime_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_irpc_uptime_send(TALLOC_CTX *mem_ctx,
					   struct tevent_context *ev,
					   struct dcerpc_binding_handle *h,
					   NTTIME *_start_time /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_irpc_uptime_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_irpc_uptime_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */

	/* Out parameters */
	state->orig.out.start_time = _start_time;

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_irpc_uptime_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_irpc_uptime_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_irpc_uptime_done, req);
	return req;
}

static void dcerpc_irpc_uptime_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_irpc_uptime_state *state = tevent_req_data(
		req, struct dcerpc_irpc_uptime_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_irpc_uptime_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.start_time = *state->tmp.out.start_time;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_irpc_uptime_recv(struct tevent_req *req,
				 TALLOC_CTX *mem_ctx)
{
	struct dcerpc_irpc_uptime_state *state = tevent_req_data(
		req, struct dcerpc_irpc_uptime_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_irpc_uptime(struct dcerpc_binding_handle *h,
			    TALLOC_CTX *mem_ctx,
			    NTTIME *_start_time /* [out] [ref] */)
{
	struct irpc_uptime r;
	NTSTATUS status;

	/* In parameters */

	/* Out parameters */
	r.out.start_time = _start_time;

	status = dcerpc_irpc_uptime_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_start_time = *r.out.start_time;

	/* Return result */

	return NT_STATUS_OK;
}

struct dcerpc_nbtd_information_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_nbtd_information_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_nbtd_information_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct nbtd_information *r)
{
	struct tevent_req *req;
	struct dcerpc_nbtd_information_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_nbtd_information_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_irpc,
			NDR_NBTD_INFORMATION, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_nbtd_information_r_done, req);

	return req;
}

static void dcerpc_nbtd_information_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_nbtd_information_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_nbtd_information_r_state *state =
		tevent_req_data(req,
		struct dcerpc_nbtd_information_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_nbtd_information_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct nbtd_information *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_irpc,
			NDR_NBTD_INFORMATION, mem_ctx, r);

	return status;
}

/*
 * The following functions are skipped because
 * an [out] argument info is not a pointer or array:
 *
 * dcerpc_nbtd_information_send()
 * dcerpc_nbtd_information_recv()
 * dcerpc_nbtd_information()
 */

struct dcerpc_nbtd_getdcname_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_nbtd_getdcname_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_nbtd_getdcname_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct nbtd_getdcname *r)
{
	struct tevent_req *req;
	struct dcerpc_nbtd_getdcname_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_nbtd_getdcname_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_irpc,
			NDR_NBTD_GETDCNAME, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_nbtd_getdcname_r_done, req);

	return req;
}

static void dcerpc_nbtd_getdcname_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_nbtd_getdcname_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_nbtd_getdcname_r_state *state =
		tevent_req_data(req,
		struct dcerpc_nbtd_getdcname_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_nbtd_getdcname_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct nbtd_getdcname *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_irpc,
			NDR_NBTD_GETDCNAME, mem_ctx, r);

	return status;
}

/*
 * The following functions are skipped because
 * an [out] argument dcname is a pointer to a string type:
 *
 * dcerpc_nbtd_getdcname_send()
 * dcerpc_nbtd_getdcname_recv()
 * dcerpc_nbtd_getdcname()
 */

struct dcerpc_nbtd_proxy_wins_challenge_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_nbtd_proxy_wins_challenge_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_nbtd_proxy_wins_challenge_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct nbtd_proxy_wins_challenge *r)
{
	struct tevent_req *req;
	struct dcerpc_nbtd_proxy_wins_challenge_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_nbtd_proxy_wins_challenge_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_irpc,
			NDR_NBTD_PROXY_WINS_CHALLENGE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_nbtd_proxy_wins_challenge_r_done, req);

	return req;
}

static void dcerpc_nbtd_proxy_wins_challenge_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_nbtd_proxy_wins_challenge_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_nbtd_proxy_wins_challenge_r_state *state =
		tevent_req_data(req,
		struct dcerpc_nbtd_proxy_wins_challenge_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_nbtd_proxy_wins_challenge_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct nbtd_proxy_wins_challenge *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_irpc,
			NDR_NBTD_PROXY_WINS_CHALLENGE, mem_ctx, r);

	return status;
}

/*
 * The following functions are skipped because
 * an [out] argument num_addrs is not a pointer or array:
 *
 * dcerpc_nbtd_proxy_wins_challenge_send()
 * dcerpc_nbtd_proxy_wins_challenge_recv()
 * dcerpc_nbtd_proxy_wins_challenge()
 */

struct dcerpc_nbtd_proxy_wins_release_demand_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_nbtd_proxy_wins_release_demand_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_nbtd_proxy_wins_release_demand_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct nbtd_proxy_wins_release_demand *r)
{
	struct tevent_req *req;
	struct dcerpc_nbtd_proxy_wins_release_demand_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_nbtd_proxy_wins_release_demand_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_irpc,
			NDR_NBTD_PROXY_WINS_RELEASE_DEMAND, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_nbtd_proxy_wins_release_demand_r_done, req);

	return req;
}

static void dcerpc_nbtd_proxy_wins_release_demand_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_nbtd_proxy_wins_release_demand_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_nbtd_proxy_wins_release_demand_r_state *state =
		tevent_req_data(req,
		struct dcerpc_nbtd_proxy_wins_release_demand_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_nbtd_proxy_wins_release_demand_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct nbtd_proxy_wins_release_demand *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_irpc,
			NDR_NBTD_PROXY_WINS_RELEASE_DEMAND, mem_ctx, r);

	return status;
}

struct dcerpc_nbtd_proxy_wins_release_demand_state {
	struct nbtd_proxy_wins_release_demand orig;
	struct nbtd_proxy_wins_release_demand tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_nbtd_proxy_wins_release_demand_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_nbtd_proxy_wins_release_demand_send(TALLOC_CTX *mem_ctx,
							      struct tevent_context *ev,
							      struct dcerpc_binding_handle *h,
							      struct nbt_name _name /* [in]  */,
							      uint32_t _num_addrs /* [in]  */,
							      struct nbtd_proxy_wins_addr *_addrs /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_nbtd_proxy_wins_release_demand_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_nbtd_proxy_wins_release_demand_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.name = _name;
	state->orig.in.num_addrs = _num_addrs;
	state->orig.in.addrs = _addrs;

	/* Out parameters */

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_nbtd_proxy_wins_release_demand_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_nbtd_proxy_wins_release_demand_done, req);
	return req;
}

static void dcerpc_nbtd_proxy_wins_release_demand_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_nbtd_proxy_wins_release_demand_state *state = tevent_req_data(
		req, struct dcerpc_nbtd_proxy_wins_release_demand_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_nbtd_proxy_wins_release_demand_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_nbtd_proxy_wins_release_demand_recv(struct tevent_req *req,
						    TALLOC_CTX *mem_ctx)
{
	struct dcerpc_nbtd_proxy_wins_release_demand_state *state = tevent_req_data(
		req, struct dcerpc_nbtd_proxy_wins_release_demand_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_nbtd_proxy_wins_release_demand(struct dcerpc_binding_handle *h,
					       TALLOC_CTX *mem_ctx,
					       struct nbt_name _name /* [in]  */,
					       uint32_t _num_addrs /* [in]  */,
					       struct nbtd_proxy_wins_addr *_addrs /* [in]  */)
{
	struct nbtd_proxy_wins_release_demand r;
	NTSTATUS status;

	/* In parameters */
	r.in.name = _name;
	r.in.num_addrs = _num_addrs;
	r.in.addrs = _addrs;

	/* Out parameters */

	status = dcerpc_nbtd_proxy_wins_release_demand_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */

	return NT_STATUS_OK;
}

struct dcerpc_kdc_check_generic_kerberos_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_kdc_check_generic_kerberos_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_kdc_check_generic_kerberos_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct kdc_check_generic_kerberos *r)
{
	struct tevent_req *req;
	struct dcerpc_kdc_check_generic_kerberos_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_kdc_check_generic_kerberos_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_irpc,
			NDR_KDC_CHECK_GENERIC_KERBEROS, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_kdc_check_generic_kerberos_r_done, req);

	return req;
}

static void dcerpc_kdc_check_generic_kerberos_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_kdc_check_generic_kerberos_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_kdc_check_generic_kerberos_r_state *state =
		tevent_req_data(req,
		struct dcerpc_kdc_check_generic_kerberos_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_kdc_check_generic_kerberos_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct kdc_check_generic_kerberos *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_irpc,
			NDR_KDC_CHECK_GENERIC_KERBEROS, mem_ctx, r);

	return status;
}

/*
 * The following functions are skipped because
 * an [out] argument generic_reply is not a pointer or array:
 *
 * dcerpc_kdc_check_generic_kerberos_send()
 * dcerpc_kdc_check_generic_kerberos_recv()
 * dcerpc_kdc_check_generic_kerberos()
 */

struct dcerpc_smbsrv_information_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_smbsrv_information_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_smbsrv_information_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct smbsrv_information *r)
{
	struct tevent_req *req;
	struct dcerpc_smbsrv_information_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_smbsrv_information_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_irpc,
			NDR_SMBSRV_INFORMATION, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_smbsrv_information_r_done, req);

	return req;
}

static void dcerpc_smbsrv_information_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_smbsrv_information_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_smbsrv_information_r_state *state =
		tevent_req_data(req,
		struct dcerpc_smbsrv_information_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_smbsrv_information_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct smbsrv_information *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_irpc,
			NDR_SMBSRV_INFORMATION, mem_ctx, r);

	return status;
}

/*
 * The following functions are skipped because
 * an [out] argument info is not a pointer or array:
 *
 * dcerpc_smbsrv_information_send()
 * dcerpc_smbsrv_information_recv()
 * dcerpc_smbsrv_information()
 */

struct dcerpc_samba_terminate_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samba_terminate_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samba_terminate_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct samba_terminate *r)
{
	struct tevent_req *req;
	struct dcerpc_samba_terminate_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samba_terminate_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_irpc,
			NDR_SAMBA_TERMINATE, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samba_terminate_r_done, req);

	return req;
}

static void dcerpc_samba_terminate_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_samba_terminate_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_samba_terminate_r_state *state =
		tevent_req_data(req,
		struct dcerpc_samba_terminate_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samba_terminate_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct samba_terminate *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_irpc,
			NDR_SAMBA_TERMINATE, mem_ctx, r);

	return status;
}

struct dcerpc_samba_terminate_state {
	struct samba_terminate orig;
	struct samba_terminate tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_samba_terminate_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_samba_terminate_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct dcerpc_binding_handle *h,
					       const char * _reason /* [in] [flag(LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM)] */)
{
	struct tevent_req *req;
	struct dcerpc_samba_terminate_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_samba_terminate_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.reason = _reason;

	/* Out parameters */

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_samba_terminate_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_samba_terminate_done, req);
	return req;
}

static void dcerpc_samba_terminate_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_samba_terminate_state *state = tevent_req_data(
		req, struct dcerpc_samba_terminate_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_samba_terminate_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_samba_terminate_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx)
{
	struct dcerpc_samba_terminate_state *state = tevent_req_data(
		req, struct dcerpc_samba_terminate_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_samba_terminate(struct dcerpc_binding_handle *h,
				TALLOC_CTX *mem_ctx,
				const char * _reason /* [in] [flag(LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM)] */)
{
	struct samba_terminate r;
	NTSTATUS status;

	/* In parameters */
	r.in.reason = _reason;

	/* Out parameters */

	status = dcerpc_samba_terminate_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */

	return NT_STATUS_OK;
}

struct dcerpc_dreplsrv_refresh_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_dreplsrv_refresh_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_dreplsrv_refresh_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct dreplsrv_refresh *r)
{
	struct tevent_req *req;
	struct dcerpc_dreplsrv_refresh_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_dreplsrv_refresh_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_irpc,
			NDR_DREPLSRV_REFRESH, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_dreplsrv_refresh_r_done, req);

	return req;
}

static void dcerpc_dreplsrv_refresh_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_dreplsrv_refresh_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_dreplsrv_refresh_r_state *state =
		tevent_req_data(req,
		struct dcerpc_dreplsrv_refresh_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_dreplsrv_refresh_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct dreplsrv_refresh *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_irpc,
			NDR_DREPLSRV_REFRESH, mem_ctx, r);

	return status;
}

struct dcerpc_dreplsrv_refresh_state {
	struct dreplsrv_refresh orig;
	struct dreplsrv_refresh tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_dreplsrv_refresh_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_dreplsrv_refresh_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct dcerpc_binding_handle *h)
{
	struct tevent_req *req;
	struct dcerpc_dreplsrv_refresh_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_dreplsrv_refresh_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_dreplsrv_refresh_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_dreplsrv_refresh_done, req);
	return req;
}

static void dcerpc_dreplsrv_refresh_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_dreplsrv_refresh_state *state = tevent_req_data(
		req, struct dcerpc_dreplsrv_refresh_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_dreplsrv_refresh_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_dreplsrv_refresh_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      WERROR *result)
{
	struct dcerpc_dreplsrv_refresh_state *state = tevent_req_data(
		req, struct dcerpc_dreplsrv_refresh_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_dreplsrv_refresh(struct dcerpc_binding_handle *h,
				 TALLOC_CTX *mem_ctx,
				 WERROR *result)
{
	struct dreplsrv_refresh r;
	NTSTATUS status;

	/* In parameters */

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_dreplsrv_refresh_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_drepl_takeFSMORole_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_drepl_takeFSMORole_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_drepl_takeFSMORole_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct drepl_takeFSMORole *r)
{
	struct tevent_req *req;
	struct dcerpc_drepl_takeFSMORole_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_drepl_takeFSMORole_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_irpc,
			NDR_DREPL_TAKEFSMOROLE, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_drepl_takeFSMORole_r_done, req);

	return req;
}

static void dcerpc_drepl_takeFSMORole_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_drepl_takeFSMORole_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_drepl_takeFSMORole_r_state *state =
		tevent_req_data(req,
		struct dcerpc_drepl_takeFSMORole_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_drepl_takeFSMORole_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct drepl_takeFSMORole *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_irpc,
			NDR_DREPL_TAKEFSMOROLE, mem_ctx, r);

	return status;
}

struct dcerpc_drepl_takeFSMORole_state {
	struct drepl_takeFSMORole orig;
	struct drepl_takeFSMORole tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_drepl_takeFSMORole_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_drepl_takeFSMORole_send(TALLOC_CTX *mem_ctx,
						  struct tevent_context *ev,
						  struct dcerpc_binding_handle *h,
						  enum drepl_role_master _role /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_drepl_takeFSMORole_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_drepl_takeFSMORole_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.role = _role;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_drepl_takeFSMORole_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_drepl_takeFSMORole_done, req);
	return req;
}

static void dcerpc_drepl_takeFSMORole_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_drepl_takeFSMORole_state *state = tevent_req_data(
		req, struct dcerpc_drepl_takeFSMORole_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_drepl_takeFSMORole_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_drepl_takeFSMORole_recv(struct tevent_req *req,
					TALLOC_CTX *mem_ctx,
					WERROR *result)
{
	struct dcerpc_drepl_takeFSMORole_state *state = tevent_req_data(
		req, struct dcerpc_drepl_takeFSMORole_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_drepl_takeFSMORole(struct dcerpc_binding_handle *h,
				   TALLOC_CTX *mem_ctx,
				   enum drepl_role_master _role /* [in]  */,
				   WERROR *result)
{
	struct drepl_takeFSMORole r;
	NTSTATUS status;

	/* In parameters */
	r.in.role = _role;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_drepl_takeFSMORole_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_drepl_trigger_repl_secret_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_drepl_trigger_repl_secret_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_drepl_trigger_repl_secret_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct drepl_trigger_repl_secret *r)
{
	struct tevent_req *req;
	struct dcerpc_drepl_trigger_repl_secret_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_drepl_trigger_repl_secret_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_irpc,
			NDR_DREPL_TRIGGER_REPL_SECRET, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_drepl_trigger_repl_secret_r_done, req);

	return req;
}

static void dcerpc_drepl_trigger_repl_secret_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_drepl_trigger_repl_secret_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_drepl_trigger_repl_secret_r_state *state =
		tevent_req_data(req,
		struct dcerpc_drepl_trigger_repl_secret_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_drepl_trigger_repl_secret_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct drepl_trigger_repl_secret *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_irpc,
			NDR_DREPL_TRIGGER_REPL_SECRET, mem_ctx, r);

	return status;
}

struct dcerpc_drepl_trigger_repl_secret_state {
	struct drepl_trigger_repl_secret orig;
	struct drepl_trigger_repl_secret tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_drepl_trigger_repl_secret_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_drepl_trigger_repl_secret_send(TALLOC_CTX *mem_ctx,
							 struct tevent_context *ev,
							 struct dcerpc_binding_handle *h,
							 const char * _user_dn /* [in] [flag(LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM)] */)
{
	struct tevent_req *req;
	struct dcerpc_drepl_trigger_repl_secret_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_drepl_trigger_repl_secret_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.user_dn = _user_dn;

	/* Out parameters */

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_drepl_trigger_repl_secret_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_drepl_trigger_repl_secret_done, req);
	return req;
}

static void dcerpc_drepl_trigger_repl_secret_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_drepl_trigger_repl_secret_state *state = tevent_req_data(
		req, struct dcerpc_drepl_trigger_repl_secret_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_drepl_trigger_repl_secret_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_drepl_trigger_repl_secret_recv(struct tevent_req *req,
					       TALLOC_CTX *mem_ctx)
{
	struct dcerpc_drepl_trigger_repl_secret_state *state = tevent_req_data(
		req, struct dcerpc_drepl_trigger_repl_secret_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_drepl_trigger_repl_secret(struct dcerpc_binding_handle *h,
					  TALLOC_CTX *mem_ctx,
					  const char * _user_dn /* [in] [flag(LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM)] */)
{
	struct drepl_trigger_repl_secret r;
	NTSTATUS status;

	/* In parameters */
	r.in.user_dn = _user_dn;

	/* Out parameters */

	status = dcerpc_drepl_trigger_repl_secret_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */

	return NT_STATUS_OK;
}

struct dcerpc_dnsupdate_RODC_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_dnsupdate_RODC_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_dnsupdate_RODC_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct dnsupdate_RODC *r)
{
	struct tevent_req *req;
	struct dcerpc_dnsupdate_RODC_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_dnsupdate_RODC_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_irpc,
			NDR_DNSUPDATE_RODC, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_dnsupdate_RODC_r_done, req);

	return req;
}

static void dcerpc_dnsupdate_RODC_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_dnsupdate_RODC_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_dnsupdate_RODC_r_state *state =
		tevent_req_data(req,
		struct dcerpc_dnsupdate_RODC_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_dnsupdate_RODC_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct dnsupdate_RODC *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_irpc,
			NDR_DNSUPDATE_RODC, mem_ctx, r);

	return status;
}

struct dcerpc_dnsupdate_RODC_state {
	struct dnsupdate_RODC orig;
	struct dnsupdate_RODC tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_dnsupdate_RODC_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_dnsupdate_RODC_send(TALLOC_CTX *mem_ctx,
					      struct tevent_context *ev,
					      struct dcerpc_binding_handle *h,
					      struct dom_sid *_dom_sid /* [in] [unique] */,
					      const char *_site_name /* [in] [charset(UTF16),unique] */,
					      uint32_t _dns_ttl /* [in]  */,
					      struct NL_DNS_NAME_INFO_ARRAY *_dns_names /* [in,out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_dnsupdate_RODC_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_dnsupdate_RODC_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.dom_sid = _dom_sid;
	state->orig.in.site_name = _site_name;
	state->orig.in.dns_ttl = _dns_ttl;
	state->orig.in.dns_names = _dns_names;

	/* Out parameters */
	state->orig.out.dns_names = _dns_names;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_dnsupdate_RODC_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_dnsupdate_RODC_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_dnsupdate_RODC_done, req);
	return req;
}

static void dcerpc_dnsupdate_RODC_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_dnsupdate_RODC_state *state = tevent_req_data(
		req, struct dcerpc_dnsupdate_RODC_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_dnsupdate_RODC_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.dns_names = *state->tmp.out.dns_names;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_dnsupdate_RODC_recv(struct tevent_req *req,
				    TALLOC_CTX *mem_ctx,
				    NTSTATUS *result)
{
	struct dcerpc_dnsupdate_RODC_state *state = tevent_req_data(
		req, struct dcerpc_dnsupdate_RODC_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_dnsupdate_RODC(struct dcerpc_binding_handle *h,
			       TALLOC_CTX *mem_ctx,
			       struct dom_sid *_dom_sid /* [in] [unique] */,
			       const char *_site_name /* [in] [charset(UTF16),unique] */,
			       uint32_t _dns_ttl /* [in]  */,
			       struct NL_DNS_NAME_INFO_ARRAY *_dns_names /* [in,out] [ref] */,
			       NTSTATUS *result)
{
	struct dnsupdate_RODC r;
	NTSTATUS status;

	/* In parameters */
	r.in.dom_sid = _dom_sid;
	r.in.site_name = _site_name;
	r.in.dns_ttl = _dns_ttl;
	r.in.dns_names = _dns_names;

	/* Out parameters */
	r.out.dns_names = _dns_names;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_dnsupdate_RODC_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_dns_names = *r.out.dns_names;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_dnssrv_reload_dns_zones_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_dnssrv_reload_dns_zones_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_dnssrv_reload_dns_zones_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct dnssrv_reload_dns_zones *r)
{
	struct tevent_req *req;
	struct dcerpc_dnssrv_reload_dns_zones_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_dnssrv_reload_dns_zones_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_irpc,
			NDR_DNSSRV_RELOAD_DNS_ZONES, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_dnssrv_reload_dns_zones_r_done, req);

	return req;
}

static void dcerpc_dnssrv_reload_dns_zones_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_dnssrv_reload_dns_zones_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_dnssrv_reload_dns_zones_r_state *state =
		tevent_req_data(req,
		struct dcerpc_dnssrv_reload_dns_zones_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_dnssrv_reload_dns_zones_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct dnssrv_reload_dns_zones *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_irpc,
			NDR_DNSSRV_RELOAD_DNS_ZONES, mem_ctx, r);

	return status;
}

struct dcerpc_dnssrv_reload_dns_zones_state {
	struct dnssrv_reload_dns_zones orig;
	struct dnssrv_reload_dns_zones tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_dnssrv_reload_dns_zones_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_dnssrv_reload_dns_zones_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct dcerpc_binding_handle *h)
{
	struct tevent_req *req;
	struct dcerpc_dnssrv_reload_dns_zones_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_dnssrv_reload_dns_zones_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_dnssrv_reload_dns_zones_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_dnssrv_reload_dns_zones_done, req);
	return req;
}

static void dcerpc_dnssrv_reload_dns_zones_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_dnssrv_reload_dns_zones_state *state = tevent_req_data(
		req, struct dcerpc_dnssrv_reload_dns_zones_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_dnssrv_reload_dns_zones_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_dnssrv_reload_dns_zones_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     NTSTATUS *result)
{
	struct dcerpc_dnssrv_reload_dns_zones_state *state = tevent_req_data(
		req, struct dcerpc_dnssrv_reload_dns_zones_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_dnssrv_reload_dns_zones(struct dcerpc_binding_handle *h,
					TALLOC_CTX *mem_ctx,
					NTSTATUS *result)
{
	struct dnssrv_reload_dns_zones r;
	NTSTATUS status;

	/* In parameters */

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_dnssrv_reload_dns_zones_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

