/**
 *
 * @file c_refine_functions.h
 *
 * PaStiX refinement functions implementations.
 *
 * @copyright 2015-2024 Bordeaux INP, CNRS (LaBRI UMR 5800), Inria,
 *                      Univ. Bordeaux. All rights reserved.
 *
 * @version 6.4.0
 * @author Mathieu Faverge
 * @author Pierre Ramet
 * @author Xavier Lacoste
 * @author Gregoire Pichon
 * @author Theophile Terraz
 * @author Vincent Bridonneau
 * @date 2024-07-05
 * @generated from /build/pastix/src/pastix-6.4.0/refinement/z_refine_functions.h, normal z -> c, Thu Oct 23 06:51:46 2025
 *
 * @addtogroup pastix_dev_refine
 * @{
 *   @brief TODO.
 *
 **/

#ifndef _c_refine_functions_h_
#define _c_refine_functions_h_

#include "common.h"
#include "bcsc/bcsc.h"

#ifndef DOXYGEN_SHOULD_SKIP_THIS
/**
 * @brief TODO
 */
struct c_solver
{
    pastix_int_t    (* getN   )   (pastix_data_t *);
    pastix_fixdbl_t (* getEps )   (pastix_data_t *);
    pastix_int_t    (* getImax)   (pastix_data_t *);
    pastix_int_t    (* getRestart)(pastix_data_t *);

    void* (*malloc)(size_t);
    void  (*free)(void*);

    void   (*output_oneiter)( pastix_fixdbl_t, pastix_fixdbl_t, float, pastix_int_t);
    void   (*output_final)( pastix_data_t *, pastix_complex32_t, pastix_int_t,
                            pastix_fixdbl_t, void*, pastix_complex32_t*);

    void   (*scal)( pastix_data_t *, pastix_int_t, pastix_complex32_t, pastix_complex32_t * );
    pastix_complex32_t (*dot) ( pastix_data_t *, pastix_int_t, const pastix_complex32_t *, const pastix_complex32_t * );
    void   (*copy)( pastix_data_t *, pastix_int_t, const pastix_complex32_t *, pastix_complex32_t * );
    void   (*axpy)( pastix_data_t *, pastix_int_t, pastix_complex32_t, const pastix_complex32_t *, pastix_complex32_t *);
    void   (*spmv)( const pastix_data_t *, pastix_trans_t, pastix_complex32_t, const pastix_complex32_t *, pastix_complex32_t, pastix_complex32_t * );
    void   (*spsv)( pastix_data_t *, pastix_complex32_t *, pastix_complex32_t * );
    float (*norm)( pastix_data_t *, pastix_int_t, const pastix_complex32_t * );
    void   (*gemv)( pastix_data_t *, pastix_int_t, pastix_int_t,
                    pastix_complex32_t, const pastix_complex32_t *, pastix_int_t,
                    const pastix_complex32_t *, pastix_complex32_t, pastix_complex32_t *);
};
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

void c_refine_init(struct c_solver *, pastix_data_t*);

pastix_int_t c_gmres_smp   ( pastix_data_t *pastix_data, pastix_rhs_t xp, pastix_rhs_t bp );
pastix_int_t c_grad_smp    ( pastix_data_t *pastix_data, pastix_rhs_t xp, pastix_rhs_t bp );
pastix_int_t c_pivot_smp   ( pastix_data_t *pastix_data, pastix_rhs_t xp, pastix_rhs_t bp );
pastix_int_t c_bicgstab_smp( pastix_data_t *pastix_data, pastix_rhs_t xp, pastix_rhs_t bp );

/**
 * @}
 */
#endif /* _c_refine_functions_h_ */
